/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.api.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.CuriosHelper;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncStack;

public class TrinketHelper {
    public static void unequipTrinketStack(LivingEntity entity, ItemStack stack, String slotKey, int slotIndex) {
        entity.getCapability(CuriosCapability.INVENTORY).map(handler -> handler.getStacksHandler(slotKey).map(stackHandler -> {
            int slotCount = stackHandler.getSlots();
            if (slotIndex >= slotCount) {
                return false;
            }
            NonNullList renderStates = stackHandler.getRenders();
            SlotContext slotContext = new SlotContext(slotKey, entity, slotIndex, false, renderStates.size() > slotIndex && (Boolean)renderStates.get(slotIndex) != false);
            CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(iCurio -> iCurio.onUnequip(slotContext, stack));
            stackHandler.getStacks().setStackInSlot(slotIndex, stack);
            return true;
        }).orElse(false));
    }

    public static void clearCurios(Player entity) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)entity).ifPresent(handler -> handler.getCurios().values().forEach(stacksHandler -> {
            IDynamicStackHandler stackHandler = stacksHandler.getStacks();
            IDynamicStackHandler cosmeticStackHandler = stacksHandler.getCosmeticStacks();
            String id = stacksHandler.getIdentifier();
            if (!id.equals("trinket_pouch")) {
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    UUID uuid = UUID.nameUUIDFromBytes((id + i).getBytes());
                    NonNullList renderStates = stacksHandler.getRenders();
                    SlotContext slotContext = new SlotContext(id, (LivingEntity)entity, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false);
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    Multimap map = CuriosApi.getCuriosHelper().getAttributeModifiers(slotContext, uuid, stack);
                    HashMultimap slots = HashMultimap.create();
                    HashSet<CuriosHelper.SlotAttributeWrapper> toRemove = new HashSet<CuriosHelper.SlotAttributeWrapper>();
                    for (Attribute attribute : map.keySet()) {
                        if (!(attribute instanceof CuriosHelper.SlotAttributeWrapper)) continue;
                        CuriosHelper.SlotAttributeWrapper wrapper = (CuriosHelper.SlotAttributeWrapper)attribute;
                        slots.putAll((Object)wrapper.identifier, (Iterable)map.get((Object)attribute));
                        toRemove.add(wrapper);
                    }
                    for (Attribute attribute : toRemove) {
                        map.removeAll((Object)attribute);
                    }
                    entity.m_21204_().m_22161_(map);
                    handler.removeSlotModifiers((Multimap)slots);
                    CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(curio -> curio.onUnequip(slotContext, stack));
                    stackHandler.setStackInSlot(i, ItemStack.f_41583_);
                    NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new SPacketSyncStack(entity.m_142049_(), id, i, ItemStack.f_41583_, SPacketSyncStack.HandlerType.EQUIPMENT, new CompoundTag()));
                    cosmeticStackHandler.setStackInSlot(i, ItemStack.f_41583_);
                    NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new SPacketSyncStack(entity.m_142049_(), id, i, ItemStack.f_41583_, SPacketSyncStack.HandlerType.COSMETIC, new CompoundTag()));
                }
            }
        }));
    }
}

