/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.api.util;

import iskallia.vault.VaultMod;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.init.ModConfigs;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class VaultModifierUtils {
    private static final TextComponent MODIFIER_ADDED_SUFFIX = new TextComponent(" was added to the vault.");

    public static void sendModifierAddedMessage(ServerPlayer player, VaultModifier<?> modifier, Integer stackSize) {
        player.m_5661_((Component)modifier.getChatDisplayNameComponent(stackSize.intValue()).m_6881_().m_7220_((Component)MODIFIER_ADDED_SUFFIX), false);
    }

    public static void addModifier(Vault vault, ResourceLocation modifier, int count) {
        VaultModifier vaultModifier = VaultModifierRegistry.get((ResourceLocation)modifier);
        if (vaultModifier != null) {
            ((Modifiers)vault.get(Vault.MODIFIERS)).addModifier(vaultModifier, count, true, (RandomSource)ChunkRandom.any());
        }
    }

    public static void addTimedModifier(Vault vault, ResourceLocation modifierId, int count, int duration, Player player) {
        VaultModifierRegistry.getOpt((ResourceLocation)modifierId).ifPresent(modifier -> {
            ((Modifiers)vault.get(Vault.MODIFIERS)).addModifier(modifier, count, true, (RandomSource)ChunkRandom.ofNanoTime(), context -> {
                if (duration > 0) {
                    context.set(ModifierContext.TICKS_LEFT, (Object)duration);
                }
            });
            MutableComponent modifierMessage = new TextComponent("").m_7220_(player.m_5446_()).m_7220_((Component)new TextComponent(" added ").m_130940_(ChatFormatting.GRAY)).m_7220_(modifier.getChatDisplayNameComponent(count)).m_7220_((Component)new TextComponent(" for ").m_130940_(ChatFormatting.GRAY));
            MutableComponent text = modifierMessage.m_7220_((Component)new TextComponent(duration / 20 + " seconds")).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
            for (Listener listener : ((Listeners)vault.get(Vault.LISTENERS)).getAll()) {
                listener.getPlayer().ifPresent(arg_0 -> VaultModifierUtils.lambda$addTimedModifier$1(player, (Component)text, arg_0));
            }
        });
    }

    public static void addModifierFromPool(Vault vault, ResourceLocation modifierPool) {
        List modifiers = ModConfigs.VAULT_MODIFIER_POOLS.getRandom(modifierPool, 0, (RandomSource)JavaRandom.ofNanoTime());
        if (!modifiers.isEmpty()) {
            Iterator modIter = modifiers.iterator();
            VaultModifier modifier = VaultModifierRegistry.get((ResourceLocation)VaultMod.id((String)"empty"));
            while (modIter.hasNext()) {
                VaultModifier mod;
                modifier = mod = (VaultModifier)modIter.next();
                ((Modifiers)vault.get(Vault.MODIFIERS)).addModifier(mod, 1, true, (RandomSource)ChunkRandom.any());
            }
            if (modifier.getId().equals((Object)VaultMod.id((String)"empty"))) {
                return;
            }
            for (Listener listener : ((Listeners)vault.get(Vault.LISTENERS)).getAll()) {
                listener.getPlayer().ifPresent(other -> VaultModifierUtils.sendModifierAddedMessage(other, (VaultModifier)modifiers.get(0), 1));
            }
        }
    }

    public static boolean hasCountOfModifiers(Vault vault, ResourceLocation modifierId, int count) {
        List modifiers = ((Modifiers)vault.get(Vault.MODIFIERS)).getModifiers();
        return modifiers.stream().filter(modifier -> modifier.getId().equals((Object)modifierId)).count() >= (long)count;
    }

    private static /* synthetic */ void lambda$addTimedModifier$1(Player player, Component text, ServerPlayer other) {
        player.m_183503_().m_6263_((Player)null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
        other.m_5661_(text, false);
    }
}

