/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.api.util;

import iskallia.vault.VaultMod;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.util.MiscUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class WoldGearModifierHelper {
    public static GearModification.Result addUnusualModifier(ItemStack stack, long worldGameTime, Random random) {
        VaultGearModifier.AffixType type;
        VaultGearModifier modifier2;
        VaultGearData data = VaultGearData.read((ItemStack)stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig((ItemStack)stack).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("Unknown VaultGear: " + stack);
            return GearModification.Result.errorUnmodifiable();
        }
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        int itemLevel = data.getItemLevel();
        int prefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0);
        int suffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0);
        prefixes -= data.getModifiers(VaultGearModifier.AffixType.PREFIX).size();
        suffixes -= data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size();
        boolean hasUnusual = false;
        Iterator iterator = data.getModifiers(VaultGearModifier.AffixType.PREFIX).iterator();
        while (iterator.hasNext() && !(hasUnusual = (modifier2 = (VaultGearModifier)iterator.next()).getCategories().contains((Object)VaultGearModifier.AffixCategory.valueOf((String)"UNUSUAL")))) {
        }
        if (hasUnusual) {
            return GearModification.Result.makeActionError((String)"full", (Component[])new Component[0]);
        }
        iterator = data.getModifiers(VaultGearModifier.AffixType.SUFFIX).iterator();
        while (iterator.hasNext() && !(hasUnusual = (modifier2 = (VaultGearModifier)iterator.next()).getCategories().contains((Object)VaultGearModifier.AffixCategory.valueOf((String)"UNUSUAL")))) {
        }
        if (hasUnusual) {
            return GearModification.Result.makeActionError((String)"full", (Component[])new Component[0]);
        }
        if (prefixes <= 0 && suffixes <= 0) {
            return GearModification.Result.makeActionError((String)"full", (Component[])new Component[0]);
        }
        ArrayList<VaultGearModifier.AffixType> types = new ArrayList<VaultGearModifier.AffixType>();
        if (prefixes > 0) {
            types.add(VaultGearModifier.AffixType.PREFIX);
        }
        if (suffixes > 0) {
            types.add(VaultGearModifier.AffixType.SUFFIX);
        }
        if ((type = (VaultGearModifier.AffixType)MiscUtils.getRandomEntry(types, (Random)random)) == null) {
            return GearModification.Result.errorInternal();
        }
        VaultGearTierConfig.ModifierAffixTagGroup modifierAffixTagGroup = VaultGearTierConfig.ModifierAffixTagGroup.valueOf((String)"UNUSUAL_PREFIX");
        if (type.equals((Object)VaultGearModifier.AffixType.PREFIX)) {
            return cfg.getRandomModifier(modifierAffixTagGroup, itemLevel, random, data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS)).map(modifier -> {
                data.getAllModifierAffixes().forEach(VaultGearModifier::resetGameTimeAdded);
                modifier.setGameTimeAdded(worldGameTime);
                modifier.addCategory(VaultGearModifier.AffixCategory.valueOf((String)"UNUSUAL"));
                data.addModifier(type, modifier);
                data.write(stack);
                return GearModification.Result.makeSuccess();
            }).orElse(GearModification.Result.makeActionError((String)"no_modifiers", (Component[])new Component[0]));
        }
        if (type.equals((Object)VaultGearModifier.AffixType.SUFFIX)) {
            return cfg.getRandomModifier(VaultGearTierConfig.ModifierAffixTagGroup.valueOf((String)"UNUSUAL_SUFFIX"), itemLevel, random, data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS)).map(modifier -> {
                data.getAllModifierAffixes().forEach(VaultGearModifier::resetGameTimeAdded);
                modifier.setGameTimeAdded(worldGameTime);
                modifier.addCategory(VaultGearModifier.AffixCategory.valueOf((String)"UNUSUAL"));
                data.addModifier(type, modifier);
                data.write(stack);
                return GearModification.Result.makeSuccess();
            }).orElse(GearModification.Result.makeActionError((String)"no_modifiers", (Component[])new Component[0]));
        }
        return GearModification.Result.errorInternal();
    }

    public static GearModification.Result removeRandomModifierAlways(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read((ItemStack)stack);
        ArrayList<VaultGearModifier> affixes = new ArrayList<VaultGearModifier>();
        affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.PREFIX));
        affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.SUFFIX));
        affixes.removeIf(modifier -> !modifier.hasNoCategoryMatching(VaultGearModifier.AffixCategory::cannotBeModifiedByArtisanFoci));
        if (affixes.isEmpty()) {
            return GearModification.Result.makeActionError((String)"no_modifiers", (Component[])new Component[0]);
        }
        VaultGearModifier randomMod = (VaultGearModifier)MiscUtils.getRandomEntry(affixes, (Random)random);
        data.removeModifier(randomMod);
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    public static GearModification.Result unfreezeAll(ItemStack stack) {
        VaultGearData data = VaultGearData.read((ItemStack)stack);
        ArrayList<VaultGearModifier> affixes = new ArrayList<VaultGearModifier>();
        affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.PREFIX));
        affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.SUFFIX));
        affixes.removeIf(modifier -> !modifier.hasCategory(VaultGearModifier.AffixCategory.FROZEN));
        if (affixes.isEmpty()) {
            return GearModification.Result.makeActionError((String)"no_modifiers", (Component[])new Component[0]);
        }
        for (VaultGearModifier mod : affixes) {
            mod.removeCategory(VaultGearModifier.AffixCategory.FROZEN);
        }
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    public static GearModification.Result freezeAll(ItemStack stack) {
        VaultGearData data = VaultGearData.read((ItemStack)stack);
        ArrayList<VaultGearModifier> affixes = new ArrayList<VaultGearModifier>();
        affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.PREFIX));
        affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.SUFFIX));
        affixes.removeIf(modifier -> modifier.hasCategory(VaultGearModifier.AffixCategory.FROZEN));
        if (affixes.isEmpty()) {
            return GearModification.Result.makeActionError((String)"no_modifiers", (Component[])new Component[0]);
        }
        for (VaultGearModifier mod : affixes) {
            mod.addCategory(VaultGearModifier.AffixCategory.FROZEN);
        }
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    public static GearModification.Result freezeGoodModifier(ItemStack stack) {
        VaultGearData data = VaultGearData.read((ItemStack)stack);
        ArrayList<VaultGearModifier> affixes = new ArrayList<VaultGearModifier>();
        affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.PREFIX));
        affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.SUFFIX));
        if (affixes.stream().anyMatch(modifier -> modifier.hasCategory(VaultGearModifier.AffixCategory.FROZEN))) {
            return GearModification.Result.makeActionError((String)"frozen", (Component[])new Component[0]);
        }
        affixes.removeIf(modifier -> modifier.hasCategory(VaultGearModifier.AffixCategory.FROZEN) || !modifier.hasCategory(VaultGearModifier.AffixCategory.CORRUPTED) && !modifier.hasCategory(VaultGearModifier.AffixCategory.LEGENDARY) && !modifier.hasCategory(VaultGearModifier.AffixCategory.GREATER) && !modifier.hasCategory(VaultGearModifier.AffixCategory.valueOf((String)"UNUSUAL")));
        if (affixes.isEmpty()) {
            return GearModification.Result.makeActionError((String)"no_modifiers", (Component[])new Component[0]);
        }
        Iterator iterator = affixes.iterator();
        if (iterator.hasNext()) {
            VaultGearModifier mod = (VaultGearModifier)iterator.next();
            mod.addCategory(VaultGearModifier.AffixCategory.FROZEN);
        }
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }
}

