/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.api.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.TextComponentUtils;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoldTexFX {
    public static MutableComponent legendaryShimmer(MutableComponent cmp) {
        return WoldTexFX.legendaryShimmer(null, cmp);
    }

    public static MutableComponent legendaryShimmer(Style style, MutableComponent cmp) {
        Style shine = style == null ? Style.f_131099_.m_131140_(ChatFormatting.WHITE) : style;
        int cmpLength = TextComponentUtils.getLength((Component)cmp);
        int time = (int)((double)cmpLength * 1.4);
        int step = (int)(System.currentTimeMillis() / 90L % (long)time);
        if (step >= cmpLength) {
            return cmp;
        }
        int stepCap = Math.min(step + 1, cmpLength);
        CommandSourceStack stack = TextComponentUtils.createClientSourceStack();
        MutableComponent startCmp = TextComponentUtils.substring((CommandSourceStack)stack, (Component)cmp, (int)0, (int)step);
        MutableComponent highlight = TextComponentUtils.substring((CommandSourceStack)stack, (Component)cmp, (int)step, (int)stepCap);
        MutableComponent endCmp = TextComponentUtils.substring((CommandSourceStack)stack, (Component)cmp, (int)stepCap);
        TextComponentUtils.applyStyle((Component)highlight, (Style)shine);
        return startCmp.m_7220_((Component)highlight).m_7220_((Component)endCmp);
    }

    public static MutableComponent corruptedEffect(MutableComponent cmp) {
        return WoldTexFX.corruptedEffect(null, cmp);
    }

    public static MutableComponent corruptedEffect(Style style, MutableComponent cmp) {
        Style corrupt = style == null ? Style.f_131099_ : style;
        int cmpLength = TextComponentUtils.getLength((Component)cmp);
        int time = (int)((double)cmpLength * 2.2);
        int step = (int)(System.currentTimeMillis() / 150L % (long)time);
        if (step >= cmpLength) {
            return cmp;
        }
        List indices = IntStream.range(0, cmpLength).boxed().collect(Collectors.toList());
        Random rand = new Random(cmp.getString().hashCode());
        Collections.shuffle(indices, rand);
        step = (Integer)indices.get(step);
        int stepCap = Math.min(step + 1, cmpLength);
        CommandSourceStack stack = TextComponentUtils.createClientSourceStack();
        MutableComponent startCmp = TextComponentUtils.substring((CommandSourceStack)stack, (Component)cmp, (int)0, (int)step);
        MutableComponent highlight = TextComponentUtils.substring((CommandSourceStack)stack, (Component)cmp, (int)step, (int)stepCap);
        MutableComponent endCmp = TextComponentUtils.substring((CommandSourceStack)stack, (Component)cmp, (int)stepCap);
        TextComponentUtils.applyStyle((Component)highlight, (Style)corrupt.m_178524_(Boolean.valueOf(true)));
        return startCmp.m_7220_((Component)highlight).m_7220_((Component)endCmp);
    }

    public static MutableComponent enclose(String prefix, MutableComponent cmp) {
        return WoldTexFX.enclose(prefix, "", null, cmp);
    }

    public static MutableComponent enclose(String prefix, Style style, MutableComponent cmp) {
        return WoldTexFX.enclose(prefix, "", style, cmp);
    }

    public static MutableComponent enclose(String prefix, String suffix, MutableComponent cmp) {
        return WoldTexFX.enclose(prefix, suffix, null, cmp);
    }

    public static MutableComponent enclose(String prefix, String suffix, Style style, MutableComponent cmp) {
        TextComponent pCmp = new TextComponent(prefix);
        TextComponent sCmp = new TextComponent(suffix);
        Style newStyle = style != null ? style : cmp.m_7383_();
        pCmp.m_130948_(newStyle);
        sCmp.m_130948_(newStyle);
        return pCmp.m_7220_((Component)cmp).m_7220_((Component)sCmp);
    }

    public static class Fresh<T>
    extends FancyReader<T> {
        private final String text;
        private final Style style;

        public Fresh(String text, VaultGearModifierReader<T> reader) {
            this(text, null, reader);
        }

        public Fresh(Style style, VaultGearModifierReader<T> reader) {
            this("", style, reader);
        }

        public Fresh(String text, Style style, VaultGearModifierReader<T> reader) {
            super(reader);
            this.text = text;
            this.style = style;
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<T> instance, VaultGearModifier.AffixType affixType) {
            if (this.reader == null) {
                return null;
            }
            if (this.style == null) {
                return new TextComponent(this.text).m_6270_(this.reader.getDisplay(instance, affixType).m_7383_());
            }
            return new TextComponent(this.text).m_6270_(this.style);
        }
    }

    public static class Enclose<T>
    extends FancyReader<T> {
        private final String prefix;
        private final String suffix;
        private final Style style;

        public Enclose(Style style, VaultGearModifierReader<T> reader) {
            this("", "", style, reader);
        }

        public Enclose(String prefix, VaultGearModifierReader<T> reader) {
            this(prefix, "", null, reader);
        }

        public Enclose(String prefix, String suffix, VaultGearModifierReader<T> reader) {
            this(prefix, suffix, null, reader);
        }

        public Enclose(String prefix, Style style, VaultGearModifierReader<T> reader) {
            this(prefix, "", style, reader);
        }

        public Enclose(String prefix, String suffix, Style style, VaultGearModifierReader<T> reader) {
            super(reader);
            this.prefix = prefix;
            this.suffix = suffix;
            this.style = null;
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<T> instance, VaultGearModifier.AffixType affixType) {
            return this.reader == null ? null : WoldTexFX.enclose(this.prefix, this.suffix, this.style, this.reader.getDisplay(instance, affixType));
        }
    }

    public static class Shimmer<T>
    extends FancyReader<T> {
        private final Style style;

        public Shimmer(VaultGearModifierReader<T> reader) {
            this(null, reader);
        }

        public Shimmer(Style style, VaultGearModifierReader<T> reader) {
            super(reader);
            this.style = style;
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<T> instance, VaultGearModifier.AffixType affixType) {
            return this.reader == null ? null : WoldTexFX.legendaryShimmer(this.style, this.reader.getDisplay(instance, affixType));
        }
    }

    public static class Corrupted<T>
    extends FancyReader<T> {
        private final Style style;

        public Corrupted(VaultGearModifierReader<T> reader) {
            this(null, reader);
        }

        public Corrupted(Style style, VaultGearModifierReader<T> reader) {
            super(reader);
            this.style = style;
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<T> instance, VaultGearModifier.AffixType affixType) {
            return this.reader == null ? null : WoldTexFX.corruptedEffect(this.style, this.reader.getDisplay(instance, affixType));
        }
    }

    public static abstract class FancyReader<T>
    extends VaultGearModifierReader<T> {
        final VaultGearModifierReader<T> reader;

        public FancyReader(VaultGearModifierReader<T> reader) {
            super(reader.getModifierName(), reader.getRgbColor());
            this.reader = reader;
        }

        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<T> instance, VaultGearModifier.AffixType type) {
            return this.reader.getDisplay(instance, type);
        }

        @Nullable
        public MutableComponent getValueDisplay(T t) {
            return this.reader.getValueDisplay(t);
        }

        @NotNull
        public JsonObject serializeDisplay(VaultGearAttributeInstance<T> instance, VaultGearModifier.AffixType type) {
            return this.reader.serializeDisplay(instance, type);
        }

        public MutableComponent formatConfigDisplay(LogicalSide side, Component configRange) {
            return this.reader.formatConfigDisplay(side, configRange);
        }

        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<T> instance, VaultGearModifier.AffixType type) {
        }
    }
}

