/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.blocks;

import iskallia.vault.init.ModItems;
import iskallia.vault.util.VHSmpUtil;
import iskallia.vault.world.data.ServerVaults;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.woldsvaults.blocks.tiles.DollDismantlingTileEntity;
import xyz.iwolfking.woldsvaults.init.ModBlocks;

public class DollDismantlingBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static VoxelShape DOLL_DISMANTLING_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), Block.m_49796_((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)20.0, (double)13.0), Block.m_49796_((double)2.0, (double)20.0, (double)2.0, (double)14.0, (double)21.0, (double)14.0), Block.m_49796_((double)3.0, (double)21.0, (double)3.0, (double)13.0, (double)23.0, (double)13.0), Block.m_49796_((double)6.0, (double)23.0, (double)6.0, (double)10.0, (double)24.0, (double)10.0)});
    private final VoxelShape SHAPE;

    public DollDismantlingBlock(BlockBehaviour.Properties properties, VoxelShape shape) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
        this.SHAPE = shape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return (BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.SHAPE;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity tile = level.m_7702_(pos);
            if (tile instanceof DollDismantlingTileEntity) {
                DollDismantlingTileEntity table = (DollDismantlingTileEntity)tile;
                ItemStack stack = serverPlayer.m_21205_();
                if (stack.m_150930_((Item)ModItems.VAULT_DOLL) && ServerVaults.get((Level)serverPlayer.m_183503_()).isEmpty() && !VHSmpUtil.isArenaWorld((Entity)player) && stack.m_41784_().m_128441_("vaultUUID") && table.playerCanInsertDoll(stack, player)) {
                    if (!table.getDoll().m_41619_()) {
                        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)table.getInventory().getStackInSlot(0));
                        table.getInventory().setStackInSlot(0, ItemStack.f_41583_);
                    }
                    ItemStack copy = serverPlayer.m_21205_().m_41777_();
                    copy.m_41764_(1);
                    serverPlayer.m_21205_().m_41774_(1);
                    table.updateDoll(copy, serverPlayer);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (!state.m_60713_(newState.m_60734_()) && (tile = level.m_7702_(pos)) instanceof DollDismantlingTileEntity) {
            DollDismantlingTileEntity table = (DollDismantlingTileEntity)tile;
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)table.getInventory().getStackInSlot(0));
            table.getInventory().setStackInSlot(0, ItemStack.f_41583_);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ModBlocks.DOLL_DISMANTLING_TILE_ENTITY_BLOCK_ENTITY_TYPE.m_155264_(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return DollDismantlingBlock.createTickerHelper(type, ModBlocks.DOLL_DISMANTLING_TILE_ENTITY_BLOCK_ENTITY_TYPE, (world, pos, blockState, tileEntity) -> tileEntity.tick());
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> type, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return type == expectedType ? ticker : null;
    }
}

