/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.blocks;

import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.item.GatePearlItem;
import xyz.iwolfking.woldsvaults.api.util.GTEHelper;

public class GatewayChannelingBlock
extends Block {
    public static final BooleanProperty USED = BooleanProperty.m_61465_((String)"used");

    public GatewayChannelingBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)USED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (((Boolean)pState.m_61143_((Property)USED)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        if (pPlayer.m_21120_(pHand).m_41720_() instanceof GatePearlItem) {
            return this.attemptSpawnGateway(pLevel, pPlayer.m_21120_(pHand), pPos, pPlayer);
        }
        return this.attemptSpawnGateway(pLevel, pPlayer.m_21120_(pHand), pPos, pPlayer, true);
    }

    private InteractionResult attemptSpawnGateway(Level world, ItemStack stack, BlockPos pos, Player player) {
        return this.attemptSpawnGateway(world, stack, pos, player, false);
    }

    private InteractionResult attemptSpawnGateway(Level world, ItemStack stack, BlockPos pos, Player player, boolean randomGateway) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!world.m_45976_(GatewayEntity.class, new AABB(pos).m_82377_(25.0, 25.0, 25.0)).isEmpty()) {
            return InteractionResult.FAIL;
        }
        GatewayEntity entity = null;
        if (randomGateway) {
            player.m_6352_((Component)new TextComponent("Opening random gateway...").m_130940_(ChatFormatting.LIGHT_PURPLE), Util.f_137441_);
            entity = new GatewayEntity(world, player, GTEHelper.getRandomGate());
        } else {
            entity = new GatewayEntity(world, player, GatePearlItem.getGate((ItemStack)stack));
        }
        if (entity == null) {
            return InteractionResult.FAIL;
        }
        BlockState state = world.m_8055_(pos);
        entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + state.m_60808_((BlockGetter)world, pos).m_83297_(Direction.Axis.Y), (double)pos.m_123343_() + 0.5);
        int y = 0;
        while (y++ < 4 && !world.m_45786_((Entity)entity)) {
            entity.m_6034_(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_());
        }
        if (!world.m_45786_((Entity)entity)) {
            player.m_6352_((Component)new TranslatableComponent("error.gateways.no_space").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return InteractionResult.FAIL;
        }
        world.m_7967_((Entity)entity);
        entity.onGateCreated();
        if (!player.m_7500_() && !randomGateway) {
            stack.m_41774_(1);
        }
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)USED, (Comparable)Boolean.valueOf(true)));
        return InteractionResult.CONSUME;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{USED});
    }
}

