/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.blocks.containers;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.slot.OutputSlot;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import xyz.iwolfking.woldsvaults.blocks.containers.lib.infuser.CatalystSlot;
import xyz.iwolfking.woldsvaults.blocks.containers.lib.infuser.InfuserIngredientSlot;
import xyz.iwolfking.woldsvaults.blocks.tiles.VaultInfuserTileEntity;
import xyz.iwolfking.woldsvaults.data.recipes.CachedInfuserRecipeData;
import xyz.iwolfking.woldsvaults.init.ModContainers;

public class VaultInfuserContainer
extends AbstractContainerMenu {
    private final Function<Player, Boolean> isUsableByPlayer;
    private final ContainerData data;
    private final BlockPos pos;
    private final Level level;

    private VaultInfuserContainer(MenuType<?> type, int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(type, id, playerInventory, p -> false, VaultInfuserTileEntity.createInventoryHandler(null), (ContainerData)new SimpleContainerData(10), buffer.m_130135_());
    }

    private VaultInfuserContainer(MenuType<?> type, int id, Inventory playerInventory, Function<Player, Boolean> isUsableByPlayer, BaseItemStackHandler inventory, ContainerData data, BlockPos pos) {
        super(type, id);
        int i;
        this.isUsableByPlayer = isUsableByPlayer;
        this.data = data;
        this.pos = pos;
        this.level = playerInventory.f_35978_.f_19853_;
        this.m_38897_((Slot)new OutputSlot((IItemHandler)inventory, 0, 135, 48));
        this.m_38897_((Slot)new InfuserIngredientSlot(inventory, 1, 65, 48));
        this.m_38897_((Slot)new CatalystSlot(inventory, 2, 38, 48));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 112 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 170));
        }
        this.m_38884_(data);
    }

    public ItemStack m_7648_(Player player, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (pIndex == 2) {
                if (!this.m_38903_(itemstack1, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (pIndex != 1 && pIndex != 0 ? (this.isInfusionIngredient(itemstack1) ? !this.m_38903_(itemstack1, 1, 2, false) : (this.isCatalyst(itemstack1) ? !this.m_38903_(itemstack1, 2, 3, false) : (pIndex >= 3 && pIndex < 30 ? !this.m_38903_(itemstack1, 30, 39, false) : pIndex >= 30 && pIndex < 39 && !this.m_38903_(itemstack1, 3, 30, false)))) : !this.m_38903_(itemstack1, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return this.isUsableByPlayer.apply(player);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isInfusionIngredient(ItemStack pStack) {
        return CachedInfuserRecipeData.getIngredients(this.level).contains(pStack.m_41720_());
    }

    public boolean isCatalyst(ItemStack pStack) {
        return CachedInfuserRecipeData.getCatalysts(this.level).contains(pStack.m_41720_());
    }

    public static VaultInfuserContainer create(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new VaultInfuserContainer(ModContainers.VAULT_INFUSER_CONTAINER, windowId, playerInventory, buffer);
    }

    public static VaultInfuserContainer create(int windowId, Inventory playerInventory, Function<Player, Boolean> isUsableByPlayer, BaseItemStackHandler inventory, ContainerData data, BlockPos pos) {
        return new VaultInfuserContainer(ModContainers.VAULT_INFUSER_CONTAINER, windowId, playerInventory, isUsableByPlayer, inventory, data, pos);
    }
}

