/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.blocks.containers;

import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import xyz.iwolfking.woldsvaults.blocks.containers.VaultInfuserContainer;
import xyz.iwolfking.woldsvaults.blocks.containers.lib.infuser.EjectModeSwitchButton;
import xyz.iwolfking.woldsvaults.blocks.containers.lib.infuser.InputLimitSwitchButton;
import xyz.iwolfking.woldsvaults.blocks.tiles.VaultInfuserTileEntity;

public class VaultInfuserScreen
extends BaseContainerScreen<VaultInfuserContainer> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("woldsvaults", "textures/gui/infuser.png");
    private VaultInfuserTileEntity tile;

    public VaultInfuserScreen(VaultInfuserContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, BACKGROUND, 176, 194);
    }

    public void m_7856_() {
        super.m_7856_();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        BlockPos pos = ((VaultInfuserContainer)this.m_6262_()).getPos();
        this.m_142416_((GuiEventListener)new EjectModeSwitchButton(x + 69, y + 30, pos));
        this.m_142416_((GuiEventListener)new InputLimitSwitchButton(x + 91, y + 74, pos, this::isLimitingInput));
        this.tile = this.getTileEntity();
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        if (mouseX > x + 60 && mouseX < x + 85 && mouseY > y + 74 && mouseY < y + 83) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (this.getMaterialCount() < 1) {
                tooltip.add(new TextComponent(""));
            } else {
                if (this.hasMaterialStack()) {
                    tooltip.add(this.getMaterialStackDisplayName());
                }
                TextComponent text = new TextComponent(VaultInfuserScreen.number((Object)this.getMaterialCount()) + " / " + VaultInfuserScreen.number((Object)this.getMaterialsRequired()));
                tooltip.add(text);
            }
            this.m_96597_(matrix, tooltip, mouseX, mouseY);
        }
        if (mouseX > x + 68 && mouseX < x + 79 && mouseY > y + 28 && mouseY < y + 39) {
            if (this.isEjecting()) {
                this.m_96602_(matrix, (Component)new TextComponent("Ejecting"), mouseX, mouseY);
            } else {
                this.m_96602_(matrix, (Component)new TextComponent("Not Ejecting"), mouseX, mouseY);
            }
        }
        if (mouseX > x + 90 && mouseX < x + 98 && mouseY > y + 73 && mouseY < y + 84) {
            if (this.isLimitingInput()) {
                this.m_96602_(matrix, (Component)new TextComponent("Limited Input"), mouseX, mouseY);
            } else {
                this.m_96602_(matrix, (Component)new TextComponent("Unlimited Input"), mouseX, mouseY);
            }
        }
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
        String title = this.m_96636_().getString();
        this.f_96547_.m_92883_(stack, title, (float)(this.f_97726_ / 2 - this.f_96547_.m_92895_(title) / 2), 6.0f, 0x404040);
        this.f_96547_.m_92889_(stack, this.f_169604_, 8.0f, (float)this.f_97727_ - 94.0f, 0x404040);
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        super.renderDefaultBg(stack, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.hasRecipe()) {
            int i2;
            if (this.getMaterialCount() > 0 && this.getMaterialsRequired() > 0) {
                i2 = this.getMaterialBarScaled(26);
                this.m_93228_(stack, x + 60, y + 74, 194, 19, i2 + 1, 10);
            }
            if (this.getProgress() > 0 && this.getInfuseDuration() > 0) {
                i2 = this.getProgressBarScaled(24);
                this.m_93228_(stack, x + 96, y + 47, 194, 0, i2 + 1, 16);
            }
        }
        if (this.isLimitingInput()) {
            this.m_93228_(stack, x + 90, y + 74, 203, 56, 9, 10);
        }
    }

    private Component getMaterialStackDisplayName() {
        VaultInfuserContainer container;
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().f_91073_;
        if (level != null && (tile = level.m_7702_((container = (VaultInfuserContainer)this.m_6262_()).getPos())) instanceof VaultInfuserTileEntity) {
            VaultInfuserTileEntity compressor = (VaultInfuserTileEntity)tile;
            ItemStack materialStack = compressor.getMaterialStack();
            return materialStack.m_41786_();
        }
        return new TextComponent("");
    }

    private VaultInfuserTileEntity getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().f_91073_;
        if (level != null && (tile = level.m_7702_(((VaultInfuserContainer)this.m_6262_()).getPos())) instanceof VaultInfuserTileEntity) {
            VaultInfuserTileEntity compressor = (VaultInfuserTileEntity)tile;
            return compressor;
        }
        return null;
    }

    public boolean isEjecting() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.isEjecting();
    }

    public boolean isLimitingInput() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.isLimitingInput();
    }

    public boolean hasRecipe() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.hasRecipe();
    }

    public boolean hasMaterialStack() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.hasMaterialStack();
    }

    public int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    public int getMaterialCount() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getMaterialCount();
    }

    public int getEnergyRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergyRequired();
    }

    public int getInfuseDuration() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getInfuseDuration();
    }

    public int getMaterialsRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getMaterialsRequired();
    }

    public int getMaterialBarScaled(int pixels) {
        int i = Mth.m_14045_((int)this.getMaterialCount(), (int)0, (int)this.getMaterialsRequired());
        int j = this.getMaterialsRequired();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getProgressBarScaled(int pixels) {
        int i = this.getProgress();
        return (int)(this.getInfuseDuration() != 0 && i != 0 ? (long)i * (long)pixels / (long)this.getInfuseDuration() : 0L);
    }
}

