/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.blocks.tiles;

import iskallia.vault.block.entity.AlchemyTableTileEntity;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ClientboundAlchemyParticleMessage;
import iskallia.vault.network.message.ClientboundAlchemySecondParticleMessage;
import iskallia.vault.network.message.ClientboundTESyncMessage;
import iskallia.vault.world.data.ServerVaults;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.woldsvaults.WoldsVaults;
import xyz.iwolfking.woldsvaults.blocks.BrewingAltar;
import xyz.iwolfking.woldsvaults.config.AlchemyObjectiveConfig;
import xyz.iwolfking.woldsvaults.events.vaultevents.WoldCommonEvents;
import xyz.iwolfking.woldsvaults.init.ModBlocks;
import xyz.iwolfking.woldsvaults.init.ModConfigs;
import xyz.iwolfking.woldsvaults.init.ModItems;
import xyz.iwolfking.woldsvaults.items.alchemy.AlchemyIngredientItem;
import xyz.iwolfking.woldsvaults.items.alchemy.CatalystItem;

public class BrewingAltarTileEntity
extends BlockEntity {
    private final NonNullList<ItemStack> ingredients = NonNullList.m_122780_((int)3, (Object)new ItemStack((ItemLike)ModItems.INGREDIENT_TEMPLATE));
    private ItemStack catalyst = new ItemStack((ItemLike)ModItems.INGREDIENT_TEMPLATE);
    private boolean brewing = false;
    private int cookingTimer = -1;
    private boolean hasExpired = false;
    private PercentageResult progressIncrease = new PercentageResult(-1.0f, -1.0f);

    public BrewingAltarTileEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlocks.BREWING_ALTAR_TILE_ENTITY_BLOCK_ENTITY_TYPE, pPos, pBlockState);
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.ingredients);
        pTag.m_128350_("ProgressMin", this.progressIncrease.min());
        pTag.m_128350_("ProgressMax", this.progressIncrease.max());
        pTag.m_128379_("Brewing", this.brewing);
        pTag.m_128405_("CookingTimer", this.cookingTimer);
        CompoundTag catalystTag = new CompoundTag();
        this.catalyst.m_41739_(catalystTag);
        pTag.m_128365_("Catalyst", (Tag)catalystTag);
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.ingredients);
        this.progressIncrease = pTag.m_128441_("ProgressMin") && pTag.m_128441_("ProgressMax") ? new PercentageResult(pTag.m_128457_("ProgressMin"), pTag.m_128457_("ProgressMax")) : new PercentageResult(-1.0f, -1.0f);
        this.brewing = pTag.m_128471_("Brewing");
        this.cookingTimer = pTag.m_128451_("CookingTimer");
        Tag tag = pTag.m_128423_("Catalyst");
        if (tag instanceof CompoundTag) {
            CompoundTag t = (CompoundTag)tag;
            this.catalyst = ItemStack.m_41712_((CompoundTag)t);
        } else {
            WoldsVaults.LOGGER.error("Catalyst Tag is not of type CompoundTag in BrewingAltarTileEntity. Bad things are happening");
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag compoundtag = new CompoundTag();
        this.m_183515_(compoundtag);
        return compoundtag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.handleUpdateTag(tag);
        }
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.progressIncrease = this.calculateObjectivePercentage();
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
    }

    public void setBrewing(boolean brewing) {
        this.brewing = brewing;
        this.cookingTimer = 60;
        this.sendUpdates();
    }

    public boolean isBrewing() {
        return this.brewing;
    }

    public void setHasExpired(boolean hasExpired) {
        this.hasExpired = hasExpired;
    }

    public boolean hasExpired() {
        return this.hasExpired;
    }

    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    public Optional<CatalystItem.CatalystType> getCatalystType() {
        Item item = this.getCatalyst().m_41720_();
        if (item instanceof CatalystItem) {
            CatalystItem item2 = (CatalystItem)item;
            return Optional.of(item2.getType());
        }
        return Optional.empty();
    }

    public void setCatalyst(ItemStack catalyst) {
        this.catalyst = catalyst;
        this.sendUpdates();
    }

    public boolean addCatalyst(ItemStack catalyst) {
        if (this.getCatalyst().m_41720_() == ModItems.INGREDIENT_TEMPLATE) {
            this.setCatalyst(catalyst);
            return true;
        }
        return false;
    }

    public ItemStack removeCatalyst() {
        ItemStack catalyst = this.getCatalyst().m_41720_() == ModItems.INGREDIENT_TEMPLATE ? null : this.getCatalyst().m_41777_();
        this.setCatalyst(new ItemStack((ItemLike)ModItems.INGREDIENT_TEMPLATE));
        return catalyst;
    }

    public NonNullList<ItemStack> getAllIngredients() {
        return this.ingredients;
    }

    public ItemStack getIngredient(int index) {
        return (ItemStack)this.ingredients.get(index);
    }

    public void setIngredient(int index, ItemStack stack) {
        this.ingredients.set(index, (Object)stack);
        this.sendUpdates();
    }

    public void removeIngredient(int index) {
        this.ingredients.set(index, (Object)new ItemStack((ItemLike)ModItems.INGREDIENT_TEMPLATE));
        this.sendUpdates();
    }

    public void clearIngredients() {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            if (this.getIngredient(i).m_41720_() == ModItems.INGREDIENT_TEMPLATE) continue;
            this.setIngredient(i, ModItems.INGREDIENT_TEMPLATE.m_7968_());
        }
    }

    public boolean addIngredient(ItemStack stack) {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            if (this.getIngredient(i).m_41720_() != ModItems.INGREDIENT_TEMPLATE) continue;
            this.setIngredient(i, stack);
            return true;
        }
        return false;
    }

    public ItemStack removeLastIngredient() {
        for (int i = this.ingredients.size() - 1; i >= 0; --i) {
            if (this.getIngredient(i).m_41720_() == ModItems.INGREDIENT_TEMPLATE) continue;
            ItemStack removedStack = this.getIngredient(i).m_41777_();
            this.removeIngredient(i);
            return removedStack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getLastIngredient() {
        for (int i = this.ingredients.size() - 1; i >= 0; --i) {
            if (this.getIngredient(i).m_41720_() == ModItems.INGREDIENT_TEMPLATE) continue;
            return this.getIngredient(i);
        }
        return ItemStack.f_41583_;
    }

    public boolean isFilled() {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            if (this.getIngredient(i).m_41720_() != ModItems.INGREDIENT_TEMPLATE) continue;
            return false;
        }
        return true;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (this.f_58857_ != null) {
            if (this.f_58857_.m_5776_()) {
                return;
            }
            if (!this.brewing) {
                return;
            }
            if (this.cookingTimer > 0) {
                if (this.cookingTimer == 60) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12590_, SoundSource.BLOCKS, 0.35f, 1.5f);
                }
                if (this.cookingTimer == 55) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12537_, SoundSource.BLOCKS, 0.35f, 1.5f);
                    this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_144243_, SoundSource.BLOCKS, 2.0f, 1.0f);
                }
                if (this.cookingTimer == 35) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11772_, SoundSource.BLOCKS, 0.5f, 1.5f);
                }
                if (this.cookingTimer == 20) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_144049_, SoundSource.BLOCKS, 0.5f, 1.5f);
                }
                if (this.cookingTimer == 19) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_144049_, SoundSource.BLOCKS, 0.45f, 2.0f);
                }
                int color = AlchemyIngredientItem.getMixedColor(this.ingredients);
                if (this.cookingTimer > 40 && this.cookingTimer < 58) {
                    float f = 1.0f - (float)(this.cookingTimer - 40) / (float)(AlchemyTableTileEntity.CRAFTING_COOLDOWN - 40);
                    f = AlchemyTableTileEntity.ease((double)f);
                    float yOffset = (float)Math.sin((double)f * Math.PI / 1.5) / 8.0f;
                    ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(this.f_58858_)), (Object)new ClientboundAlchemyParticleMessage(this.m_58899_(), Direction.NORTH, color, yOffset));
                }
                if (this.cookingTimer == 20) {
                    ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(this.f_58858_)), (Object)new ClientboundAlchemySecondParticleMessage(this.m_58899_(), color));
                }
                --this.cookingTimer;
                return;
            }
            int newUses = Math.max(0, (Integer)blockState.m_61143_((Property)BrewingAltar.USES) - 1);
            BlockState newState = (BlockState)blockState.m_61124_((Property)BrewingAltar.USES, (Comparable)Integer.valueOf(newUses));
            level.m_7731_(blockPos, newState, 2);
            WoldCommonEvents.BREWING_ALTAR_BREW_EVENT.invoke(level, blockState, blockPos, this, List.copyOf(this.ingredients));
            this.brewing = false;
            this.clearIngredients();
            ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(this.f_58858_)), (Object)new ClientboundTESyncMessage(this.f_58858_, this.m_187482_()));
            if ((Integer)blockState.m_61143_((Property)BrewingAltar.USES) == 0) {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 0.1f, 1.0f);
            }
        } else {
            if (!this.brewing) {
                return;
            }
            if (this.cookingTimer > 0) {
                --this.cookingTimer;
            }
        }
    }

    private PercentageResult calculateObjectivePercentage() {
        if (this.f_58857_ == null) {
            return new PercentageResult(-1.0f, -1.0f);
        }
        if (this.f_58857_.m_5776_()) {
            return new PercentageResult(-1.0f, -1.0f);
        }
        if (ServerVaults.get((Level)this.f_58857_).isEmpty()) {
            return new PercentageResult(-1.0f, -1.0f);
        }
        int vaultLevel = ((VaultLevel)((Vault)ServerVaults.get((Level)this.f_58857_).get()).get(Vault.LEVEL)).get();
        AlchemyObjectiveConfig.Entry cfg = ModConfigs.ALCHEMY_OBJECTIVE.getConfig(vaultLevel);
        float min = 0.0f;
        float max = 0.0f;
        for (ItemStack i : this.ingredients) {
            Item item = i.m_41720_();
            if (!(item instanceof AlchemyIngredientItem)) continue;
            AlchemyIngredientItem item2 = (AlchemyIngredientItem)item;
            PercentageResult res = cfg.getPercentageForType(item2);
            min += res.min();
            max += res.max();
        }
        return new PercentageResult(min, max);
    }

    public PercentageResult getProgressIncrease() {
        return this.progressIncrease;
    }

    public static class PercentageResult {
        private float min;
        private float max;

        public PercentageResult(float min, float max) {
            this.min = min;
            this.max = max;
        }

        public float min() {
            return this.min;
        }

        public float max() {
            return this.max;
        }

        public void setMin(float min) {
            this.min = min;
        }

        public void setMax(float max) {
            this.max = max;
        }

        public boolean isRange() {
            return this.min != this.max;
        }
    }
}

