/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.blocks.tiles;

import iskallia.vault.entity.entity.DollMiniMeEntity;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModItems;
import iskallia.vault.integration.IntegrationRefinedStorage;
import iskallia.vault.item.VaultDollItem;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.DollLootData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.woldsvaults.api.util.GameruleHelper;
import xyz.iwolfking.woldsvaults.config.forge.WoldsVaultsConfig;
import xyz.iwolfking.woldsvaults.init.ModBlocks;
import xyz.iwolfking.woldsvaults.init.ModGameRules;
import xyz.iwolfking.woldsvaults.init.ModSounds;

public class DollDismantlingTileEntity
extends BlockEntity {
    private final DollItemExtractor extractionHandler;
    private final LazyOptional<IItemHandler> extractionCapability;
    private final EnergyStorage energyStorage;
    private final LazyOptional<EnergyStorage> energyCapability;
    private final int energyConsumption;
    private final double volume;
    private int soundTickCooldown = 0;
    private int extractionTick = 0;
    private int totalItemsInDoll = 0;
    @Nullable
    private DollMiniMeEntity miniMeEntity;
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DollDismantlingTileEntity.this.updateMiniMe();
        }
    };
    private static final String AMOUNT = "amount";
    private static final String DOLL = "doll";
    private static final String SIZE = "size";
    private static final String ITEM = "item";
    private static final String MINI = "mini";
    private static final String REWARD = "reward";
    private static final String ENERGY = "energy";

    public DollDismantlingTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.DOLL_DISMANTLING_TILE_ENTITY_BLOCK_ENTITY_TYPE, pos, state);
        this.extractionHandler = new DollItemExtractor();
        this.extractionCapability = LazyOptional.of(() -> this.extractionHandler);
        int energyStorage = (Integer)WoldsVaultsConfig.SERVER.dollDismantlerEnergyStorage.get();
        int energyTransfer = (Integer)WoldsVaultsConfig.SERVER.dollDismantlerEnergyTransfer.get();
        this.energyConsumption = (Integer)WoldsVaultsConfig.SERVER.dollDismantlerEnergyConsumption.get();
        this.energyStorage = new EnergyStorage(energyStorage, energyTransfer, energyTransfer);
        this.energyCapability = LazyOptional.of(() -> this.energyStorage);
        this.volume = 0.5;
    }

    public ItemStack getDoll() {
        return this.inventory.getStackInSlot(0);
    }

    public void updateDoll(ItemStack itemStack, ServerPlayer player) {
        this.inventory.setStackInSlot(0, itemStack);
        CompoundTag dollTag = itemStack.m_41784_();
        VaultDollItem.getDollUUID((CompoundTag)dollTag).ifPresentOrElse(dollUuid -> {
            if (!dollTag.m_128441_(REWARD)) {
                PlayerVaultStatsData statsData = PlayerVaultStatsData.get((ServerLevel)player.m_183503_());
                statsData.addVaultExp(player, VaultDollItem.getExperience((CompoundTag)dollTag));
                dollTag.m_128379_(REWARD, true);
            }
            DollLootData dollLootData = DollLootData.get((ServerLevel)player.m_183503_(), (UUID)dollUuid);
            List loot = dollLootData.getLoot();
            this.totalItemsInDoll = loot.stream().mapToInt(ItemStack::m_41613_).sum();
            if (!dollTag.m_128441_(AMOUNT)) {
                InventoryUtil.makeItemsRotten((List)loot);
                dollLootData.m_77762_();
                dollTag.m_128356_(AMOUNT, (long)this.totalItemsInDoll);
            }
            this.extractionHandler.setDollLootData(dollLootData);
            if (loot.isEmpty()) {
                this.removeVaultDoll();
            }
        }, this::removeVaultDoll);
    }

    public void removeVaultDoll() {
        this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        this.extractionHandler.setDollLootData(null);
        this.totalItemsInDoll = 0;
        this.updateMiniMe();
    }

    public boolean playerCanInsertDoll(ItemStack stack, Player player) {
        if (!GameruleHelper.isEnabled(ModGameRules.ENABLE_VAULT_DOLLS, player.m_183503_())) {
            return false;
        }
        return player.m_7500_() || VaultDollItem.getPlayerGameProfile((ItemStack)stack).flatMap(gp -> Optional.of(gp.getId())).map(uuid -> !uuid.equals(player.m_142081_())).orElse(true) == false;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public int getTotalItemsInDoll() {
        return this.totalItemsInDoll;
    }

    @Nullable
    public DollMiniMeEntity getMiniMeEntity() {
        return this.miniMeEntity;
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(DOLL)) {
            CompoundTag doll = tag.m_128469_(DOLL);
            this.totalItemsInDoll = doll.m_128451_(SIZE);
            this.inventory.deserializeNBT(doll.m_128469_(ITEM));
            if (doll.m_128441_(MINI)) {
                this.miniMeEntity = new DollMiniMeEntity(ModEntities.DOLL_MINI_ME, this.m_58904_());
                this.miniMeEntity.deserializeNBT(doll.m_128469_(MINI));
            } else {
                this.miniMeEntity = null;
            }
        }
        this.energyStorage.receiveEnergy(tag.m_128451_(ENERGY), false);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag doll = new CompoundTag();
        doll.m_128405_(SIZE, this.totalItemsInDoll);
        doll.m_128365_(ITEM, (Tag)this.inventory.serializeNBT());
        if (this.miniMeEntity != null) {
            doll.m_128365_(MINI, (Tag)this.miniMeEntity.serializeNBT());
        }
        tag.m_128365_(DOLL, (Tag)doll);
        tag.m_128405_(ENERGY, this.energyStorage.getEnergyStored());
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void autoEjectItems() {
        BlockPos belowPos = this.m_58899_().m_7495_();
        BlockEntity belowBlockEntity = this.m_58904_().m_7702_(belowPos);
        if (belowBlockEntity != null) {
            belowBlockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).ifPresent(belowHandler -> {
                for (int slot = 0; slot < this.extractionHandler.getSlots(); ++slot) {
                    boolean repopulate;
                    ItemStack stackInSlot = this.extractionHandler.getStackInSlot(slot);
                    if (stackInSlot.m_41619_()) continue;
                    int count = stackInSlot.m_41613_();
                    boolean bl = repopulate = count > stackInSlot.m_41741_();
                    if (repopulate) {
                        stackInSlot = stackInSlot.m_41777_();
                        stackInSlot.m_41764_(stackInSlot.m_41741_());
                        count -= stackInSlot.m_41741_();
                    }
                    ItemStack remainingStack = this.transferStack((IItemHandler)belowHandler, stackInSlot);
                    if (repopulate) {
                        if (remainingStack.m_41619_()) {
                            remainingStack = stackInSlot.m_41777_();
                            remainingStack.m_41764_(count);
                        } else {
                            remainingStack.m_41764_(remainingStack.m_41613_() + count);
                        }
                    }
                    if (this.extractionHandler.transferStack(slot, stackInSlot, remainingStack)) break;
                }
                this.m_6596_();
            });
        }
    }

    private ItemStack transferStack(IItemHandler targetHandler, ItemStack stack) {
        for (int slot = 0; slot < targetHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = targetHandler.getStackInSlot(slot);
            if (targetHandler.insertItem(slot, stack, true).m_41613_() != stack.m_41613_()) {
                if (stackInSlot.m_41619_()) {
                    targetHandler.insertItem(slot, stack, false);
                    stack = ItemStack.f_41583_;
                } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stack)) {
                    stack = targetHandler.insertItem(slot, stack, false);
                }
            }
            if (stack.m_41619_()) break;
        }
        return stack;
    }

    public boolean canOperate() {
        return this.energyStorage.getEnergyStored() >= this.energyConsumption;
    }

    private void consumeEnergy() {
        this.energyStorage.extractEnergy(this.energyConsumption, false);
    }

    private void updateMiniMe() {
        if (!this.getDoll().m_150930_((Item)ModItems.VAULT_DOLL) || this.m_58904_() == null) {
            this.miniMeEntity = null;
        } else {
            this.miniMeEntity = new DollMiniMeEntity(ModEntities.DOLL_MINI_ME, this.m_58904_());
            CompoundTag dataTag = this.getDoll().m_41784_();
            VaultDollItem.getPlayerGameProfile((CompoundTag)dataTag).ifPresent(arg_0 -> ((DollMiniMeEntity)this.miniMeEntity).setGameProfile(arg_0));
        }
        this.triggerUpdate();
    }

    private void triggerUpdate() {
        this.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public void tick() {
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            if (!this.getDoll().m_41619_()) {
                if (this.canOperate()) {
                    if (this.volume != 0.0) {
                        if (this.soundTickCooldown <= 0) {
                            this.m_58904_().m_5594_(null, this.m_58899_(), ModSounds.BLENDER, SoundSource.BLOCKS, (float)this.volume, 1.0f);
                            this.soundTickCooldown = 19;
                        } else {
                            --this.soundTickCooldown;
                        }
                    }
                    if (this.extractionTick <= 0) {
                        this.autoEjectItems();
                        this.extractionTick = (Integer)WoldsVaultsConfig.SERVER.dollDismantlerExtractionSpeed.get();
                    }
                    this.consumeEnergy();
                    --this.extractionTick;
                }
            } else {
                this.soundTickCooldown = 0;
            }
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.energyCapability.invalidate();
        this.extractionCapability.invalidate();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyCapability.invalidate();
        this.extractionCapability.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (IntegrationRefinedStorage.shouldPreventImportingCapability((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (Direction)side)) {
            return super.getCapability(capability, side);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return this.energyCapability.cast();
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.extractionCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    private class DollItemExtractor
    extends ItemStackHandler {
        protected DollLootData dollLootData;

        DollItemExtractor() {
            super(0);
            this.dollLootData = null;
        }

        public void setDollLootData(DollLootData dollLootData) {
            this.dollLootData = dollLootData;
        }

        public int getSlots() {
            return this.dollLootData != null ? this.dollLootData.getLoot().size() : 0;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.dollLootData != null && this.getSlots() > slot ? (ItemStack)this.dollLootData.getLoot().get(slot) : ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            if (!DollDismantlingTileEntity.this.getDoll().m_150930_((Item)ModItems.VAULT_DOLL)) {
                return ItemStack.f_41583_;
            }
            if (!(DollDismantlingTileEntity.this.f_58857_ instanceof ServerLevel)) {
                return ItemStack.f_41583_;
            }
            if (this.dollLootData == null) {
                return ItemStack.f_41583_;
            }
            List loot = this.dollLootData.getLoot();
            if (loot.size() <= slot) {
                return ItemStack.f_41583_;
            }
            ItemStack stackInSlot = (ItemStack)loot.get(slot);
            if (stackInSlot.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (simulate) {
                if (stackInSlot.m_41613_() < amount) {
                    return stackInSlot.m_41777_();
                }
                ItemStack copy = stackInSlot.m_41777_();
                copy.m_41764_(amount);
                return copy;
            }
            if (stackInSlot.m_41613_() < amount) {
                loot.remove(slot);
                DollDismantlingTileEntity.this.totalItemsInDoll -= stackInSlot.m_41613_();
                this.dollLootData.m_77762_();
                if (loot.isEmpty()) {
                    DollDismantlingTileEntity.this.removeVaultDoll();
                } else {
                    DollDismantlingTileEntity.this.triggerUpdate();
                }
                return stackInSlot;
            }
            ItemStack copy = stackInSlot.m_41777_();
            copy.m_41764_(amount);
            stackInSlot.m_41774_(amount);
            DollDismantlingTileEntity.this.totalItemsInDoll -= amount;
            if (stackInSlot.m_41619_()) {
                loot.remove(slot);
            }
            this.dollLootData.m_77762_();
            if (loot.isEmpty()) {
                DollDismantlingTileEntity.this.removeVaultDoll();
            } else {
                DollDismantlingTileEntity.this.triggerUpdate();
            }
            return copy;
        }

        public boolean transferStack(int slot, ItemStack stackInSlot, ItemStack remainingStack) {
            if (this.dollLootData == null || this.getSlots() <= slot) {
                return false;
            }
            if (remainingStack.m_41619_()) {
                this.dollLootData.getLoot().remove(slot);
                DollDismantlingTileEntity.this.totalItemsInDoll -= stackInSlot.m_41613_();
                this.dollLootData.m_77762_();
                if (this.dollLootData.getLoot().isEmpty()) {
                    DollDismantlingTileEntity.this.removeVaultDoll();
                } else {
                    DollDismantlingTileEntity.this.triggerUpdate();
                }
                return true;
            }
            if (remainingStack.m_41613_() != stackInSlot.m_41613_()) {
                this.dollLootData.getLoot().set(slot, remainingStack);
                this.dollLootData.m_77762_();
                DollDismantlingTileEntity.this.totalItemsInDoll -= stackInSlot.m_41613_() - remainingStack.m_41613_();
                DollDismantlingTileEntity.this.triggerUpdate();
                return true;
            }
            return false;
        }
    }
}

