/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.blocks.tiles;

import iskallia.vault.block.base.LootableTileEntity;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.iwolfking.woldsvaults.init.ModBlocks;

public class DungeonPedestalTileEntity
extends LootableTileEntity {
    private static final Random rand = new Random();
    private ItemStack contained = ItemStack.f_41583_;

    public DungeonPedestalTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.DUNGEON_PEDESTAL_TILE_ENTITY_BLOCK_ENTITY_TYPE, pos, state);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_142082_(1, 1, 1)).m_82400_(5.0);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, DungeonPedestalTileEntity tile) {
        if (world.m_5776_()) {
            DungeonPedestalTileEntity.clientTick(world, pos, state, tile);
        } else if (tile.contained.m_41619_() && tile.getLootTable() != null) {
            List generatedStacks = tile.generateLoot(null);
            tile.setLootTable(null);
            tile.contained = generatedStacks.stream().filter(stack -> !stack.m_41619_()).findFirst().orElse(ItemStack.f_41583_);
            tile.m_6596_();
            world.m_7260_(pos, state, state, 3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientTick(Level world, BlockPos pos, BlockState state, DungeonPedestalTileEntity tile) {
        if (!rand.nextBoolean()) {
            ParticleEngine engine = Minecraft.m_91087_().f_91061_;
            double x = (double)pos.m_123341_() + 0.5 + (double)(rand.nextFloat() * 2.0f * (float)(rand.nextBoolean() ? 1 : -1));
            double y = (double)pos.m_123342_() + 2.0 + (double)(rand.nextFloat() * 2.0f * (float)(rand.nextBoolean() ? 1 : -1));
            double z = (double)pos.m_123343_() + 0.5 + (double)(rand.nextFloat() * 2.0f * (float)(rand.nextBoolean() ? 1 : -1));
            float hueGold = 0.125f;
            int color = Color.HSBtoRGB(hueGold, 0.2f + rand.nextFloat() * 0.6f, 1.0f);
            if (rand.nextInt(5) == 0) {
                x = (double)pos.m_123341_() + 0.5;
                y = (double)pos.m_123342_() + 1.5;
                z = (double)pos.m_123343_() + 0.5;
            }
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            SimpleAnimatedParticle particle = (SimpleAnimatedParticle)engine.m_107370_((ParticleOptions)ParticleTypes.f_123815_.m_6012_(), x, y, z, (double)(rand.nextFloat() * 0.02f * (float)(rand.nextBoolean() ? 1 : -1)), (double)(rand.nextFloat() * 0.04f), (double)(rand.nextFloat() * 0.02f * (float)(rand.nextBoolean() ? 1 : -1)));
            if (particle != null) {
                particle.m_107253_(r, g, b);
            }
        }
    }

    public ItemStack getContained() {
        return this.contained.m_41777_();
    }

    public void setContained(ItemStack contained) {
        this.contained = contained;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.contained = ItemStack.m_41712_((CompoundTag)tag.m_128469_("contained"));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("contained", (Tag)this.contained.serializeNBT());
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

