/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.blocks.tiles;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.woldsvaults.events.vaultevents.WoldCommonEvents;
import xyz.iwolfking.woldsvaults.init.ModBlocks;

public class FracturedObeliskTileEntity
extends BlockEntity {
    private float percentObfuscated = 0.0f;
    private boolean initialCompletion = false;

    public FracturedObeliskTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.FRACTURED_OBELISK_TILE_ENTITY_BLOCK_ENTITY_TYPE, pos, state);
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null && this.f_58857_ != null) {
            this.handleUpdateTag(tag);
            this.sendUpdates();
        }
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.percentObfuscated = nbt.m_128457_("PercentObfuscated");
        this.initialCompletion = nbt.m_128471_("InitialCompletion");
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128350_("PercentObfuscated", this.percentObfuscated);
        nbt.m_128379_("InitialCompletion", this.initialCompletion);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FracturedObeliskTileEntity tile) {
        WoldCommonEvents.FRACTURED_OBELISK_UPDATE.invoke(level, state, pos, tile);
    }

    public float getPercentObfuscated() {
        return this.percentObfuscated;
    }

    public boolean getInitialCompletion() {
        return this.initialCompletion;
    }

    public void setPercentObfuscated(float percentObfuscated) {
        this.percentObfuscated = percentObfuscated;
    }

    public void setInitialCompletion(boolean initialCompletion) {
        this.initialCompletion = initialCompletion;
    }
}

