/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.blocks.tiles;

import com.google.common.collect.Lists;
import iskallia.vault.config.VaultRecyclerConfig;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.gear.RecyclableItem;
import iskallia.vault.network.message.RecyclerParticleMessage;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.PacketDistributor;
import xyz.iwolfking.vhapi.api.data.api.CustomRecyclerOutputs;
import xyz.iwolfking.woldsvaults.blocks.containers.VaultSalvagerContainer;
import xyz.iwolfking.woldsvaults.init.ModBlocks;
import xyz.iwolfking.woldsvaults.lib.SimpleOversizedSidedContainer;

public class VaultSalvagerTileEntity
extends BlockEntity
implements MenuProvider {
    private static final Random rand = new Random();
    private final SalvagerInventory inventory = new SalvagerInventory(10);
    private UUID gearIdProcessing = null;
    private int processTick = 0;
    private LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this.inventory, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});

    public VaultSalvagerTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModBlocks.VAULT_SALVAGER_ENTITY, pWorldPosition, pBlockState);
    }

    public boolean stillValid(Player player) {
        return this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) == this && this.inventory.m_6542_(player);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, VaultSalvagerTileEntity tile) {
        if (!world.m_5776_() && tile.gearIdProcessing != null) {
            if (!tile.canCraft()) {
                tile.resetProcess(world);
            } else {
                ++tile.processTick;
                if (tile.processTick >= 2) {
                    tile.finishCraft();
                }
                tile.m_6596_();
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    serverWorld.m_7260_(pos, state, state, 3);
                }
            }
        }
    }

    private void finishCraft() {
        VaultRecyclerConfig.RecyclerOutput output = this.getRecipeOutput();
        if (output != null) {
            if (this.f_58857_ != null) {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5f + new Random().nextFloat() * 0.25f, 0.75f + new Random().nextFloat() * 0.25f);
            }
            ItemStack input = this.inventory.m_8020_(0).m_41777_();
            float additionalChance = 0.0f;
            if (input.m_41720_() instanceof VaultGearItem) {
                VaultGearRarity rarity = VaultGearData.read((ItemStack)input).getRarity();
                additionalChance = ModConfigs.VAULT_RECYCLER.getAdditionalOutputRarityChance(rarity);
            }
            this.inventory.m_7407_(0, 1);
            if (input.m_41720_() instanceof VaultGearItem) {
                VaultGearData data = VaultGearData.read((ItemStack)input);
                VaultGearRarity rarity = data.getRarity();
                boolean isCrafted = data.hasAttribute(ModGearAttributes.CRAFTED_BY) || data.getFirstValue(ModGearAttributes.CRAFTED_BY).isPresent();
                boolean isLegendary = (Boolean)data.get(ModGearAttributes.IS_LEGENDARY, VaultGearAttributeTypeMerger.anyTrue());
                additionalChance = ModConfigs.VAULT_RECYCLER.getAdditionalOutputRarityChance(rarity);
                this.inventory.m_7407_(0, 1);
                MiscUtils.addStackToSlot((Container)this.inventory, (int)1, (ItemStack)this.getUseRelatedOutput(input, output.generateMainOutput(additionalChance)));
                MiscUtils.addStackToSlot((Container)this.inventory, (int)2, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput1(input, additionalChance, rarity, isCrafted, isLegendary)));
                if (MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)3, (ItemStack)output.getExtraOutput2Matching())) {
                    MiscUtils.addStackToSlot((Container)this.inventory, (int)3, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance, rarity, isCrafted, isLegendary)));
                } else if (MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)4, (ItemStack)output.getExtraOutput2Matching())) {
                    MiscUtils.addStackToSlot((Container)this.inventory, (int)4, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance, rarity, isCrafted, isLegendary)));
                } else if (MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)5, (ItemStack)output.getExtraOutput2Matching())) {
                    MiscUtils.addStackToSlot((Container)this.inventory, (int)5, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance, rarity, isCrafted, isLegendary)));
                } else if (MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)6, (ItemStack)output.getExtraOutput2Matching())) {
                    MiscUtils.addStackToSlot((Container)this.inventory, (int)6, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance, rarity, isCrafted, isLegendary)));
                } else if (MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)7, (ItemStack)output.getExtraOutput2Matching())) {
                    MiscUtils.addStackToSlot((Container)this.inventory, (int)7, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance, rarity, isCrafted, isLegendary)));
                } else if (MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)8, (ItemStack)output.getExtraOutput2Matching())) {
                    MiscUtils.addStackToSlot((Container)this.inventory, (int)8, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance, rarity, isCrafted, isLegendary)));
                } else {
                    MiscUtils.addStackToSlot((Container)this.inventory, (int)9, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance, rarity, isCrafted, isLegendary)));
                }
            } else {
                MiscUtils.addStackToSlot((Container)this.inventory, (int)1, (ItemStack)this.getUseRelatedOutput(input, output.generateMainOutput(additionalChance)));
                MiscUtils.addStackToSlot((Container)this.inventory, (int)2, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput1(input, additionalChance)));
                if (MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)3, (ItemStack)output.getExtraOutput2Matching())) {
                    MiscUtils.addStackToSlot((Container)this.inventory, (int)3, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance)));
                } else if (MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)4, (ItemStack)output.getExtraOutput2Matching())) {
                    MiscUtils.addStackToSlot((Container)this.inventory, (int)4, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance)));
                } else if (MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)5, (ItemStack)output.getExtraOutput2Matching())) {
                    MiscUtils.addStackToSlot((Container)this.inventory, (int)5, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance)));
                } else if (MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)6, (ItemStack)output.getExtraOutput2Matching())) {
                    MiscUtils.addStackToSlot((Container)this.inventory, (int)6, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance)));
                } else if (MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)7, (ItemStack)output.getExtraOutput2Matching())) {
                    MiscUtils.addStackToSlot((Container)this.inventory, (int)7, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance)));
                } else if (MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)8, (ItemStack)output.getExtraOutput2Matching())) {
                    MiscUtils.addStackToSlot((Container)this.inventory, (int)8, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance)));
                } else {
                    MiscUtils.addStackToSlot((Container)this.inventory, (int)9, (ItemStack)this.getUseRelatedOutput(input, output.generateExtraOutput2(input, additionalChance)));
                }
            }
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new RecyclerParticleMessage(this.m_58899_()));
        }
    }

    private ItemStack getUseRelatedOutput(ItemStack input, ItemStack output) {
        float chance = this.getResultPercentage(input);
        float out = (float)output.m_41613_() * chance;
        int resultCount = Mth.m_14143_((float)out);
        if (resultCount < 1 && out > 0.0f && rand.nextFloat() < out) {
            ++resultCount;
        }
        ItemStack copyOut = output.m_41777_();
        copyOut.m_41764_(resultCount);
        return copyOut;
    }

    private boolean canCraft() {
        VaultRecyclerConfig.RecyclerOutput output = this.getRecipeOutput();
        if (output == null) {
            return false;
        }
        if (!MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)1, (ItemStack)output.getMainOutputMatching())) {
            return false;
        }
        if (!MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)2, (ItemStack)output.getExtraOutput1Matching())) {
            return false;
        }
        if (!(MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)3, (ItemStack)output.getExtraOutput2Matching()) || MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)4, (ItemStack)output.getExtraOutput2Matching()) || MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)5, (ItemStack)output.getExtraOutput2Matching()) || MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)6, (ItemStack)output.getExtraOutput2Matching()) || MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)7, (ItemStack)output.getExtraOutput2Matching()) || MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)8, (ItemStack)output.getExtraOutput2Matching()))) {
            return MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)9, (ItemStack)output.getExtraOutput2Matching());
        }
        return MiscUtils.canFullyMergeIntoSlot((Container)this.inventory, (int)9, (ItemStack)output.getExtraOutput2Matching());
    }

    @Nullable
    private VaultRecyclerConfig.RecyclerOutput getRecipeOutput() {
        ItemStack input = this.inventory.m_8020_(0);
        if (!this.isValidInput(input)) {
            return null;
        }
        Item item = input.m_41720_();
        if (item instanceof RecyclableItem) {
            RecyclableItem recyclableItem = (RecyclableItem)item;
            return recyclableItem.getOutput(input);
        }
        return CustomRecyclerOutputs.CUSTOM_OUTPUTS.getOrDefault(input.m_41720_().getRegistryName(), null);
    }

    private void triggerItemChange() {
        ItemStack input = this.inventory.m_8020_(0);
        if (!this.isValidInput(input)) {
            this.resetProcess(null);
        } else {
            Item item = input.m_41720_();
            if (item instanceof RecyclableItem) {
                RecyclableItem recyclableItem = (RecyclableItem)item;
                recyclableItem.getUuid(input).ifPresent(itemId -> {
                    if ((this.gearIdProcessing == null || !this.gearIdProcessing.equals(itemId)) && this.canCraft()) {
                        this.startProcess(null, (UUID)itemId);
                    }
                });
            } else {
                UUID uuid = UUID.randomUUID();
                if ((this.gearIdProcessing == null || !this.gearIdProcessing.equals(uuid)) && this.canCraft()) {
                    this.startProcess(null, uuid);
                }
            }
        }
    }

    public boolean isValidInput(ItemStack input) {
        Item item = input.m_41720_();
        if (item instanceof RecyclableItem) {
            RecyclableItem recyclableItem = (RecyclableItem)item;
            return recyclableItem.isValidInput(input);
        }
        return CustomRecyclerOutputs.CUSTOM_OUTPUTS.containsKey(input.m_41720_().getRegistryName());
    }

    public float getResultPercentage(ItemStack input) {
        Item item = input.m_41720_();
        if (item instanceof RecyclableItem) {
            RecyclableItem recyclableItem = (RecyclableItem)item;
            return recyclableItem.getResultPercentage(input);
        }
        if (CustomRecyclerOutputs.CUSTOM_OUTPUTS.containsKey(input.m_41720_().getRegistryName())) {
            return 1.0f;
        }
        return 0.0f;
    }

    private void resetProcess(@Nullable Level world) {
        this.startProcess(world, null);
    }

    private void startProcess(@Nullable Level world, UUID id) {
        int prevTick = this.processTick;
        this.gearIdProcessing = id;
        this.processTick = 0;
        this.m_6596_();
        if (prevTick != this.processTick && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public float getProgressPercent() {
        return (float)this.processTick / 2.0f;
    }

    public SalvagerInventory getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        NBTHelper.deserializeSimpleContainer((SimpleContainer)this.inventory, (ListTag)tag.m_128437_("inventory", 10));
        this.processTick = tag.m_128451_("processTick");
        if (tag.m_128403_("gearIdProcessing")) {
            this.gearIdProcessing = tag.m_128342_("gearIdProcessing");
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)NBTHelper.serializeSimpleContainer((SimpleContainer)this.inventory));
        tag.m_128405_("processTick", this.processTick);
        if (this.gearIdProcessing != null) {
            tag.m_128362_("gearIdProcessing", this.gearIdProcessing);
        }
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inv, Player player) {
        return this.m_58904_() == null ? null : new VaultSalvagerContainer(containerId, this.m_58904_(), this.m_58899_(), inv);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        Arrays.stream(this.handlers).forEach(LazyOptional::invalidate);
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this.inventory, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    }

    public class SalvagerInventory
    extends SimpleOversizedSidedContainer {
        public SalvagerInventory(int size) {
            super(size);
        }

        @Override
        public List<Direction> getAccessibleSlots(int slot) {
            return slot == 0 ? Lists.newArrayList((Object[])new Direction[]{Direction.UP}) : Lists.newArrayList((Object[])new Direction[]{Direction.DOWN});
        }

        public boolean m_7013_(int slot, ItemStack stack) {
            if (stack.m_41619_()) {
                return false;
            }
            if (slot == 0) {
                Item item = stack.m_41720_();
                if (item instanceof RecyclableItem) {
                    RecyclableItem recyclableItem = (RecyclableItem)item;
                    return recyclableItem.isValidInput(stack);
                }
                return CustomRecyclerOutputs.CUSTOM_OUTPUTS.containsKey(stack.m_41720_().getRegistryName());
            }
            return false;
        }

        public void m_6596_() {
            super.m_6596_();
            VaultSalvagerTileEntity.this.m_6596_();
            VaultSalvagerTileEntity.this.triggerItemChange();
        }
    }
}

