/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.client.particle;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import xyz.iwolfking.woldsvaults.WoldsVaults;
import xyz.iwolfking.woldsvaults.mixins.AccessorParticleEngine;

public class ElixirOrbParticle
extends TextureSheetParticle {
    private int size = 11;
    private boolean stoppedByCollision;
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.m_144952_((double)100.0);

    protected ElixirOrbParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet pSprites) {
        super(pLevel, pX, pY, pZ);
        this.f_107215_ = pXSpeed;
        this.f_107216_ = pYSpeed;
        this.f_107217_ = pZSpeed;
        this.f_107227_ = 0.635f;
        this.f_107228_ = 0.0f;
        this.f_107229_ = 1.0f;
        this.m_108337_(pSprites.m_7102_(this.f_107223_));
        this.f_107225_ = 80;
        this.f_107226_ = 0.02f;
    }

    public ElixirOrbParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, int size) {
        super(pLevel, pX, pY, pZ);
        this.f_107215_ = pXSpeed;
        this.f_107216_ = pYSpeed;
        this.f_107217_ = pZSpeed;
        this.f_107227_ = 0.635f;
        this.f_107228_ = 0.0f;
        this.f_107229_ = 1.0f;
        this.f_107225_ = 80;
        this.f_107226_ = 0.02f;
        this.f_108321_ = ((AccessorParticleEngine)Minecraft.m_91087_().f_91061_).getTextureAtlas().m_118316_(WoldsVaults.id("particle/elixir_" + size));
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107216_ -= (double)this.f_107226_;
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        this.m_107271_(1.0f - (float)this.f_107224_ / (float)this.m_107273_());
    }

    public void m_6257_(double pX, double pY, double pZ) {
        if (!this.stoppedByCollision) {
            boolean hitCeiling;
            double d0 = pX;
            double d1 = pY;
            double d2 = pZ;
            if (this.f_107219_ && (pX != 0.0 || pY != 0.0 || pZ != 0.0) && pX * pX + pY * pY + pZ * pZ < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
                Vec3 vec3 = Entity.m_198894_((Entity)null, (Vec3)new Vec3(pX, pY, pZ), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
                pX = vec3.f_82479_;
                pY = vec3.f_82480_;
                pZ = vec3.f_82481_;
            }
            if (pX != 0.0 || pY != 0.0 || pZ != 0.0) {
                this.m_107259_(this.m_107277_().m_82386_(pX, pY, pZ));
                this.m_107275_();
            }
            if (Math.abs(d1) >= (double)1.0E-5f && Math.abs(pY) < (double)1.0E-5f) {
                this.stoppedByCollision = true;
            }
            this.f_107218_ = d1 != pY && d1 < 0.0;
            boolean bl = hitCeiling = d1 != pY && d1 > 0.0;
            if (hitCeiling) {
                this.f_107216_ = Math.min(this.f_107216_, -0.02);
            }
            if (d0 != pX) {
                this.f_107215_ = 0.0;
            }
            if (d2 != pZ) {
                this.f_107217_ = 0.0;
            }
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public float m_5902_(float pScaleFactor) {
        return super.m_5902_(pScaleFactor);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ElixirOrbParticle(worldIn, x + 0.5, y + 0.5, z + 0.5, xSpeed, ySpeed, zSpeed, this.sprites);
        }
    }
}

