/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import iskallia.vault.block.entity.MonolithTileEntity;
import iskallia.vault.init.ModParticles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.IntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import xyz.iwolfking.woldsvaults.blocks.BrewingAltar;
import xyz.iwolfking.woldsvaults.blocks.tiles.BrewingAltarTileEntity;
import xyz.iwolfking.woldsvaults.init.ModItems;
import xyz.iwolfking.woldsvaults.items.alchemy.AlchemyIngredientItem;
import xyz.iwolfking.woldsvaults.items.alchemy.DecoPotionItem;

public class BrewingAltarRenderer
implements BlockEntityRenderer<BrewingAltarTileEntity> {
    private static final Minecraft mc = Minecraft.m_91087_();
    private float currentAngle = 0.0f;
    private float currentHover = 0.0f;
    private float currentRotationSpeed = 0.0f;

    public BrewingAltarRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public void render(@NotNull BrewingAltarTileEntity pBlockEntity, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        ClientLevel level = BrewingAltarRenderer.mc.f_91073_;
        if (level == null) {
            return;
        }
        if (pBlockEntity.hasExpired()) {
            return;
        }
        if ((Integer)pBlockEntity.m_58900_().m_61143_((Property)BrewingAltar.USES) == 0 && !pBlockEntity.hasExpired()) {
            BrewingAltarRenderer.playExpireEffects((Level)level, pBlockEntity);
            return;
        }
        NonNullList<ItemStack> items = pBlockEntity.getAllIngredients();
        BrewingAltarRenderer.renderText(pBlockEntity, pPoseStack, pBufferSource);
        this.renderPotion((Level)level, pBlockEntity, pPoseStack, pBufferSource, pPackedOverlay, AlchemyIngredientItem.filterForAlchemyIngredients(items));
        BrewingAltarRenderer.renderFloatingItems(pPoseStack, pBufferSource, pPackedOverlay, items.size(), arg_0 -> items.get(arg_0), i -> (double)((float)i / (float)items.size() * 2.0f) * Math.PI + Math.PI * ((double)System.currentTimeMillis() / 3000.0) % (Math.PI * 2));
        this.renderCatalysts(pPoseStack, pBufferSource, pPackedOverlay, pBlockEntity.getCatalyst());
    }

    private void renderCatalysts(@NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, int pPackedOverlay, ItemStack catalyst) {
        if (catalyst.m_41720_() == ModItems.INGREDIENT_TEMPLATE) {
            return;
        }
        catalyst.m_41663_(Enchantments.f_44986_, 3);
        BakedModel model = mc.m_91291_().m_174264_(catalyst, null, null, 0);
        Vec3[] positions = new Vec3[]{new Vec3(0.5, 0.35, 0.0), new Vec3(1.0, 0.35, 0.5), new Vec3(0.5, 0.35, 1.0), new Vec3(0.0, 0.35, 0.5)};
        float rot = 0.0f;
        for (Vec3 pos : positions) {
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
            pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(rot));
            mc.m_91291_().m_115143_(catalyst, ItemTransforms.TransformType.GROUND, true, pPoseStack, pBufferSource, 0xFFFFFF, pPackedOverlay, model);
            pPoseStack.m_85849_();
            rot += 90.0f;
        }
    }

    private void renderPotion(Level level, BrewingAltarTileEntity pBlockEntity, PoseStack poseStack, MultiBufferSource buffer, int overlay, List<ItemStack> items) {
        ItemStack item = ModItems.DECO_POTION.m_7968_();
        Item item2 = item.m_41720_();
        if (item2 instanceof DecoPotionItem) {
            DecoPotionItem it = (DecoPotionItem)item2;
            it.setTypeBasedOnContents(items);
            int mixedColor = AlchemyIngredientItem.getMixedColor(items);
            DecoPotionItem.setColor(item, mixedColor);
            float partialTicks = Minecraft.m_91087_().m_91296_();
            long gameTime = level.m_46467_();
            boolean hasIngredients = !items.isEmpty();
            float targetHover = hasIngredients ? (float)Math.sin(((float)gameTime + partialTicks) * 0.1f) * 0.1f : 0.0f;
            float targetRotationSpeed = hasIngredients ? 2.0f * Math.max(0.2f, (float)items.size()) * 0.5f : 0.5f;
            this.currentHover = Mth.m_14179_((float)0.01f, (float)this.currentHover, (float)targetHover);
            float deltaAngle = this.currentRotationSpeed = Mth.m_14179_((float)0.01f, (float)this.currentRotationSpeed, (float)targetRotationSpeed);
            this.currentAngle = (this.currentAngle + deltaAngle) % 360.0f;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 1.25 + (double)this.currentHover, 0.5);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(this.currentAngle));
            BakedModel ibakedmodel = mc.m_91291_().m_174264_(item, null, null, 0);
            mc.m_91291_().m_115143_(item, ItemTransforms.TransformType.GROUND, true, poseStack, buffer, 0xFFFFFF, overlay, ibakedmodel);
            poseStack.m_85849_();
            if (items.size() == 3 && level.f_46441_.nextFloat() < 0.01f) {
                this.spawnParticles(pBlockEntity.m_58899_(), level.f_46441_, mixedColor);
            }
        }
    }

    private static void playExpireEffects(Level level, BrewingAltarTileEntity pBlockEntity) {
        double x = (double)pBlockEntity.m_58899_().m_123341_() + 0.5;
        double y = (double)pBlockEntity.m_58899_().m_123342_() + 1.2;
        double z = (double)pBlockEntity.m_58899_().m_123343_() + 0.5;
        ParticleEngine pm = BrewingAltarRenderer.mc.f_91061_;
        for (int i = 0; i < 200; ++i) {
            double angle = level.f_46441_.nextDouble() * 2.0 * Math.PI;
            double speed = 0.2 + level.f_46441_.nextDouble() * 0.3;
            double dx = Math.cos(angle) * speed;
            double dz = Math.sin(angle) * speed;
            double dy = 0.1 + level.f_46441_.nextDouble() * 0.1;
            Particle p = pm.m_107370_((ParticleOptions)ModParticles.BONK.get(), x, y, z, dx, dy, dz);
            if (p == null) continue;
            p.m_107253_(1.0f, 0.0f, 0.0f);
        }
        MonolithTileEntity.spawnIgniteParticles((BlockPos)pBlockEntity.m_58899_());
        BrewingAltarRenderer.mc.f_91073_.m_7785_(x, y, z, SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.5f, false);
        pBlockEntity.setHasExpired(true);
    }

    private static void renderFloatingItems(PoseStack poseStack, MultiBufferSource buffer, int pPackedOverlay, int count, IntFunction<ItemStack> getItem, IntFunction<Double> getAngle) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.2, 0.5);
        poseStack.m_85841_(1.2f, 1.2f, 1.2f);
        for (int i = 0; i < count; ++i) {
            ItemStack item = getItem.apply(i);
            if (item.m_41619_()) continue;
            poseStack.m_85836_();
            double angle = getAngle.apply(i);
            double y = Math.sin(angle) * 1.2;
            double x = Math.cos(angle) * 1.2;
            poseStack.m_85837_(x, Math.sin(angle * 2.0) * 0.1, y);
            poseStack.m_85845_(Vector3f.f_122224_.m_122270_((float)(angle + 1.5707963267948966)));
            BakedModel ibakedmodel = mc.m_91291_().m_174264_(item, null, null, 0);
            mc.m_91291_().m_115143_(item, ItemTransforms.TransformType.GROUND, true, poseStack, buffer, 0xFFFFFF, pPackedOverlay, ibakedmodel);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private static void renderText(BrewingAltarTileEntity tileEntity, PoseStack poseStack, MultiBufferSource bufferSource) {
        AlchemyIngredientItem.AlchemyIngredientType type;
        ArrayList<Object> lines = new ArrayList<Object>();
        HashMap<AlchemyIngredientItem.AlchemyIngredientType, Integer> typeCounts = new HashMap<AlchemyIngredientItem.AlchemyIngredientType, Integer>();
        Font fontRenderer = BrewingAltarRenderer.mc.f_91062_;
        BrewingAltarTileEntity.PercentageResult result = tileEntity.getProgressIncrease();
        ArrayList<Object> filtered = new ArrayList<Object>();
        for (Object stack : tileEntity.getAllIngredients()) {
            Item item = stack.m_41720_();
            if (!(item instanceof AlchemyIngredientItem)) continue;
            AlchemyIngredientItem ingredient = (AlchemyIngredientItem)item;
            filtered.add(stack);
            type = ingredient.getType();
            typeCounts.put(type, typeCounts.getOrDefault((Object)type, 0) + 1);
        }
        int totalRelevant = 0;
        for (Map.Entry entry : typeCounts.entrySet()) {
            if (entry.getKey() == AlchemyIngredientItem.AlchemyIngredientType.NEUTRAL) continue;
            totalRelevant += ((Integer)entry.getValue()).intValue();
        }
        for (Map.Entry entry : typeCounts.entrySet()) {
            type = (AlchemyIngredientItem.AlchemyIngredientType)((Object)entry.getKey());
            int count = (Integer)entry.getValue();
            if (type == AlchemyIngredientItem.AlchemyIngredientType.NEUTRAL) continue;
            int percentage = (int)((float)count / (float)totalRelevant * 100.0f);
            lines.add(AlchemyIngredientItem.getEffectComponent(type, percentage));
        }
        if (!filtered.isEmpty()) {
            TextComponent display = new TextComponent("Adds ");
            String val1 = String.format("%.1f%%", Float.valueOf(result.min() * 100.0f));
            if (result.isRange()) {
                String val2 = String.format("%.1f%%", Float.valueOf(result.max() * 100.0f));
                display.m_7220_((Component)new TextComponent("between ")).m_7220_((Component)new TextComponent(val1).m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent(" and ")).m_7220_((Component)new TextComponent(val2).m_130948_(Style.f_131099_.m_178520_(15787660)));
            } else {
                display.m_7220_((Component)new TextComponent(val1).m_130948_(Style.f_131099_.m_178520_(15787660)));
            }
            display.m_7220_((Component)new TextComponent(" to the Objective Progression"));
            lines.add(display);
        }
        if (tileEntity.isFilled()) {
            lines.add(new TextComponent("Right click to brew!").m_130948_(Style.f_131099_.m_178520_(65284)));
        }
        int length = lines.size();
        for (int i = length - 1; i >= 0; --i) {
            MutableComponent text = (MutableComponent)lines.get(i);
            if (text == null) continue;
            float scale = 0.02f;
            int color = -1;
            int opacity = 0x66000000;
            poseStack.m_85836_();
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            float offset = -fontRenderer.m_92852_((FormattedText)text) / 2;
            poseStack.m_85837_(0.5, (double)(1.7f + 0.25f * (float)(length - i)), 0.5);
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_85845_(mc.m_91290_().m_114470_());
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            fontRenderer.m_92841_((Component)text, offset, 0.0f, color, false, matrix4f, bufferSource, true, opacity, 0xFFFFFF);
            fontRenderer.m_92841_((Component)text, offset, 0.0f, -1, false, matrix4f, bufferSource, false, 0xFFFFFF, 0xFFFFFF);
            poseStack.m_85849_();
        }
    }

    private void spawnParticles(BlockPos pos, Random random, int color) {
        double centerX = (double)pos.m_123341_() + 0.5;
        double centerY = (double)pos.m_123342_() + 1.25;
        double centerZ = (double)pos.m_123343_() + 0.5;
        ParticleEngine pm = BrewingAltarRenderer.mc.f_91061_;
        int particleCount = 3 + random.nextInt(3);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        for (int i = 0; i < particleCount; ++i) {
            double angle = random.nextDouble() * Math.PI * 2.0;
            double speed = 0.05 + random.nextDouble() * 0.1;
            double dx = Math.cos(angle) * speed;
            double dz = Math.sin(angle) * speed;
            double dy = 0.02 + random.nextDouble() * 0.03;
            Particle p = pm.m_107370_((ParticleOptions)ModParticles.BONK.get(), centerX, centerY, centerZ, dx, dy, dz);
            if (p == null) continue;
            p.m_107253_(r, g, b);
        }
    }
}

