/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Vector3f;
import iskallia.vault.task.renderer.context.RendererContext;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import xyz.iwolfking.woldsvaults.api.util.ComponentUtils;
import xyz.iwolfking.woldsvaults.blocks.tiles.FracturedObeliskTileEntity;

public class FracturedObeliskRenderer
implements BlockEntityRenderer<FracturedObeliskTileEntity> {
    private final Font font;

    public FracturedObeliskRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.m_173586_();
    }

    public void render(@NotNull FracturedObeliskTileEntity tileEntity, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlayIn) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        RenderSystem.m_69482_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 3.25, 0.5);
        matrixStack.m_85841_(0.02f, 0.02f, 0.02f);
        matrixStack.m_85845_(Minecraft.m_91087_().m_91290_().m_114470_());
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStack.m_85837_(-65.0, -11.0, 0.0);
        RendererContext context = new RendererContext(matrixStack, partialTicks, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()), this.font);
        float alpha = FracturedObeliskRenderer.getAlpha(tileEntity, (Player)player);
        if (alpha < 0.1f) {
            matrixStack.m_85849_();
            return;
        }
        int alphaByte = (int)(alpha * 255.0f);
        int textColor = alphaByte << 24 | 0xFFFFFF;
        int shadowAlphaByte = (int)(alpha * 0.5f * 255.0f);
        int shadowColor = shadowAlphaByte << 24;
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        float obf = Math.max(0.0f, Math.min(1.0f, tileEntity.getPercentObfuscated()));
        if (tileEntity.getInitialCompletion()) {
            lines.add(ComponentUtils.partiallyObfuscate(new TextComponent("Echoes surge from the wound, but find no resolve.").m_130940_(ChatFormatting.DARK_RED), obf));
            lines.add(ComponentUtils.partiallyObfuscate(new TextComponent("This is not ascent. It is collapse.").m_130940_(ChatFormatting.DARK_RED), obf));
        } else {
            lines.add(ComponentUtils.partiallyObfuscate(new TextComponent("Shattered purpose, remade in ruin;").m_130940_(ChatFormatting.DARK_RED), obf));
            lines.add(ComponentUtils.partiallyObfuscate(new TextComponent("Lingering with dread, yet no way to escape").m_130940_(ChatFormatting.DARK_RED), obf));
            lines.add(ComponentUtils.partiallyObfuscate(new TextComponent("Beneath, the world forgets what it buried.").m_130940_(ChatFormatting.DARK_RED), obf));
        }
        for (Component component : lines) {
            context.renderText((Component)component.m_6881_().m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLACK)), 66.0f, 68.0f, true, true, shadowColor, false);
            context.renderText(component, 65.0f, 67.0f, true, true, textColor, false);
            context.translate(0.0, -11.0, 0.0);
        }
        matrixStack.m_85849_();
    }

    private static float getAlpha(@NotNull FracturedObeliskTileEntity tileEntity, Player player) {
        double dx = player.m_20185_() - (double)tileEntity.m_58899_().m_123341_();
        double dy = player.m_20186_() + (double)player.m_20192_() - ((double)tileEntity.m_58899_().m_123342_() + 1.5);
        double dz = player.m_20189_() - (double)tileEntity.m_58899_().m_123343_();
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        float fadeStart = 10.0f;
        float fadeEnd = 25.0f;
        float alpha = 1.0f;
        if (distance > (double)fadeStart) {
            alpha = 1.0f - (float)(distance - (double)fadeStart) / (fadeEnd - fadeStart);
        }
        alpha = Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f);
        return alpha;
    }
}

