/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.FloatRangeEntry;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.util.WeightedList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import xyz.iwolfking.woldsvaults.blocks.tiles.BrewingAltarTileEntity;
import xyz.iwolfking.woldsvaults.init.ModItems;
import xyz.iwolfking.woldsvaults.items.alchemy.AlchemyIngredientItem;

public class AlchemyObjectiveConfig
extends Config {
    @Expose
    private LevelEntryList<Entry> levels;

    public String getName() {
        return "alchemy_objective";
    }

    protected void reset() {
        this.levels = new LevelEntryList();
        this.levels.put((LevelEntryList.ILevelEntry)new Entry(0, VaultMod.id((String)"alchemy_strong_negative"), VaultMod.id((String)"alchemy_negative"), VaultMod.id((String)"alchemy_positive"), VaultMod.id((String)"alchemy_strong_positive"), 0.5f, 0.005f, 0.005f, (WeightedList<ItemStack>)new WeightedList().add((Object)new ItemStack((ItemLike)ModItems.ROTTEN_HEART), (Number)1).add((Object)new ItemStack((ItemLike)ModItems.ROTTEN_APPLE), (Number)4).add((Object)new ItemStack((ItemLike)ModItems.VERDANT_GLOBULE), (Number)8).add((Object)new ItemStack((ItemLike)ModItems.ERRATIC_EMBER), (Number)2).add((Object)new ItemStack((ItemLike)ModItems.REFINED_POWDER), (Number)4).add((Object)new ItemStack((ItemLike)ModItems.AURIC_CRYSTAL), (Number)1), (WeightedList<ItemStack>)new WeightedList().add((Object)new ItemStack((ItemLike)ModItems.ROTTEN_HEART), (Number)1).add((Object)new ItemStack((ItemLike)ModItems.ROTTEN_APPLE), (Number)4).add((Object)new ItemStack((ItemLike)ModItems.VERDANT_GLOBULE), (Number)8).add((Object)new ItemStack((ItemLike)ModItems.ERRATIC_EMBER), (Number)2).add((Object)new ItemStack((ItemLike)ModItems.REFINED_POWDER), (Number)4).add((Object)new ItemStack((ItemLike)ModItems.AURIC_CRYSTAL), (Number)1), (WeightedList<ItemStack>)new WeightedList().add((Object)new ItemStack((ItemLike)ModItems.ROTTEN_HEART), (Number)1).add((Object)new ItemStack((ItemLike)ModItems.ROTTEN_APPLE), (Number)4).add((Object)new ItemStack((ItemLike)ModItems.VERDANT_GLOBULE), (Number)8).add((Object)new ItemStack((ItemLike)ModItems.ERRATIC_EMBER), (Number)2).add((Object)new ItemStack((ItemLike)ModItems.REFINED_POWDER), (Number)4).add((Object)new ItemStack((ItemLike)ModItems.AURIC_CRYSTAL), (Number)1), 0.3f, 0.1f, 0.05f, new FloatRangeEntry(-0.3f, 0.3f), -0.1f, -0.3f));
    }

    public Entry getConfig(int vaultLevel) {
        return this.levels.getForLevel(vaultLevel).orElse(null);
    }

    public class Entry
    implements LevelEntryList.ILevelEntry {
        @Expose
        private final int level;
        @Expose
        private final ResourceLocation strongNegativeModifierPool;
        @Expose
        private final ResourceLocation negativeModifierPool;
        @Expose
        private final ResourceLocation positiveModifierPool;
        @Expose
        private final ResourceLocation strongPositiveModifierPool;
        @Expose
        private final float chestProbability;
        @Expose
        private final float coinProbability;
        @Expose
        private final float oreProbabiltiy;
        @Expose
        private final WeightedList<ItemStack> chestIngredients;
        @Expose
        private final WeightedList<ItemStack> coinIngredients;
        @Expose
        private final WeightedList<ItemStack> oreIngredients;
        @Expose
        private final float percentDeadlyIngredient;
        @Expose
        private final float percentRuthlessIngredient;
        @Expose
        private final float percentNeutralIngredient;
        @Expose
        private final FloatRangeEntry rangedPercentVolatileIngredient;
        @Expose
        private final float percentRefinedIngredient;
        @Expose
        private final float percentEmpoweredIngredient;

        public Entry(int level, ResourceLocation strongNegativeModifierPool, ResourceLocation negativeModifierPool, ResourceLocation positiveModifierPool, ResourceLocation strongPositiveModifierPool, float chestProbability, float coinProbability, float oreProbabiltiy, WeightedList<ItemStack> chestIngredients, WeightedList<ItemStack> coinIngredients, WeightedList<ItemStack> oreIngredients, float percentDeadlyIngredient, float percentRuthlessIngredient, float percentNeutralIngredient, FloatRangeEntry rangedPercentVolatileIngredient, float percentRefinedIngredient, float percentEmpoweredIngredient) {
            this.level = level;
            this.strongNegativeModifierPool = strongNegativeModifierPool;
            this.negativeModifierPool = negativeModifierPool;
            this.positiveModifierPool = positiveModifierPool;
            this.strongPositiveModifierPool = strongPositiveModifierPool;
            this.chestProbability = chestProbability;
            this.coinProbability = coinProbability;
            this.oreProbabiltiy = oreProbabiltiy;
            this.chestIngredients = chestIngredients;
            this.coinIngredients = coinIngredients;
            this.oreIngredients = oreIngredients;
            this.percentDeadlyIngredient = percentDeadlyIngredient;
            this.percentRuthlessIngredient = percentRuthlessIngredient;
            this.percentNeutralIngredient = percentNeutralIngredient;
            this.rangedPercentVolatileIngredient = rangedPercentVolatileIngredient;
            this.percentRefinedIngredient = percentRefinedIngredient;
            this.percentEmpoweredIngredient = percentEmpoweredIngredient;
        }

        public int getLevel() {
            return this.level;
        }

        public ResourceLocation getStrongPositiveModifierPool() {
            return this.strongPositiveModifierPool;
        }

        public ResourceLocation getPositiveModifierPool() {
            return this.positiveModifierPool;
        }

        public ResourceLocation getNegativeModifierPool() {
            return this.negativeModifierPool;
        }

        public ResourceLocation getStrongNegativeModifierPool() {
            return this.strongNegativeModifierPool;
        }

        public float getChestProbability() {
            return this.chestProbability;
        }

        public float getCoinProbability() {
            return this.coinProbability;
        }

        public float getOreProbabiltiy() {
            return this.oreProbabiltiy;
        }

        public WeightedList<ItemStack> getChestIngredients() {
            return this.chestIngredients;
        }

        public WeightedList<ItemStack> getCoinIngredients() {
            return this.coinIngredients;
        }

        public WeightedList<ItemStack> getOreIngredients() {
            return this.oreIngredients;
        }

        public String getFormattedPercentIngredient(AlchemyIngredientItem.AlchemyIngredientType type) {
            switch (type) {
                case DEADLY: {
                    return String.format("%.1f", Float.valueOf(this.percentDeadlyIngredient * 100.0f)) + "%";
                }
                case RUTHLESS: {
                    return String.format("%.1f", Float.valueOf(this.percentRuthlessIngredient * 100.0f)) + "%";
                }
                case NEUTRAL: {
                    return String.format("%.1f", Float.valueOf(this.percentNeutralIngredient * 100.0f)) + "%";
                }
                case VOLATILE: {
                    return "between " + String.format("%.1f", Float.valueOf(this.rangedPercentVolatileIngredient.getMin() * 100.0f)) + "% and " + String.format("%.1f", Float.valueOf(this.rangedPercentVolatileIngredient.getMax() * 100.0f)) + "%";
                }
                case EMPOWERED: {
                    return String.format("%.1f", Float.valueOf(this.percentEmpoweredIngredient * 100.0f)) + "%";
                }
                case REFINED: {
                    return String.format("%.1f", Float.valueOf(this.percentRefinedIngredient * 100.0f)) + "%";
                }
            }
            return "What the hell did you do";
        }

        public BrewingAltarTileEntity.PercentageResult getPercentageForType(AlchemyIngredientItem item) {
            return switch (item.getType()) {
                default -> throw new IncompatibleClassChangeError();
                case AlchemyIngredientItem.AlchemyIngredientType.DEADLY -> new BrewingAltarTileEntity.PercentageResult(this.percentDeadlyIngredient, this.percentDeadlyIngredient);
                case AlchemyIngredientItem.AlchemyIngredientType.RUTHLESS -> new BrewingAltarTileEntity.PercentageResult(this.percentRuthlessIngredient, this.percentRuthlessIngredient);
                case AlchemyIngredientItem.AlchemyIngredientType.NEUTRAL -> new BrewingAltarTileEntity.PercentageResult(this.percentNeutralIngredient, this.percentNeutralIngredient);
                case AlchemyIngredientItem.AlchemyIngredientType.EMPOWERED -> new BrewingAltarTileEntity.PercentageResult(this.percentEmpoweredIngredient, this.percentEmpoweredIngredient);
                case AlchemyIngredientItem.AlchemyIngredientType.REFINED -> new BrewingAltarTileEntity.PercentageResult(this.percentRefinedIngredient, this.percentRefinedIngredient);
                case AlchemyIngredientItem.AlchemyIngredientType.VOLATILE -> new BrewingAltarTileEntity.PercentageResult(this.rangedPercentVolatileIngredient.getMin(), this.rangedPercentVolatileIngredient.getMax());
            };
        }
    }
}

