/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.altar.RequiredItems;
import iskallia.vault.config.Config;
import iskallia.vault.config.altar.entry.AltarIngredientEntry;
import iskallia.vault.config.entry.LevelEntryMap;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.expertise.type.LuckyAltarExpertise;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.data.WeightedList;
import iskallia.vault.world.VaultCrystalMode;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.PlayerStatsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GreedVaultAltarIngredientsConfig
extends Config {
    @Expose
    private LevelEntryMap<Map<String, WeightedList<AltarIngredientEntry>>> LEVELS = new LevelEntryMap();

    public String getName() {
        return "vault_altar/vault_altar_ingredients_greed";
    }

    protected void reset() {
        for (int i = 0; i < 31; i += 5) {
            HashMap<String, WeightedList> map = new HashMap<String, WeightedList>();
            List<ItemStack> wool = List.of(new ItemStack((ItemLike)Items.f_41938_), new ItemStack((ItemLike)Items.f_41934_), new ItemStack((ItemLike)Items.f_41935_), new ItemStack((ItemLike)Items.f_41932_));
            List<ItemStack> stone = List.of(new ItemStack((ItemLike)Items.f_41905_), new ItemStack((ItemLike)Items.f_42170_), new ItemStack((ItemLike)Items.f_42064_));
            List<ItemStack> ingots = List.of(new ItemStack((ItemLike)Items.f_42415_), new ItemStack((ItemLike)Items.f_42417_), new ItemStack((ItemLike)Items.f_42416_));
            List<ItemStack> misc = List.of(new ItemStack((ItemLike)Items.f_42716_), new ItemStack((ItemLike)Items.f_42747_), new ItemStack((ItemLike)Items.f_42683_));
            List<ItemStack> farmable = List.of(new ItemStack((ItemLike)Items.f_41909_), new ItemStack((ItemLike)Items.f_41982_), new ItemStack((ItemLike)Items.f_42404_));
            map.put("resource", new WeightedList(Map.of(new AltarIngredientEntry(wool, 10, 50, 0.8), 1)).add((Object)new AltarIngredientEntry(stone, 64, 128, 0.8), 1));
            map.put("mob", new WeightedList(Map.of(new AltarIngredientEntry(ingots, 64, 128, 0.8), 1)));
            map.put("farmable", new WeightedList(Map.of(new AltarIngredientEntry(wool, 10, 50, 0.8), 1)).add((Object)new AltarIngredientEntry(farmable, 64, 128, 0.8), 1));
            map.put("misc", new WeightedList(Map.of(new AltarIngredientEntry(misc, 1, 1, 1.0), 1)));
            this.LEVELS.put((Object)i, map);
        }
    }

    protected Map<String, AltarIngredientEntry> getEntries(int vaultLevel) {
        Optional pool = this.LEVELS.getForLevel(vaultLevel);
        if (pool.isEmpty()) {
            throw new IllegalArgumentException("No entry found for the given level: " + vaultLevel);
        }
        Map map = (Map)pool.get();
        HashMap<String, AltarIngredientEntry> recipe = new HashMap<String, AltarIngredientEntry>();
        map.forEach((k, v) -> recipe.put((String)k, (AltarIngredientEntry)v.getRandom(Config.rand)));
        return recipe;
    }

    public List<RequiredItems> getIngredients(ServerPlayer player, BlockPos pos) {
        ServerLevel level = player.m_183503_();
        boolean isLucky = false;
        int altarLevel = PlayerVaultStatsData.get((ServerLevel)level).getVaultStats((Player)player).getVaultLevel();
        int crystalsCrafted = PlayerStatsData.get((MinecraftServer)level.m_142572_()).get(player.m_142081_()).getCrystals().size();
        VaultCrystalMode mode = ((VaultCrystalMode.GameRuleValue)player.m_183503_().m_46469_().m_46170_(ModGameRules.CRYSTAL_MODE)).get();
        float amtMultiplier = mode.getMultiplier();
        float luckyAltarChance = 0.0f;
        ExpertiseTree expertises = PlayerExpertisesData.get((ServerLevel)level).getExpertises((Player)player);
        for (LuckyAltarExpertise expertise : expertises.getAll(LuckyAltarExpertise.class, Skill::isUnlocked)) {
            luckyAltarChance += expertise.getLuckyAltarChance();
        }
        if (Config.rand.nextFloat() < luckyAltarChance * 0.1f) {
            this.spawnLuckyEffects((Level)level, pos);
            isLucky = true;
        }
        ArrayList<RequiredItems> requiredItems = new ArrayList<RequiredItems>();
        Map<String, AltarIngredientEntry> entries = this.getEntries(altarLevel);
        for (Map.Entry<String, AltarIngredientEntry> entry : entries.entrySet()) {
            String poolId = entry.getKey();
            AltarIngredientEntry ingredientEntry = entry.getValue();
            List<ItemStack> items = ingredientEntry.getItems().stream().map(ItemStack::m_41777_).peek(itemStack -> itemStack.m_41764_(1)).toList();
            int amount = ingredientEntry.getAmount();
            if (isLucky) {
                amount = 0;
            } else if (ingredientEntry.getScale() != 0.0) {
                double scale = this.getScale(poolId, (int)((double)crystalsCrafted * 0.05));
                amount = Math.max((int)((double)Math.round((double)amount * scale * (double)amtMultiplier) * ingredientEntry.getScale()), mode.getMinCost());
            } else {
                amount = Math.max(Math.round((float)amount * amtMultiplier), mode.getMinCost());
            }
            requiredItems.add(new RequiredItems(poolId, items, amount));
        }
        return requiredItems;
    }

    private double getScale(String poolId, int crystalsCrafted) {
        double resourceAmount = 250.0 / (1.0 + Math.exp(((double)(-crystalsCrafted) + 260.0) / 140.0)) - 32.759;
        double mobAmount = 287.5 / (1.0 + Math.exp(((double)(-crystalsCrafted) + 260.0) / 140.0)) - 37.67285;
        double farmableAmount = 800.0 * Math.atan((double)crystalsCrafted / 400.0) / Math.PI + 1.0;
        double miscAmount = (double)crystalsCrafted / 32.0 + 1.0;
        switch (poolId) {
            case "resource": {
                return resourceAmount;
            }
            case "mob": {
                return mobAmount;
            }
            case "farmable": {
                return farmableAmount;
            }
        }
        return miscAmount;
    }

    private void spawnLuckyEffects(Level world, BlockPos pos) {
        for (int i = 0; i < 30; ++i) {
            Vec3 offset = MiscUtils.getRandomOffset((BlockPos)pos, (Random)Config.rand, (float)2.0f);
            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123748_, offset.f_82479_, offset.f_82480_, offset.f_82481_, 3, 0.0, 0.0, 0.0, 1.0);
        }
        world.m_5594_(null, pos, SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

