/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.util.GlobUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;

public class ResearchExclusionConfig
extends Config {
    @Expose
    public Map<String, List<String>> RESEARCH_EXCLUSIONS = new HashMap<String, List<String>>();
    public Map<String, Map<String, Boolean>> researchExclusionCache = new ConcurrentHashMap<String, Map<String, Boolean>>();

    public String getName() {
        return "research_exclusions";
    }

    protected void reset() {
    }

    public boolean isExcludedFromResearch(String researchName, ResourceLocation itemId) {
        if (!(this.RESEARCH_EXCLUSIONS instanceof ConcurrentHashMap)) {
            this.RESEARCH_EXCLUSIONS = new ConcurrentHashMap<String, List<String>>(this.RESEARCH_EXCLUSIONS);
        }
        if (!this.RESEARCH_EXCLUSIONS.containsKey(researchName)) {
            return false;
        }
        if (!this.researchExclusionCache.containsKey(researchName)) {
            this.researchExclusionCache.put(researchName, new HashMap());
        }
        if (itemId == null) {
            return false;
        }
        Map<String, Boolean> researchCache = this.researchExclusionCache.get(researchName);
        return researchCache.computeIfAbsent(itemId.toString(), id -> {
            for (String pattern : this.RESEARCH_EXCLUSIONS.get(researchName)) {
                if (pattern.startsWith("!")) {
                    if (!GlobUtils.matches((String)pattern.substring(1), (String)id)) continue;
                    return false;
                }
                if (!GlobUtils.matches((String)pattern, (String)id)) continue;
                return true;
            }
            return false;
        });
    }
}

