/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.config.recipes.weaving;

import iskallia.vault.config.recipe.ForgeRecipeType;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import xyz.iwolfking.woldsvaults.config.TrinketPouchConfig;
import xyz.iwolfking.woldsvaults.data.discovery.ClientRecipeDiscoveryData;
import xyz.iwolfking.woldsvaults.data.discovery.DiscoveredRecipesData;
import xyz.iwolfking.woldsvaults.init.ModConfigs;
import xyz.iwolfking.woldsvaults.items.TrinketPouchItem;

public class WeavingForgeRecipe
extends VaultForgeRecipe {
    public WeavingForgeRecipe(ResourceLocation id, ItemStack output, List<ItemStack> inputs) {
        super(ForgeRecipeType.valueOf((String)"WEAVING"), id, output, inputs);
    }

    public WeavingForgeRecipe(Object o, Object o1) {
        super(ForgeRecipeType.valueOf((String)"WEAVING"), (ResourceLocation)o, (ItemStack)o1);
    }

    public ItemStack createOutput(List<OverSizedItemStack> consumed, ServerPlayer crafter, int vaultLevel) {
        return super.createOutput(consumed, crafter, vaultLevel);
    }

    public void addCraftingDisplayTooltip(ItemStack result, List<Component> out) {
        if (result.m_41720_() instanceof TrinketPouchItem) {
            TrinketPouchConfig.TrinketPouchConfigEntry entry = TrinketPouchItem.getPouchConfigFor(result);
            for (String key : entry.SLOT_ENTRIES.keySet()) {
                out.add((Component)new TextComponent("+" + entry.SLOT_ENTRIES.get(key) + " " + WeavingForgeRecipe.getTranslatedTrinketName(key) + " Slots").m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    private static String getTranslatedTrinketName(String key) {
        if (key.equals("red_trinket")) {
            return "Red Trinket";
        }
        if (key.equals("blue_trinket")) {
            return "Blue Trinket";
        }
        if (key.equals("green_trinket")) {
            return "Green Trinket";
        }
        return key;
    }

    public boolean canCraft(Player player) {
        if (ModConfigs.RECIPE_UNLOCKS.RECIPE_UNLOCKS.containsKey(this.getId())) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)player;
                return player.m_7500_() || DiscoveredRecipesData.get(sPlayer.f_8924_).hasDiscovered(player, this.getId());
            }
            return player.m_7500_() || ClientRecipeDiscoveryData.getDiscoveredRecipes().contains(this.getId());
        }
        return true;
    }

    public List<Component> getDisabledText() {
        if (ModConfigs.RECIPE_UNLOCKS.RECIPE_UNLOCKS.containsKey(this.getId())) {
            return List.of(new TextComponent(ModConfigs.RECIPE_UNLOCKS.RECIPE_UNLOCKS.get((Object)this.getId()).DESCRIPTION));
        }
        return super.getDisabledText();
    }
}

