/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.data.discovery;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.transmog.DiscoveredEntriesMessage;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;
import xyz.iwolfking.woldsvaults.config.RecipeUnlocksConfig;
import xyz.iwolfking.woldsvaults.init.ModConfigs;

public class DiscoveredRecipesData
extends SavedData {
    protected static final String DATA_NAME = "woldsvaults_Discovered_Recipes";
    protected Map<UUID, Set<ResourceLocation>> collectedRecipes = new HashMap<UUID, Set<ResourceLocation>>();

    private DiscoveredRecipesData() {
    }

    private DiscoveredRecipesData(CompoundTag tag) {
        this.load(tag);
    }

    public void discoverRecipeAndBroadcast(ResourceLocation recipe, Player player) {
        if (recipe != null && this.discoverRecipe(player.m_142081_(), recipe)) {
            this.broadcastDiscovery(recipe, player);
        }
    }

    private void broadcastDiscovery(ResourceLocation recipe, Player player) {
        MutableComponent ct = new TextComponent("").m_130940_(ChatFormatting.WHITE);
        MutableComponent playerCt = player.m_5446_().m_6881_();
        playerCt.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
        if (ModConfigs.RECIPE_UNLOCKS.RECIPE_UNLOCKS.containsKey(recipe)) {
            RecipeUnlocksConfig.Entry entry = ModConfigs.RECIPE_UNLOCKS.RECIPE_UNLOCKS.get(recipe);
            MutableComponent recipeCmp = new TextComponent(entry.NAME).m_130940_(ChatFormatting.GOLD);
            MiscUtils.broadcast((Component)ct.m_7220_((Component)playerCt).m_130946_(" has discovered recipe for: ").m_7220_((Component)recipeCmp));
        }
    }

    public boolean discoverRecipe(UUID playerId, ResourceLocation recipeId) {
        Set recipeKeys = this.collectedRecipes.computeIfAbsent(playerId, id -> new HashSet());
        if (recipeKeys.add(recipeId)) {
            this.m_77762_();
            return true;
        }
        return false;
    }

    public boolean hasDiscovered(Player player, ResourceLocation recipeId) {
        return this.hasDiscovered(player.m_142081_(), recipeId);
    }

    public boolean hasDiscovered(UUID playerId, ResourceLocation recipeId) {
        return this.collectedRecipes.getOrDefault(playerId, Collections.emptySet()).contains(recipeId);
    }

    public Set<ResourceLocation> getDiscoveredRecipes(Player player) {
        return this.getDiscoveredRecipes(player.m_142081_());
    }

    public Set<ResourceLocation> getDiscoveredRecipes(UUID playerId) {
        return this.collectedRecipes.getOrDefault(playerId, Collections.emptySet());
    }

    public boolean discoveredAllRecipes(Player player) {
        return this.discoveredAllRecipes(player.m_142081_());
    }

    public boolean discoveredAllRecipes(UUID playerId) {
        Set<ResourceLocation> discovered = this.getDiscoveredRecipes(playerId);
        for (ResourceLocation existing : ModConfigs.RECIPE_UNLOCKS.RECIPE_UNLOCKS.keySet()) {
            if (discovered.contains(existing)) continue;
            return false;
        }
        return true;
    }

    public void m_77760_(boolean dirty) {
        MinecraftServer srv;
        super.m_77760_(dirty);
        if (dirty && (srv = ServerLifecycleHooks.getCurrentServer()) != null) {
            srv.m_6846_().m_11314_().forEach(this::syncTo);
        }
    }

    private DiscoveredEntriesMessage getUpdatePacket(UUID playerId) {
        return new DiscoveredEntriesMessage(DiscoveredEntriesMessage.Type.valueOf((String)"WOLD_RECIPE"), this.collectedRecipes.getOrDefault(playerId, Collections.emptySet()));
    }

    public void syncTo(ServerPlayer player) {
        ModNetwork.CHANNEL.sendTo((Object)this.getUpdatePacket(player.m_142081_()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void load(CompoundTag tag) {
        this.collectedRecipes.clear();
        ListTag playerRecipes = tag.m_128437_("recipes", 10);
        for (int i = 0; i < playerRecipes.size(); ++i) {
            CompoundTag playerTag = playerRecipes.m_128728_(i);
            UUID playerId = playerTag.m_128342_("player");
            Set themes = NBTHelper.readSet((CompoundTag)playerTag, (String)"recipes", StringTag.class, strTag -> new ResourceLocation(strTag.m_7916_()));
            this.collectedRecipes.put(playerId, themes);
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag tag) {
        ListTag playerThemes = new ListTag();
        this.collectedRecipes.forEach((playerId, recipes) -> {
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128362_("player", playerId);
            NBTHelper.writeCollection((CompoundTag)playerTag, (String)"recipes", (Collection)recipes, StringTag.class, key -> StringTag.m_129297_((String)key.toString()));
            playerThemes.add((Object)playerTag);
        });
        tag.m_128365_("recipes", (Tag)playerThemes);
        return tag;
    }

    public static DiscoveredRecipesData get(ServerLevel level) {
        return DiscoveredRecipesData.get(level.m_142572_());
    }

    public static DiscoveredRecipesData get(MinecraftServer server) {
        return (DiscoveredRecipesData)server.m_129783_().m_8895_().m_164861_(DiscoveredRecipesData::new, DiscoveredRecipesData::new, DATA_NAME);
    }
}

