/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.data.discovery;

import iskallia.vault.core.data.key.ThemeKey;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.transmog.DiscoveredEntriesMessage;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DiscoveredThemesData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_DiscoveredThemes";
    protected Map<UUID, Set<ResourceLocation>> collectedThemes = new HashMap<UUID, Set<ResourceLocation>>();

    private DiscoveredThemesData() {
    }

    private DiscoveredThemesData(CompoundTag tag) {
        this.load(tag);
    }

    public void discoverThemeAndBroadcast(ThemeKey theme, Player player) {
        if (theme != null && this.discoverTheme(player.m_142081_(), theme.getId())) {
            this.broadcastDiscovery(theme, player);
        }
    }

    private void broadcastDiscovery(ThemeKey theme, Player player) {
        MutableComponent ct = new TextComponent("").m_130940_(ChatFormatting.WHITE);
        MutableComponent playerCt = player.m_5446_().m_6881_();
        playerCt.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
        TextComponent themeCmp = new TextComponent(theme.getName());
        MiscUtils.broadcast((Component)ct.m_7220_((Component)playerCt).m_130946_(" has discovered theme: ").m_7220_((Component)themeCmp));
    }

    public boolean discoverTheme(UUID playerId, ResourceLocation themeId) {
        Set themeKeys = this.collectedThemes.computeIfAbsent(playerId, id -> new HashSet());
        if (themeKeys.add(themeId)) {
            this.m_77762_();
            return true;
        }
        return false;
    }

    public boolean hasDiscovered(Player player, ResourceLocation themeId) {
        return this.hasDiscovered(player.m_142081_(), themeId);
    }

    public boolean hasDiscovered(UUID playerId, ResourceLocation themeId) {
        return this.collectedThemes.getOrDefault(playerId, Collections.emptySet()).contains(themeId);
    }

    public Set<ResourceLocation> getDiscoveredThemes(Player player) {
        return this.getDiscoveredThemes(player.m_142081_());
    }

    public Set<ResourceLocation> getDiscoveredThemes(UUID playerId) {
        return this.collectedThemes.getOrDefault(playerId, Collections.emptySet());
    }

    public boolean discoveredAllThemes(Player player) {
        return this.discoveredAllThemes(player.m_142081_());
    }

    public boolean discoveredAllThemes(UUID playerId) {
        Set<ResourceLocation> discovered = this.getDiscoveredThemes(playerId);
        for (ThemeKey existing : VaultRegistry.THEME.getKeys()) {
            if (discovered.contains(existing.getId())) continue;
            return false;
        }
        return true;
    }

    public void m_77760_(boolean dirty) {
        MinecraftServer srv;
        super.m_77760_(dirty);
        if (dirty && (srv = ServerLifecycleHooks.getCurrentServer()) != null) {
            srv.m_6846_().m_11314_().forEach(this::syncTo);
        }
    }

    private DiscoveredEntriesMessage getUpdatePacket(UUID playerId) {
        return new DiscoveredEntriesMessage(DiscoveredEntriesMessage.Type.valueOf((String)"THEME"), this.collectedThemes.getOrDefault(playerId, Collections.emptySet()));
    }

    public void syncTo(ServerPlayer player) {
        ModNetwork.CHANNEL.sendTo((Object)this.getUpdatePacket(player.m_142081_()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void load(CompoundTag tag) {
        this.collectedThemes.clear();
        ListTag playerThemes = tag.m_128437_("themes", 10);
        for (int i = 0; i < playerThemes.size(); ++i) {
            CompoundTag playerTag = playerThemes.m_128728_(i);
            UUID playerId = playerTag.m_128342_("player");
            Set themes = NBTHelper.readSet((CompoundTag)playerTag, (String)"themes", StringTag.class, strTag -> new ResourceLocation(strTag.m_7916_()));
            this.collectedThemes.put(playerId, themes);
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag tag) {
        ListTag playerThemes = new ListTag();
        this.collectedThemes.forEach((playerId, themes) -> {
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128362_("player", playerId);
            NBTHelper.writeCollection((CompoundTag)playerTag, (String)"themes", (Collection)themes, StringTag.class, key -> StringTag.m_129297_((String)key.toString()));
            playerThemes.add((Object)playerTag);
        });
        tag.m_128365_("themes", (Tag)playerThemes);
        return tag;
    }

    public static DiscoveredThemesData get(ServerLevel level) {
        return DiscoveredThemesData.get(level.m_142572_());
    }

    public static DiscoveredThemesData get(MinecraftServer server) {
        return (DiscoveredThemesData)server.m_129783_().m_8895_().m_164861_(DiscoveredThemesData::new, DiscoveredThemesData::new, DATA_NAME);
    }
}

