/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.data.gear.util;

import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.gear.attribute.ability.AbilityLevelAttribute;
import iskallia.vault.gear.attribute.config.DoubleAttributeGenerator;
import iskallia.vault.gear.attribute.config.FloatAttributeGenerator;
import iskallia.vault.gear.attribute.config.IntegerAttributeGenerator;
import iskallia.vault.gear.attribute.custom.effect.EffectCloudAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import xyz.iwolfking.woldsvaults.WoldsVaults;
import xyz.iwolfking.woldsvaults.mixins.vaulthunters.accessors.ModifierGearTierAccessor;

public class GearModifierRegistryHelper {
    private static final String INVALID_MODIFIER_TIER = "Attempted to create an invalid modifier tier, skipping!";

    public static VaultGearTierConfig.ModifierTierGroup create(ResourceLocation modifierTypeId, String modifierGroup, ResourceLocation modifierId) {
        return GearModifierRegistryHelper.create(modifierTypeId, modifierGroup, modifierId, false);
    }

    public static VaultGearTierConfig.ModifierTierGroup create(ResourceLocation modifierTypeId, String modifierGroup, ResourceLocation modifierId, boolean hasLegendary) {
        VaultGearTierConfig.ModifierTierGroup group = new VaultGearTierConfig.ModifierTierGroup(modifierTypeId, modifierGroup, modifierId);
        if (!hasLegendary) {
            group.getTags().add("noLegendary");
        }
        return group;
    }

    public static <T> VaultGearTierConfig.ModifierTier<T> createTier(Integer minLevel, Integer maxLevel, Integer weight, Integer modifierTier, T config) {
        VaultGearTierConfig.ModifierTier tier = new VaultGearTierConfig.ModifierTier(minLevel.intValue(), weight.intValue(), config);
        if (maxLevel != null) {
            ((ModifierGearTierAccessor)tier).setMaxLevel(maxLevel);
        }
        if (modifierTier != null) {
            ((ModifierGearTierAccessor)tier).setModifierTier(modifierTier);
        }
        return tier;
    }

    public static List<VaultGearTierConfig.ModifierTier<?>> createEffectCloudTiers(String tooltipDisplayName, ResourceLocation potion, List<Integer> minLevels, List<Integer> maxLevels, List<Integer> durationValues, List<Float> radiusValues, int color, boolean affectsOwner, List<Float> triggerChanceValues, ResourceLocation additionalEffect, List<Integer> additionalEffectDurationValues, List<Integer> additionalEffectAmplifierValues, int weight) {
        if (minLevels.isEmpty() || maxLevels.isEmpty() || radiusValues.isEmpty() || minLevels.size() != maxLevels.size() || minLevels.size() != radiusValues.size()) {
            GearModifierRegistryHelper.logInvalidModifierTier();
            return List.of();
        }
        ArrayList modifierTiers = new ArrayList();
        for (int i = 0; i < maxLevels.size(); ++i) {
            EffectCloudAttribute.CloudConfig config = new EffectCloudAttribute.CloudConfig(tooltipDisplayName, potion, durationValues.get(i).intValue(), radiusValues.get(i).floatValue(), color, affectsOwner, triggerChanceValues.get(i).floatValue());
            config.setAdditionalEffect(new EffectCloudAttribute.CloudEffectConfig(additionalEffect, additionalEffectDurationValues.get(i).intValue(), additionalEffectAmplifierValues.get(i).intValue()));
            VaultGearTierConfig.ModifierTier<EffectCloudAttribute.CloudConfig> tier = GearModifierRegistryHelper.createTier(minLevels.get(i), maxLevels.get(i), weight, i, config);
            modifierTiers.add(tier);
        }
        return modifierTiers;
    }

    public static List<VaultGearTierConfig.ModifierTier<AbilityLevelAttribute.Config>> createAbilityLevelTiers(String abilityName, List<Integer> minLevels, List<Integer> maxLevels, List<Integer> values, int weight) {
        if (minLevels.isEmpty() || maxLevels.isEmpty() || values.isEmpty() || minLevels.size() != maxLevels.size() || minLevels.size() != values.size()) {
            GearModifierRegistryHelper.logInvalidModifierTier();
            return List.of();
        }
        ArrayList<VaultGearTierConfig.ModifierTier<AbilityLevelAttribute.Config>> modifierTiers = new ArrayList<VaultGearTierConfig.ModifierTier<AbilityLevelAttribute.Config>>();
        for (int i = 0; i < maxLevels.size(); ++i) {
            VaultGearTierConfig.ModifierTier<AbilityLevelAttribute.Config> tier = GearModifierRegistryHelper.createTier(minLevels.get(i), maxLevels.get(i), weight, i, new AbilityLevelAttribute.Config(abilityName, values.get(i).intValue()));
            modifierTiers.add(tier);
        }
        return modifierTiers;
    }

    public static List<VaultGearTierConfig.ModifierTier<?>> createNumberRangeTiers(List<Integer> levels, List<Integer> maxLevels, List<Number> minValues, List<Number> maxValues, Number step, int weight) {
        ArrayList modifierTiers = new ArrayList();
        if (levels.isEmpty() || minValues.isEmpty() || maxValues.isEmpty() || minValues.size() != maxValues.size() || levels.size() != maxLevels.size()) {
            GearModifierRegistryHelper.logInvalidModifierTier();
            return List.of();
        }
        for (int i = 0; i < levels.size(); ++i) {
            VaultGearTierConfig.ModifierTier<IntegerAttributeGenerator.Range> tier = null;
            if (step instanceof Integer) {
                tier = GearModifierRegistryHelper.createTier(levels.get(i), maxLevels.get(i), weight, i, new IntegerAttributeGenerator.Range(minValues.get(i).intValue(), maxValues.get(i).intValue(), step.intValue()));
            } else if (step instanceof Float) {
                tier = GearModifierRegistryHelper.createTier(levels.get(i), maxLevels.get(i), weight, i, new FloatAttributeGenerator.Range(minValues.get(i).floatValue(), maxValues.get(i).floatValue(), step.floatValue()));
            } else if (step instanceof Double) {
                tier = GearModifierRegistryHelper.createTier(levels.get(i), maxLevels.get(i), weight, i, new DoubleAttributeGenerator.Range(minValues.get(i).doubleValue(), maxValues.get(i).doubleValue(), step.doubleValue()));
            }
            if (tier == null) continue;
            modifierTiers.add(tier);
        }
        return modifierTiers;
    }

    private static void logInvalidModifierTier() {
        WoldsVaults.LOGGER.warn(INVALID_MODIFIER_TIER);
    }
}

