/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.data.recipes;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import xyz.iwolfking.woldsvaults.init.ModRecipeTypes;
import xyz.iwolfking.woldsvaults.recipes.lib.InfuserRecipe;

public class CachedInfuserRecipeData {
    private static final Set<Item> CATALYST_ITEMS = new HashSet<Item>();
    private static final Set<Item> INGREDIENT_ITEMS = new HashSet<Item>();

    public static void cacheCatalysts(Level level) {
        for (InfuserRecipe infuserRecipe : level.m_7465_().m_44013_(ModRecipeTypes.INFUSER)) {
            for (ItemStack catalystStack : infuserRecipe.getCatalyst().m_43908_()) {
                CATALYST_ITEMS.add(catalystStack.m_41720_());
            }
        }
    }

    public static void cacheIngredients(Level level) {
        for (InfuserRecipe infuserRecipe : level.m_7465_().m_44013_(ModRecipeTypes.INFUSER)) {
            for (Ingredient ingredient : infuserRecipe.m_7527_()) {
                for (ItemStack stack : ingredient.m_43908_()) {
                    INGREDIENT_ITEMS.add(stack.m_41720_());
                }
            }
        }
    }

    public static Set<Item> getCatalysts(Level level) {
        if (CATALYST_ITEMS.isEmpty()) {
            CachedInfuserRecipeData.cacheCatalysts(level);
        }
        return CATALYST_ITEMS;
    }

    public static Set<Item> getCatalysts() {
        return CATALYST_ITEMS;
    }

    public static Set<Item> getIngredients(Level level) {
        if (INGREDIENT_ITEMS.isEmpty()) {
            CachedInfuserRecipeData.cacheIngredients(level);
        }
        return INGREDIENT_ITEMS;
    }

    public static Set<Item> getIngredients() {
        return INGREDIENT_ITEMS;
    }

    public static boolean shouldCache() {
        return CATALYST_ITEMS.isEmpty() || INGREDIENT_ITEMS.isEmpty();
    }
}

