/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.datagen;

import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import xyz.iwolfking.woldsvaults.blocks.AugmentCraftingTableBlock;
import xyz.iwolfking.woldsvaults.blocks.DecoMonolithBlock;
import xyz.iwolfking.woldsvaults.blocks.DecoObeliskBlock;
import xyz.iwolfking.woldsvaults.blocks.FracturedObelisk;
import xyz.iwolfking.woldsvaults.blocks.GatewayChannelingBlock;
import xyz.iwolfking.woldsvaults.blocks.VaultInfuserBlock;
import xyz.iwolfking.woldsvaults.blocks.WeavingStationBlock;
import xyz.iwolfking.woldsvaults.init.ModBlocks;

public class ModBlockStateProvider
extends BlockStateProvider {
    private final ModelFile EMPTY = this.models().getExistingFile(this.modLoc("block/base/nothing"));

    public ModBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "woldsvaults", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.generateChromaticSteelVaultInfuser();
        this.generateChromaticIronVaultInfuser();
        this.generateAugmentTableBlock();
        this.generateGatewayChannelingBlock();
        this.generateMonolithController();
        this.generateWeavingStation();
        this.generateDecoMonolith();
        this.generateDecoObelisk();
        this.generateXLBackpack();
        this.generateGenericItemModelBlockState((Block)ModBlocks.VAULT_CRATE_CORRUPTED);
        this.generateGenericItemModelBlockState((Block)ModBlocks.VAULT_CRATE_ALCHEMY);
        this.generateGenericItemModelBlockState(ModBlocks.DECO_SCAVENGER_ALTAR_BLOCK);
        this.generateGenericItemModelBlockState(ModBlocks.DECO_LODESTONE_BLOCK);
        this.generateGenericItemModelBlockState(ModBlocks.MOD_BOX_WORKSTATION);
        this.generateGenericItemModelBlockState((Block)ModBlocks.OMEGA_VENDOR_PEDESTAL);
        this.generateGenericItemModelBlockState((Block)ModBlocks.RARE_VENDOR_PEDESTAL);
        this.generateGenericItemModelBlockState((Block)ModBlocks.BLACKSMITH_VENDOR_PEDESTAL);
        this.generateGenericItemModelBlockState(ModBlocks.DUNGEON_PEDESTAL_BLOCK);
        this.generateGenericItemModelBlockState((Block)ModBlocks.ETCHING_PEDESTAL);
        this.generateGenericItemModelBlockState((Block)ModBlocks.GOD_VENDOR_PEDESTAL);
        this.generateGenericItemModelBlockState(ModBlocks.BREWING_ALTAR);
        this.horizontalBlock((Block)ModBlocks.GRAVEYARD_LOOT_BLOCK, (ModelFile)new ModelFile.ExistingModelFile(this.modLoc("block/tombstone"), this.models().existingFileHelper));
        this.generateGenericItemModelBlockState((Block)ModBlocks.CARD_VENDOR_PEDESTAL, "god_shop_pedestal");
        this.generateGenericItemModelBlockState((Block)ModBlocks.SPOOKY_VENDOR_PEDESTAL, "etching_shop_pedestal");
        this.generateTwoTallItemModelBlockState(ModBlocks.FRACTURED_OBELISK);
        this.simpleBlockWithItem((Block)ModBlocks.HELLISH_SAND_BLOCK);
        this.simpleBlockWithItem(ModBlocks.INFUSED_DRIFTWOOD_PLANKS);
        this.simpleBlockWithItem((Block)ModBlocks.ISKALLIAN_LEAVES_BLOCK);
        this.simpleBlockWithItem(ModBlocks.NULLITE_ORE);
        this.simpleBlockWithItem(ModBlocks.PRISMATIC_FIBER_BLOCK);
        this.simpleBlockWithItem(ModBlocks.SURVIVAL_MOB_BARRIER);
        this.simpleBlockItem((Block)ModBlocks.GRAVEYARD_LOOT_BLOCK, (ModelFile)new ModelFile.ExistingModelFile(this.modLoc("block/tombstone"), this.models().existingFileHelper));
    }

    private void simpleBlockWithItem(Block block) {
        this.simpleBlock(block);
        this.itemModels().withExistingParent(block.getRegistryName().m_135815_(), this.modLoc("block/" + block.getRegistryName().m_135815_()));
    }

    private void generateGenericItemModelBlockState(Block block) {
        VariantBlockStateBuilder vbb = this.getVariantBuilder(block);
        ModelFile.ExistingModelFile existingModel = this.models().getExistingFile(this.modLoc("block/" + block.getRegistryName().m_135815_()));
        vbb.setModels(vbb.partialState(), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).build());
        this.itemModels().withExistingParent(block.getRegistryName().m_135815_(), this.modLoc("block/" + block.getRegistryName().m_135815_()));
    }

    private void generateGenericItemModelBlockState(Block block, String extra) {
        VariantBlockStateBuilder vbb = this.getVariantBuilder(block);
        ModelFile.ExistingModelFile existingModel = this.models().getExistingFile(this.modLoc("block/" + extra));
        vbb.setModels(vbb.partialState(), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).build());
        this.itemModels().withExistingParent(block.getRegistryName().m_135815_(), this.modLoc("block/" + extra));
    }

    private void generateTwoTallItemModelBlockState(Block block) {
        VariantBlockStateBuilder vbb = this.getVariantBuilder(block);
        ModelFile.ExistingModelFile existingModel = this.models().getExistingFile(this.modLoc("block/" + block.getRegistryName().m_135815_()));
        vbb.setModels(vbb.partialState().with(FracturedObelisk.HALF, (Comparable)DoubleBlockHalf.UPPER), vbb.partialState().modelForState().modelFile(this.EMPTY).build());
        vbb.setModels(vbb.partialState().with(FracturedObelisk.HALF, (Comparable)DoubleBlockHalf.LOWER), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).build());
        this.itemModels().withExistingParent(block.getRegistryName().m_135815_(), this.modLoc("block/" + block.getRegistryName().m_135815_()));
    }

    private void generateDecoObelisk() {
        VariantBlockStateBuilder vbb = this.getVariantBuilder(ModBlocks.DECO_OBELISK_BLOCK);
        ModelFile.ExistingModelFile inactive = this.models().getExistingFile(this.modLoc("block/obelisk_inactive"));
        ModelFile.ExistingModelFile active = this.models().getExistingFile(this.modLoc("block/obelisk_active"));
        vbb.setModels(vbb.partialState().with(DecoObeliskBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), vbb.partialState().modelForState().modelFile(this.EMPTY).build());
        vbb.setModels(vbb.partialState().with(DecoObeliskBlock.HALF, (Comparable)DoubleBlockHalf.LOWER).with((Property)DecoObeliskBlock.FILLED, (Comparable)Boolean.valueOf(false)), vbb.partialState().modelForState().modelFile((ModelFile)inactive).build());
        vbb.setModels(vbb.partialState().with(DecoObeliskBlock.HALF, (Comparable)DoubleBlockHalf.LOWER).with((Property)DecoObeliskBlock.FILLED, (Comparable)Boolean.valueOf(true)), vbb.partialState().modelForState().modelFile((ModelFile)active).build());
        this.itemModels().withExistingParent("obelisk", this.modLoc("block/obelisk_inactive"));
    }

    private void generateChromaticSteelVaultInfuser() {
        VariantBlockStateBuilder vbb = this.getVariantBuilder((Block)ModBlocks.CHROMATIC_STEEL_INFUSER_BLOCK);
        ModelBuilder existingModel = this.models().withExistingParent("chromatic_steel_vault_infuser", "minecraft:block/orientable");
        vbb.setModels(vbb.partialState().with((Property)VaultInfuserBlock.FACING, (Comparable)Direction.NORTH), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).build());
        vbb.setModels(vbb.partialState().with((Property)VaultInfuserBlock.FACING, (Comparable)Direction.EAST), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).rotationY(90).build());
        vbb.setModels(vbb.partialState().with((Property)VaultInfuserBlock.FACING, (Comparable)Direction.SOUTH), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).rotationY(180).build());
        vbb.setModels(vbb.partialState().with((Property)VaultInfuserBlock.FACING, (Comparable)Direction.WEST), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).rotationY(270).build());
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("chromatic_steel_vault_infuser", "minecraft:block/orientable")).texture("top", this.modLoc("block/chromatic_steel_vault_infuser_top"))).texture("front", this.modLoc("block/chromatic_steel_vault_infuser_front_on"))).texture("side", this.modLoc("block/chromatic_steel_vault_infuser_side"));
        this.itemModels().withExistingParent("chromatic_steel_vault_infuser", this.modLoc("block/chromatic_steel_vault_infuser"));
    }

    private void generateChromaticIronVaultInfuser() {
        VariantBlockStateBuilder vbb = this.getVariantBuilder((Block)ModBlocks.VAULT_INFUSER_BLOCK);
        ModelBuilder existingModel = this.models().withExistingParent("vault_infuser", "minecraft:block/orientable");
        vbb.setModels(vbb.partialState().with((Property)VaultInfuserBlock.FACING, (Comparable)Direction.NORTH), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).build());
        vbb.setModels(vbb.partialState().with((Property)VaultInfuserBlock.FACING, (Comparable)Direction.EAST), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).rotationY(90).build());
        vbb.setModels(vbb.partialState().with((Property)VaultInfuserBlock.FACING, (Comparable)Direction.SOUTH), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).rotationY(180).build());
        vbb.setModels(vbb.partialState().with((Property)VaultInfuserBlock.FACING, (Comparable)Direction.WEST), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).rotationY(270).build());
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("vault_infuser", "minecraft:block/orientable")).texture("top", this.modLoc("block/chromatic_iron_vault_infuser_top"))).texture("front", this.modLoc("block/chromatic_iron_vault_infuser_front_on"))).texture("side", this.modLoc("block/chromatic_iron_vault_infuser_side"));
        this.itemModels().withExistingParent("chromatic_iron_vault_infuser", this.modLoc("block/vault_infuser"));
    }

    private void generateAugmentTableBlock() {
        VariantBlockStateBuilder vbb = this.getVariantBuilder(ModBlocks.AUGMENT_CRAFTING_TABLE);
        ModelFile.ExistingModelFile existingModel = this.models().getExistingFile(this.modLoc("block/augment_crafting_table"));
        vbb.setModels(vbb.partialState().with((Property)AugmentCraftingTableBlock.FACING, (Comparable)Direction.NORTH), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).build());
        vbb.setModels(vbb.partialState().with((Property)AugmentCraftingTableBlock.FACING, (Comparable)Direction.EAST), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).rotationY(90).build());
        vbb.setModels(vbb.partialState().with((Property)AugmentCraftingTableBlock.FACING, (Comparable)Direction.SOUTH), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).rotationY(180).build());
        vbb.setModels(vbb.partialState().with((Property)AugmentCraftingTableBlock.FACING, (Comparable)Direction.WEST), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).rotationY(270).build());
        this.itemModels().withExistingParent("augment_crafting_table", this.modLoc("block/augment_crafting_table"));
    }

    private void generateGatewayChannelingBlock() {
        VariantBlockStateBuilder vbb = this.getVariantBuilder(ModBlocks.GATEWAY_CHANNELING_BLOCK);
        ModelFile.ExistingModelFile existingModel = this.models().getExistingFile(this.modLoc("block/gateway_channeling_block"));
        vbb.setModels(vbb.partialState().with((Property)GatewayChannelingBlock.USED, (Comparable)Boolean.valueOf(false)), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).build());
        vbb.setModels(vbb.partialState().with((Property)GatewayChannelingBlock.USED, (Comparable)Boolean.valueOf(true)), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).build());
        this.itemModels().withExistingParent("gateway_channeling_block", this.modLoc("block/gateway_channeling_block"));
    }

    private void generateDecoMonolith() {
        VariantBlockStateBuilder vbb = this.getVariantBuilder(ModBlocks.DECO_MONOLITH_BLOCK);
        ModelFile.ExistingModelFile extinguished = this.models().getExistingFile(this.modLoc("block/monolith_extinguished"));
        ModelFile.ExistingModelFile lit = this.models().getExistingFile(this.modLoc("block/monolith_lit"));
        ModelFile.ExistingModelFile destroyed = this.models().getExistingFile(this.modLoc("block/monolith_destroyed"));
        vbb.setModels(vbb.partialState().with(DecoMonolithBlock.STATE, (Comparable)((Object)DecoMonolithBlock.State.EXTINGUISHED)), vbb.partialState().modelForState().modelFile((ModelFile)extinguished).build());
        vbb.setModels(vbb.partialState().with(DecoMonolithBlock.STATE, (Comparable)((Object)DecoMonolithBlock.State.LIT)), vbb.partialState().modelForState().modelFile((ModelFile)lit).build());
        vbb.setModels(vbb.partialState().with(DecoMonolithBlock.STATE, (Comparable)((Object)DecoMonolithBlock.State.DESTROYED)), vbb.partialState().modelForState().modelFile((ModelFile)destroyed).build());
        this.itemModels().withExistingParent("monolith", this.modLoc("block/monolith_lit"));
    }

    private void generateMonolithController() {
        VariantBlockStateBuilder vbb = this.getVariantBuilder(ModBlocks.MONOLITH_CONTROLLER);
        BlockModelBuilder b = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("monolith_controller", this.modLoc("block/base/nothing"))).texture("particle", this.modLoc("block/monolith_controller"));
        vbb.setModels(vbb.partialState(), vbb.partialState().modelForState().modelFile((ModelFile)b).build());
    }

    private void generateWeavingStation() {
        VariantBlockStateBuilder vbb = this.getVariantBuilder(ModBlocks.WEAVING_STATION);
        ModelFile.ExistingModelFile existingModel = this.models().getExistingFile(this.modLoc("block/weaving_station"));
        vbb.setModels(vbb.partialState().with((Property)WeavingStationBlock.FACING, (Comparable)Direction.NORTH), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).build());
        vbb.setModels(vbb.partialState().with((Property)WeavingStationBlock.FACING, (Comparable)Direction.EAST), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).rotationY(90).build());
        vbb.setModels(vbb.partialState().with((Property)WeavingStationBlock.FACING, (Comparable)Direction.SOUTH), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).rotationY(180).build());
        vbb.setModels(vbb.partialState().with((Property)WeavingStationBlock.FACING, (Comparable)Direction.WEST), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).rotationY(270).build());
        this.itemModels().withExistingParent("weaving_station", this.modLoc("block/weaving_station"));
    }

    private void generateXLBackpack() {
        VariantBlockStateBuilder vbb = this.getVariantBuilder((Block)ModBlocks.XL_BACKPACK);
        ModelFile.ExistingModelFile existingModel = this.models().getExistingFile(this.modLoc("block/xl_backpack"));
        vbb.setModels(vbb.partialState().with((Property)BackpackBlock.FACING, (Comparable)Direction.NORTH), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).build());
        vbb.setModels(vbb.partialState().with((Property)BackpackBlock.FACING, (Comparable)Direction.EAST), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).rotationY(90).build());
        vbb.setModels(vbb.partialState().with((Property)BackpackBlock.FACING, (Comparable)Direction.SOUTH), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).rotationY(180).build());
        vbb.setModels(vbb.partialState().with((Property)BackpackBlock.FACING, (Comparable)Direction.WEST), vbb.partialState().modelForState().modelFile((ModelFile)existingModel).rotationY(270).build());
        this.itemModels().withExistingParent("xl_backpack", this.modLoc("block/xl_backpack"));
    }
}

