/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.events;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import cofh.core.init.CoreMobEffects;
import iskallia.vault.block.CoinPileBlock;
import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.block.VaultOreBlock;
import iskallia.vault.block.entity.VaultChestTileEntity;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.entity.VaultBoss;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.champion.ChampionLogic;
import iskallia.vault.entity.entity.elite.EliteDrownedEntity;
import iskallia.vault.entity.entity.elite.EliteEndermanEntity;
import iskallia.vault.entity.entity.elite.EliteHuskEntity;
import iskallia.vault.entity.entity.elite.EliteSpiderEntity;
import iskallia.vault.entity.entity.elite.EliteStrayEntity;
import iskallia.vault.entity.entity.elite.EliteWitchEntity;
import iskallia.vault.entity.entity.elite.EliteWitherSkeleton;
import iskallia.vault.entity.entity.elite.EliteZombieEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.event.PlayerActiveFlags;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.trinket.TrinketHelper;
import iskallia.vault.gear.trinket.effects.MultiJumpTrinket;
import iskallia.vault.init.ModEffects;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.calc.EffectDurationHelper;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.util.calc.ThornsHelper;
import iskallia.vault.world.data.ServerVaults;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import xyz.iwolfking.woldsvaults.WoldsVaults;
import xyz.iwolfking.woldsvaults.api.util.WoldAttributeHelper;
import xyz.iwolfking.woldsvaults.api.util.WoldEventHelper;
import xyz.iwolfking.woldsvaults.config.forge.WoldsVaultsConfig;
import xyz.iwolfking.woldsvaults.data.HexEffects;
import xyz.iwolfking.woldsvaults.data.discovery.DiscoveredRecipesData;
import xyz.iwolfking.woldsvaults.effect.mobeffects.EchoingPotionEffect;
import xyz.iwolfking.woldsvaults.events.WoldActiveFlags;
import xyz.iwolfking.woldsvaults.init.ModGearAttributes;
import xyz.iwolfking.woldsvaults.items.TrinketPouchItem;
import xyz.iwolfking.woldsvaults.items.gear.VaultLootSackItem;
import xyz.iwolfking.woldsvaults.items.gear.VaultPlushieItem;
import xyz.iwolfking.woldsvaults.items.gear.VaultTridentItem;
import xyz.iwolfking.woldsvaults.objectives.data.bosses.WoldBoss;

@Mod.EventBusSubscriber(modid="woldsvaults")
public class LivingEntityEvents {
    private static final Random random = new Random();
    private static SoundEvent ANCHOR_SLAM_SOUND = null;

    public static void init() {
        ANCHOR_SLAM_SOUND = (SoundEvent)Registry.f_122821_.m_7745_(new ResourceLocation("bettercombat:anchor_slam"));
    }

    @SubscribeEvent
    public static void dodge(LivingHurtEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!(entity instanceof Player)) {
            return;
        }
        DamageSource source = event.getSource();
        if (!(source instanceof EntityDamageSource) || source.m_19372_() || source.m_19378_()) {
            return;
        }
        float dodgeChance = ((Float)AttributeSnapshotHelper.getInstance().getSnapshot(entity).getAttributeValue(ModGearAttributes.DODGE_PERCENT, VaultGearAttributeTypeMerger.floatSum())).floatValue();
        boolean dodge = entity.m_21187_().nextDouble() < (double)dodgeChance;
        event.setCanceled(dodge);
    }

    @SubscribeEvent
    public static void unlockLightTrinketPouch(LivingDeathEvent event) {
        Level level;
        Vault vault;
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (event.getEntityLiving() instanceof WoldBoss && (vault = (Vault)ServerVaults.get((Level)attacker.f_19853_).orElse(null)) != null && (Integer)((VaultLevel)vault.get(Vault.LEVEL)).get(VaultLevel.VALUE) >= 100 && (level = attacker.m_183503_()) instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            if (DiscoveredRecipesData.get(sLevel).hasDiscovered(attacker, WoldsVaults.id("light_trinket_pouch"))) {
                return;
            }
            DiscoveredRecipesData.get(sLevel).discoverRecipeAndBroadcast(WoldsVaults.id("light_trinket_pouch"), attacker);
        }
    }

    @SubscribeEvent
    public static void unlockSlayerPouch(LivingDeathEvent event) {
        Level level;
        Vault vault;
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (event.getEntityLiving() instanceof VaultBossEntity && (vault = (Vault)ServerVaults.get((Level)attacker.f_19853_).orElse(null)) != null && (Integer)((VaultLevel)vault.get(Vault.LEVEL)).get(VaultLevel.VALUE) >= 100 && (level = attacker.m_183503_()) instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            if (DiscoveredRecipesData.get(sLevel).hasDiscovered(attacker, WoldsVaults.id("slayer_trinket_pouch"))) {
                return;
            }
            DiscoveredRecipesData.get(sLevel).discoverRecipeAndBroadcast(WoldsVaults.id("slayer_trinket_pouch"), attacker);
        }
    }

    @SubscribeEvent
    public static void soulLeech(LivingDeathEvent event) {
        if (event.getSource().m_19360_()) {
            return;
        }
        if (!WoldEventHelper.isNormalAttack()) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        int soulLeechValue = (Integer)AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)attacker).getAttributeValue(ModGearAttributes.SOUL_LEECH_FLAT, VaultGearAttributeTypeMerger.intSum());
        attacker.m_5634_((float)soulLeechValue);
    }

    @SubscribeEvent
    public static void curioChange(CurioChangeEvent event) {
        ItemStack fromStack = event.getFrom();
        if (!(fromStack.m_41720_() instanceof TrinketPouchItem)) {
            return;
        }
        if (event.getFrom().m_41720_().equals(event.getTo().m_41720_()) && !event.getTo().m_41784_().m_128441_("StoredCurios")) {
            return;
        }
        if (event.getFrom().m_41720_() instanceof TrinketPouchItem && !event.getTo().m_150930_(Items.f_41852_)) {
            return;
        }
        if (event.getEntityLiving().f_19853_.f_46443_) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        ListTag storedList = new ListTag();
        CuriosApi.getCuriosHelper().getCuriosHandler(entity).ifPresent(handler -> {
            for (String slotId : TrinketPouchItem.getSlotTypes(event.getFrom())) {
                handler.getStacksHandler(slotId).ifPresent(slotHandler -> {
                    IDynamicStackHandler slots = slotHandler.getStacks();
                    for (int i = 0; i < slots.getSlots(); ++i) {
                        ItemStack trinket = slots.getStackInSlot(i);
                        if (trinket.m_41619_()) continue;
                        CompoundTag tag = new CompoundTag();
                        tag.m_128359_("Slot", slotId);
                        tag.m_128405_("Index", i);
                        trinket.m_41739_(tag);
                        storedList.add((Object)tag);
                        if (trinket.m_41720_() instanceof TrinketItem) {
                            TrinketItem.getTrinket((ItemStack)trinket).ifPresent(trinketEffect -> trinketEffect.onUnEquip(entity, trinket));
                        }
                        slots.setStackInSlot(i, ItemStack.f_41583_);
                    }
                });
            }
            if (!storedList.isEmpty()) {
                ItemStack updatedStack = fromStack.m_41777_();
                updatedStack.m_41784_().m_128365_("StoredCurios", (Tag)storedList);
                Player player = (Player)entity;
                ItemStack carried = player.f_36096_.m_142621_();
                if (ItemStack.m_150942_((ItemStack)carried, (ItemStack)fromStack)) {
                    player.f_36096_.m_142503_(updatedStack);
                } else {
                    for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                        ItemStack invStack = player.m_150109_().m_8020_(i);
                        if (!ItemStack.m_150942_((ItemStack)invStack, (ItemStack)fromStack)) continue;
                        player.m_150109_().m_6836_(i, updatedStack);
                        break;
                    }
                    if (!player.m_36356_(updatedStack)) {
                        entity.m_19983_(updatedStack);
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public static void capLightningDamageInVaults(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSource().equals(DamageSource.f_19306_)) {
                ServerVaults.get((Level)player.f_19853_).ifPresent(vault -> {
                    event.setAmount(Math.min(event.getAmount(), player.m_21233_() * 0.1f));
                    player.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.SHOCKED.get(), 80, 0));
                });
            }
        }
    }

    @SubscribeEvent
    public static void reavingDamage(LivingHurtEvent event) {
        if (event.getEntityLiving().m_21023_(xyz.iwolfking.woldsvaults.init.ModEffects.REAVING) || !WoldEventHelper.isNormalAttack()) {
            return;
        }
        if (event.getSource().m_19360_()) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float reavingDamage = ((Float)AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player).getAttributeValue(ModGearAttributes.REAVING_DAMAGE, VaultGearAttributeTypeMerger.floatSum())).floatValue();
            if (reavingDamage != 0.0f) {
                if (((Boolean)WoldsVaultsConfig.COMMON.enableDebugMode.get()).booleanValue()) {
                    WoldsVaults.LOGGER.debug("[WOLD'S VAULTS] Added " + event.getEntityLiving().m_21233_() * reavingDamage + " bonus reaving damage to attack.");
                }
                event.getEntityLiving().m_7292_(new MobEffectInstance(xyz.iwolfking.woldsvaults.init.ModEffects.REAVING, Integer.MAX_VALUE, 0));
                event.getEntityLiving().m_7292_(new MobEffectInstance(ModEffects.NO_AI, 20, 0));
                if (ChampionLogic.isChampion((LivingEntity)event.getEntityLiving()) || InfernalMobsCore.getMobModifiers((LivingEntity)event.getEntityLiving()) != null || event.getEntityLiving() instanceof VaultBoss || event.getEntityLiving() instanceof VaultBossEntity || event.getEntityLiving() instanceof EliteDrownedEntity || event.getEntityLiving() instanceof EliteWitherSkeleton || event.getEntityLiving() instanceof EliteEndermanEntity || event.getEntityLiving() instanceof EliteHuskEntity || event.getEntityLiving() instanceof EliteSpiderEntity || event.getEntityLiving() instanceof EliteStrayEntity || event.getEntityLiving() instanceof EliteZombieEntity || event.getEntityLiving() instanceof EliteWitchEntity) {
                    event.setAmount(event.getAmount() + event.getEntityLiving().m_21233_() * reavingDamage * 0.5f);
                } else {
                    event.setAmount(event.getAmount() + event.getEntityLiving().m_21233_() * reavingDamage);
                }
                if (ANCHOR_SLAM_SOUND == null) {
                    WoldsVaults.LOGGER.debug("Anchor Slam Sound was null, Better Combat mod is missing.");
                    return;
                }
                player.m_183503_().m_6269_(null, event.getEntity(), ANCHOR_SLAM_SOUND, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void executionDamage(LivingHurtEvent event) {
        if (!WoldEventHelper.isNormalAttack()) {
            return;
        }
        if (event.getSource().m_19360_()) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float executionDamage = ((Float)AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player).getAttributeValue(ModGearAttributes.EXECUTION_DAMAGE, VaultGearAttributeTypeMerger.floatSum())).floatValue();
            if (executionDamage != 0.0f) {
                if (((Boolean)WoldsVaultsConfig.COMMON.enableDebugMode.get()).booleanValue()) {
                    WoldsVaults.LOGGER.debug("[WOLD'S VAULTS] Added " + (event.getEntityLiving().m_21233_() - event.getEntityLiving().m_21223_()) * executionDamage + " bonus execution damage to attack.");
                }
                event.setAmount(event.getAmount() + (event.getEntityLiving().m_21233_() - event.getEntityLiving().m_21223_()) * executionDamage);
            }
        }
    }

    @SubscribeEvent
    public static void thornsScalingDamage(LivingHurtEvent event) {
        VaultGearData data;
        Player player;
        if (!WoldEventHelper.isNormalAttack()) {
            return;
        }
        if (event.getSource().m_19360_()) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_21205_().m_41720_() instanceof VaultGearItem && (data = VaultGearData.read((ItemStack)player.m_21205_().m_41777_())) != null) {
            float thornsScalingPercent = ((Float)AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player).getAttributeValue(ModGearAttributes.THORNS_SCALING_DAMAGE, VaultGearAttributeTypeMerger.floatSum())).floatValue();
            if (thornsScalingPercent <= 0.0f) {
                return;
            }
            float thornsDamage = ThornsHelper.getAdditionalThornsFlatDamage((LivingEntity)player);
            event.setAmount(event.getAmount() + thornsDamage * thornsScalingPercent);
        }
    }

    @SubscribeEvent
    public static void apScalingDamage(LivingHurtEvent event) {
        VaultGearData data;
        Player player;
        if (!WoldEventHelper.isNormalAttack()) {
            return;
        }
        if (event.getSource().m_19360_()) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_21205_().m_41720_() instanceof VaultGearItem && (data = VaultGearData.read((ItemStack)player.m_21205_().m_41777_())) != null) {
            float apScalingPercent = ((Float)AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player).getAttributeValue(ModGearAttributes.AP_SCALING_DAMAGE, VaultGearAttributeTypeMerger.floatSum())).floatValue();
            if (apScalingPercent <= 0.0f) {
                return;
            }
            float abilityPower = WoldAttributeHelper.getAdditionalAbilityPower((LivingEntity)player);
            event.setAmount(event.getAmount() + abilityPower * apScalingPercent);
        }
    }

    @SubscribeEvent
    public static void hexingHit(LivingHurtEvent event) {
        if (!WoldEventHelper.isNormalAttack()) {
            return;
        }
        if (event.getSource().m_19360_()) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float hexingChance = ((Float)AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player).getAttributeValue(ModGearAttributes.HEXING_CHANCE, VaultGearAttributeTypeMerger.floatSum())).floatValue();
            if (hexingChance != 0.0f && player.f_19853_.f_46441_.nextFloat() <= hexingChance) {
                MobEffectInstance instance = (MobEffectInstance)HexEffects.HEX_EFFECTS.getRandom(player.m_21187_());
                if (instance == null) {
                    return;
                }
                event.getEntityLiving().m_7292_(new MobEffectInstance(instance));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void echoingHit(LivingHurtEvent event) {
        if (event.getSource().m_19360_()) {
            return;
        }
        if (WoldActiveFlags.IS_ECHOING_ATTACKING.isSet() && (ActiveFlags.IS_AOE_ATTACKING.isSet() || ActiveFlags.IS_CHAINING_ATTACKING.isSet())) {
            return;
        }
        if (ActiveFlags.IS_DOT_ATTACKING.isSet() || ActiveFlags.IS_LEECHING.isSet() || ActiveFlags.IS_REFLECT_ATTACKING.isSet() || ActiveFlags.IS_CHARMED_ATTACKING.isSet() || ActiveFlags.IS_EFFECT_ATTACKING.isSet() || ActiveFlags.IS_SMITE_ATTACKING.isSet()) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float echoingChance = ((Float)AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player).getAttributeValue(ModGearAttributes.ECHOING_CHANCE, VaultGearAttributeTypeMerger.floatSum())).floatValue();
            float echoingDamage = ((Float)AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player).getAttributeValue(ModGearAttributes.ECHOING_DAMAGE, VaultGearAttributeTypeMerger.floatSum())).floatValue();
            if (echoingChance != 0.0f) {
                if (WoldActiveFlags.IS_ECHOING_ATTACKING.isSet()) {
                    echoingChance = (float)Math.sqrt(echoingChance);
                }
                if (player.f_19853_.f_46441_.nextFloat() <= echoingChance) {
                    EchoingPotionEffect newEffect = (EchoingPotionEffect)xyz.iwolfking.woldsvaults.init.ModEffects.ECHOING;
                    if (WoldActiveFlags.IS_ECHOING_ATTACKING.isSet() && event.getEntityLiving().m_21023_(xyz.iwolfking.woldsvaults.init.ModEffects.ECHOING)) {
                        newEffect = (EchoingPotionEffect)event.getEntityLiving().m_21124_(xyz.iwolfking.woldsvaults.init.ModEffects.ECHOING).m_19544_();
                    } else {
                        newEffect.setDamage(event.getAmount());
                        newEffect.setAttacker(player);
                        newEffect.setSource(event.getSource());
                    }
                    float damage = newEffect.getDamage() * 0.667f;
                    if (echoingDamage != 0.0f) {
                        damage *= 1.0f + echoingDamage;
                    }
                    if (damage > 1.0f) {
                        newEffect.setDamage(damage);
                        int duration = EffectDurationHelper.adjustEffectDurationFloor((LivingEntity)player, (float)1.0f) * 10;
                        event.getEntityLiving().m_7292_(new MobEffectInstance((MobEffect)newEffect, duration, 0));
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onDamageTotem(LivingHurtEvent event) {
        LivingEntity livingEntity;
        Level world = event.getEntity().m_20193_();
        if (!world.m_5776_() && world instanceof ServerLevel && (livingEntity = event.getEntityLiving()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!event.getSource().m_19376_()) {
                ItemStack offHand = event.getEntityLiving().m_21206_();
                if (!(ServerVaults.get((Level)world).isEmpty() && offHand.m_41720_() instanceof VaultGearItem || !(offHand.m_41720_() instanceof VaultPlushieItem))) {
                    int damage = (int)CommonEvents.PLAYER_STAT.invoke(PlayerStat.DURABILITY_DAMAGE, (LivingEntity)player, Math.max(1.0f, event.getAmount() / 6.0f)).getValue();
                    if (damage <= 1) {
                        damage = 1;
                    }
                    offHand.m_41622_(damage, event.getEntityLiving(), entity -> entity.m_21166_(EquipmentSlot.OFFHAND));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBreakVaultBlock(BlockEvent.BreakEvent event) {
        Level world = event.getPlayer().m_20193_();
        if (!world.m_5776_() && world instanceof ServerLevel && (event.getState().m_60734_() instanceof VaultChestBlock || event.getState().m_60734_() instanceof CoinPileBlock || event.getState().m_60734_() instanceof VaultOreBlock)) {
            ItemStack offHand = event.getPlayer().m_21206_();
            if ((ServerVaults.get((Level)world).isPresent() || !(offHand.m_41720_() instanceof VaultGearItem)) && offHand.m_41720_() instanceof VaultLootSackItem) {
                int damage;
                Block block = event.getState().m_60734_();
                if (block instanceof VaultChestBlock) {
                    VaultChestTileEntity chest;
                    VaultChestBlock chestBlock = (VaultChestBlock)block;
                    block = world.m_7702_(event.getPos());
                    if (block instanceof VaultChestTileEntity && chestBlock.hasStepBreaking(chest = (VaultChestTileEntity)block) && random.nextFloat() < 0.75f) {
                        return;
                    }
                }
                if ((damage = (int)CommonEvents.PLAYER_STAT.invoke(PlayerStat.DURABILITY_DAMAGE, (LivingEntity)event.getPlayer(), 1.0f).getValue()) <= 1) {
                    damage = 1;
                }
                offHand.m_41622_(damage, (LivingEntity)event.getPlayer(), entity -> entity.m_21166_(EquipmentSlot.OFFHAND));
            }
        }
    }

    @SubscribeEvent
    public static void multiJumpTrinketFallReductionEvent(LivingFallEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof ServerPlayer && TrinketHelper.getTrinkets((LivingEntity)(player = (ServerPlayer)livingEntity), MultiJumpTrinket.class).stream().anyMatch(trinket -> trinket.isUsable((Player)player))) {
            if (event.getDistance() < 5.0f) {
                event.setCanceled(true);
            } else {
                event.setDistance(event.getDistance() - 2.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof VaultTridentItem && player.m_21209_() && VaultTridentItem.isVaultTridentRiptide(stack)) {
            VaultGearData data = VaultGearData.read((ItemStack)stack);
            Double f = (Double)data.get(iskallia.vault.init.ModGearAttributes.ATTACK_DAMAGE, VaultGearAttributeTypeMerger.doubleSum());
            AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player);
            event.setAmount((float)VaultTridentItem.getTridentScaledDamage(snapshot, event.getEntityLiving(), f * 2.0));
            if (!PlayerActiveFlags.isSet((Player)player, (PlayerActiveFlags.Flag)PlayerActiveFlags.Flag.ATTACK_AOE)) {
                VaultTridentItem.triggerChannelingRiptide(stack, player.m_183503_(), player);
            }
        }
    }

    private static void withSnapshot(LivingEvent event, boolean serverOnly, BiConsumer<LivingEntity, AttributeSnapshot> fn) {
        LivingEntityEvents.withSnapshot(event.getEntityLiving(), serverOnly, fn);
    }

    private static void withSnapshot(LivingEntity entity, boolean serverOnly, BiConsumer<LivingEntity, AttributeSnapshot> fn) {
        if (!(!AttributeSnapshotHelper.canHaveSnapshot((LivingEntity)entity) || serverOnly && entity.m_20193_().m_5776_())) {
            fn.accept(entity, AttributeSnapshotHelper.getInstance().getSnapshot(entity));
        }
    }
}

