/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.events;

import iskallia.vault.block.SkillAltarBlock;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.item.KnowledgeBrewItem;
import iskallia.vault.item.MentorsBrewItem;
import iskallia.vault.item.VaultDollItem;
import iskallia.vault.util.SideOnlyFixer;
import iskallia.vault.world.data.ServerVaults;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.iwolfking.woldsvaults.api.util.GameruleHelper;
import xyz.iwolfking.woldsvaults.blocks.DollDismantlingBlock;
import xyz.iwolfking.woldsvaults.items.FilterNecklaceItem;

@Mod.EventBusSubscriber(modid="woldsvaults")
public class PlayerEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onFilterNecklaceUse(EntityItemPickupEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ItemStack filterNecklaceStack;
            Item item;
            ServerPlayer player2 = (ServerPlayer)player;
            ItemEntity itemEntity = event.getItem();
            ItemStack stack = itemEntity.m_32055_();
            if (!stack.m_41619_() && (item = (filterNecklaceStack = FilterNecklaceItem.getNecklace((Player)player2)).m_41720_()) instanceof FilterNecklaceItem) {
                FilterNecklaceItem filterNecklaceItem = (FilterNecklaceItem)item;
                ServerLevel world = player2.m_183503_();
                if (ServerVaults.get((Level)world).isPresent() && filterNecklaceItem.stackMatchesFilter(stack, filterNecklaceStack)) {
                    event.setCanceled(true);
                    itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                    world.m_5594_(null, player2.m_142538_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 1.4f + 2.0f);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.getCrafting().m_41720_() instanceof VaultDollItem && !GameruleHelper.isEnabled(xyz.iwolfking.woldsvaults.init.ModGameRules.ENABLE_VAULT_DOLLS, event.getPlayer().m_183503_())) {
            PlayerEvents.cancelCraft(event, event.getCrafting());
        } else if (event.getCrafting().m_41720_() instanceof KnowledgeBrewItem && !GameruleHelper.isEnabled((GameRules.Key<GameRules.BooleanValue>)ModGameRules.ALLOW_KNOWLEDGE_BREW, event.getPlayer().m_183503_())) {
            PlayerEvents.cancelCraft(event, event.getCrafting());
        } else if (event.getCrafting().m_41720_() instanceof MentorsBrewItem && !GameruleHelper.isEnabled((GameRules.Key<GameRules.BooleanValue>)ModGameRules.ALLOW_MENTOR_BREW, event.getPlayer().m_183503_())) {
            PlayerEvents.cancelCraft(event, event.getCrafting());
        } else {
            BlockItem blockItem;
            Item item = event.getCrafting().m_41720_();
            if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof DollDismantlingBlock && !GameruleHelper.isEnabled(xyz.iwolfking.woldsvaults.init.ModGameRules.ENABLE_VAULT_DOLLS, event.getPlayer().m_183503_())) {
                PlayerEvents.cancelCraft(event, event.getCrafting());
            } else {
                BlockItem blockItem2;
                item = event.getCrafting().m_41720_();
                if (item instanceof BlockItem && (blockItem2 = (BlockItem)item).m_40614_() instanceof SkillAltarBlock && !GameruleHelper.isEnabled(xyz.iwolfking.woldsvaults.init.ModGameRules.ENABLE_SKILL_ALTARS, event.getPlayer().m_183503_())) {
                    PlayerEvents.cancelCraft(event, event.getCrafting());
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemTooltip(ItemTooltipEvent event) {
        Player player = event.getPlayer();
        if (player != null) {
            if (event.getItemStack().m_41720_() instanceof VaultDollItem && !GameruleHelper.isEnabled(xyz.iwolfking.woldsvaults.init.ModGameRules.ENABLE_VAULT_DOLLS, event.getPlayer().m_183503_())) {
                event.getToolTip().add(new TextComponent("Vault Dolls are disabled in this world!").m_130940_(ChatFormatting.RED));
            } else if (event.getItemStack().m_41720_() instanceof KnowledgeBrewItem && !GameruleHelper.isEnabled((GameRules.Key<GameRules.BooleanValue>)ModGameRules.ALLOW_KNOWLEDGE_BREW, event.getPlayer().m_183503_())) {
                event.getToolTip().add(new TextComponent("Knowledge Brews are disabled in this world!").m_130940_(ChatFormatting.RED));
            } else if (event.getItemStack().m_41720_() instanceof MentorsBrewItem && !GameruleHelper.isEnabled((GameRules.Key<GameRules.BooleanValue>)ModGameRules.ALLOW_MENTOR_BREW, event.getPlayer().m_183503_())) {
                event.getToolTip().add(new TextComponent("Mentor Brews are disabled in this world!").m_130940_(ChatFormatting.RED));
            } else {
                BlockItem blockItem;
                Item item = event.getItemStack().m_41720_();
                if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof DollDismantlingBlock && !GameruleHelper.isEnabled(xyz.iwolfking.woldsvaults.init.ModGameRules.ENABLE_VAULT_DOLLS, event.getPlayer().m_183503_())) {
                    event.getToolTip().add(new TextComponent("Vault Dolls are disabled in this world!").m_130940_(ChatFormatting.RED));
                } else {
                    BlockItem blockItem2;
                    item = event.getItemStack().m_41720_();
                    if (item instanceof BlockItem && (blockItem2 = (BlockItem)item).m_40614_() instanceof SkillAltarBlock && !GameruleHelper.isEnabled(xyz.iwolfking.woldsvaults.init.ModGameRules.ENABLE_SKILL_ALTARS, event.getPlayer().m_183503_())) {
                        event.getToolTip().add(new TextComponent("Skill Altars are disabled in this world!").m_130940_(ChatFormatting.RED));
                    }
                }
            }
        }
    }

    private static void sendDisabledMessage(ItemStack item) {
        MutableComponent name = (MutableComponent)item.m_41611_();
        Style style = Style.f_131099_.m_131148_(TextColor.m_131266_((int)-203978));
        name.m_6270_(style);
        MutableComponent text = name.m_7220_((Component)new TextComponent(" cannot be crafted in this world!"));
        Minecraft.m_91087_().f_91065_.m_93063_((Component)text, false);
    }

    private static void cancelCraft(PlayerEvent.ItemCraftedEvent event, ItemStack craftedItemStack) {
        Player player = event.getPlayer();
        Container craftingMatrix = event.getInventory();
        if (event.getPlayer().f_19853_.f_46443_) {
            PlayerEvents.sendDisabledMessage(craftedItemStack);
        }
        for (int i = 0; i < craftingMatrix.m_6643_(); ++i) {
            ItemStack itemStack = craftingMatrix.m_8020_(i);
            if (itemStack == ItemStack.f_41583_) continue;
            ItemStack itemStackToDrop = itemStack.m_41777_();
            itemStackToDrop.m_41764_(1);
            player.m_7197_(itemStackToDrop, false, false);
        }
        int slot = SideOnlyFixer.getSlotFor((Inventory)player.m_150109_(), (ItemStack)craftedItemStack);
        if (slot != -1) {
            ItemStack stackInSlot = player.m_150109_().m_8020_(slot);
            if (stackInSlot.m_41613_() < craftedItemStack.m_41613_()) {
                craftedItemStack.m_41764_(stackInSlot.m_41613_());
            }
            stackInSlot.m_41774_(craftedItemStack.m_41613_());
        } else {
            craftedItemStack.m_41774_(craftedItemStack.m_41613_());
        }
    }
}

