/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.events;

import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.world.data.ServerVaults;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.iwolfking.woldsvaults.data.FlightCancellationStrings;
import xyz.iwolfking.woldsvaults.events.WoldActiveFlags;
import xyz.iwolfking.woldsvaults.init.ModEffects;
import xyz.iwolfking.woldsvaults.init.ModGameRules;
import xyz.iwolfking.woldsvaults.init.ModNetwork;
import xyz.iwolfking.woldsvaults.lib.network.packets.StopFlightMessage;

@Mod.EventBusSubscriber(modid="woldsvaults")
public class TickEvents {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.f_19797_ % 20 != 0) {
            return;
        }
        if (event.side.isClient()) {
            WoldActiveFlags.IS_USING_SAFER_SPACE.trySet(event.player.m_21023_(ModEffects.SAFER_SPACE));
        }
        if (event.player.m_183503_().m_46469_().m_46207_(ModGameRules.ALLOW_FLIGHT_IN_VAULTS)) {
            return;
        }
        if (event.player.m_7500_() || event.player.m_5833_()) {
            return;
        }
        if (event.side.isClient() && ClientVaults.getActive().isPresent() && (event.player.m_150110_().f_35935_ || event.player.m_150110_().f_35936_)) {
            TickEvents.stopFlying(event.player);
        }
        if (event.side.isServer() && ServerVaults.get((Level)event.player.m_183503_()).isPresent() && (event.player.m_150110_().f_35935_ || event.player.m_150110_().f_35936_)) {
            TickEvents.stopFlying(event.player);
        }
    }

    public static void stopFlying(Player player) {
        player.m_150110_().f_35936_ = false;
        player.m_150110_().f_35935_ = false;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModNetwork.sendToClient(new StopFlightMessage(serverPlayer.m_142081_()), serverPlayer);
        }
        TickEvents.sendFlightNotice(player);
    }

    public static void punish(Player player) {
        Random random = new Random();
        if (random.nextBoolean()) {
            int r = random.nextInt(0, 101);
            if (r >= 90) {
                player.m_5661_((Component)new TextComponent("You have been shrunk for trying to fly in the vault!"), true);
                player.m_7292_(new MobEffectInstance(ModEffects.SHRINKING, 500, 2));
            } else if (r >= 75) {
                player.m_5661_((Component)new TextComponent("You have been mining fatigue from trying to fly in the vault!"), true);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 500, 3));
            } else if (r >= 60) {
                player.m_5661_((Component)new TextComponent("You have been slowed from trying to fly in the vault!"), true);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 500, 3));
            } else if (r >= 40) {
                player.m_5661_((Component)new TextComponent("You have been withered from trying to fly in the vault!"), true);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 500, 1));
            } else if (r >= 26) {
                player.m_5661_((Component)new TextComponent("You have been blinded from trying to fly in the vault!"), true);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 500, 1));
            } else if (r >= 10) {
                player.m_5661_((Component)new TextComponent("You have been cursed from trying to fly in the vault!"), true);
                player.m_7292_(new MobEffectInstance(AMEffectRegistry.SUNBIRD_CURSE, 700, 1));
            } else if (r >= 0) {
                player.m_5661_((Component)new TextComponent("You have been weakened from trying to fly in the vault!"), true);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 600, 4));
            }
        }
    }

    public static void sendFlightNotice(Player player) {
        if (!player.f_19853_.f_46443_) {
            player.m_5661_(FlightCancellationStrings.getMessage(), false);
        }
    }
}

