/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.events;

import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import iskallia.vault.VaultMod;
import iskallia.vault.core.data.key.ThemeKey;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.StatsCollector;
import iskallia.vault.event.event.BountyCompleteEvent;
import iskallia.vault.event.event.VaultJoinEvent;
import iskallia.vault.event.event.VaultLeaveEvent;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.spongepowered.asm.mixin.Unique;
import virtuoel.pehkui.api.ScaleTypes;
import xyz.iwolfking.woldsvaults.WoldsVaults;
import xyz.iwolfking.woldsvaults.data.discovery.DiscoveredRecipesData;
import xyz.iwolfking.woldsvaults.data.discovery.DiscoveredThemesData;
import xyz.iwolfking.woldsvaults.integration.ftbquests.tasks.CompleteBountyTask;
import xyz.iwolfking.woldsvaults.integration.ftbquests.tasks.EnterVaultTask;
import xyz.iwolfking.woldsvaults.objectives.CorruptedObjective;

@Mod.EventBusSubscriber(modid="woldsvaults")
public class VaultEvents {
    private static List<CompleteBountyTask> completeBountyTasks = null;
    private static List<EnterVaultTask> enterVaultTasks = null;

    @SubscribeEvent
    public static void onVaultJoin(VaultJoinEvent event) {
        ResourceLocation theme = (ResourceLocation)((WorldManager)event.getVault().get(Vault.WORLD)).get(WorldManager.THEME);
        ThemeKey themeKey = (ThemeKey)VaultRegistry.THEME.getKey(theme);
        if (!event.getPlayers().isEmpty()) {
            for (ServerPlayer joinedPlayer : event.getPlayers()) {
                ScaleTypes.BASE.getScaleData((Entity)joinedPlayer).setScale(1.0f);
                if (!DiscoveredThemesData.get(joinedPlayer.f_8924_).hasDiscovered((Player)joinedPlayer, theme) && themeKey != null) {
                    DiscoveredThemesData.get(joinedPlayer.f_8924_).discoverThemeAndBroadcast(themeKey, (Player)joinedPlayer);
                }
                VaultEvents.progressVaultEnterTasks((Player)joinedPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onVaultComplete(VaultLeaveEvent event) {
        if (event.getPlayer() != null && event.getVault() != null) {
            StatsCollector statsCollector;
            StatCollector statCollector;
            Vault vault = event.getVault();
            ServerPlayer player = event.getPlayer();
            if (VaultUtils.hasObjective((Vault)vault, CorruptedObjective.class) && vault.has(Vault.STATS) && (statCollector = (statsCollector = (StatsCollector)vault.get(Vault.STATS)).get(player.m_142081_())).getCompletion().equals((Object)Completion.COMPLETED) && !DiscoveredRecipesData.get(player.m_183503_()).hasDiscovered((Player)player, WoldsVaults.id("shattering_jewel"))) {
                DiscoveredRecipesData.get(player.m_183503_()).discoverRecipeAndBroadcast(WoldsVaults.id("shattering_jewel"), (Player)player);
            }
        }
    }

    @SubscribeEvent
    public static void onBountyComplete(BountyCompleteEvent event) {
        Player player = event.getPlayer();
        if (completeBountyTasks == null) {
            completeBountyTasks = ServerQuestFile.INSTANCE.collect(CompleteBountyTask.class);
        }
        if (completeBountyTasks.isEmpty()) {
            return;
        }
        TeamData data = ServerQuestFile.INSTANCE.getData((Entity)player);
        for (CompleteBountyTask task : completeBountyTasks) {
            if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.quest)) continue;
            if (task.getTaskType().equals((Object)VaultMod.id((String)"any")) || task.getTaskType() == null) {
                data.setProgress((Task)task, 1L);
                continue;
            }
            if (!task.getTaskType().equals((Object)event.getTask().getTaskType())) continue;
            data.setProgress((Task)task, 1L);
        }
    }

    @Unique
    public static void progressVaultEnterTasks(Player player) {
        if (enterVaultTasks == null) {
            enterVaultTasks = ServerQuestFile.INSTANCE.collect(EnterVaultTask.class);
        }
        if (enterVaultTasks.isEmpty()) {
            return;
        }
        TeamData data = ServerQuestFile.INSTANCE.getData((Entity)player);
        for (EnterVaultTask task : enterVaultTasks) {
            if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.quest)) continue;
            data.setProgress((Task)task, 1L);
        }
    }
}

