/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.events.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.block.entity.DehammerizerTileEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.event.InputEvents;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.tool.ToolItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ToolHighlightEvents {
    private static boolean shouldRefreshToolHighlightCache = false;
    private static BlockPos previousPos;
    private static Direction previousFace;
    private static BlockState previousState;
    private static long previousOffset;
    private static final List<BlockPos> cachedPositions;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!shouldRefreshToolHighlightCache) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || previousPos == null || previousFace == null) {
            return;
        }
        if (!InputEvents.isShiftDown() || ActiveFlags.IS_AOE_MINING.isSet() || player.m_21205_().m_41720_() != ModItems.TOOL || DehammerizerTileEntity.hasDemhammerizerAround((Entity)player)) {
            return;
        }
        Level level = player.m_183503_();
        BlockPos pos = previousPos;
        Direction face = previousFace;
        ItemStack stack = player.m_21205_();
        cachedPositions.clear();
        ToolItem.getHammerPositions((Level)level, (ItemStack)stack, (BlockPos)pos, (Direction)face, (Entity)player).forEachRemaining(cachedPositions::add);
        shouldRefreshToolHighlightCache = false;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onBlockHighlight(DrawSelectionEvent.HighlightBlock event) {
        Player player;
        block7: {
            block6: {
                Entity entity = event.getCamera().m_90592_();
                if (!(entity instanceof Player)) break block6;
                player = (Player)entity;
                if (InputEvents.isShiftDown() && !ActiveFlags.IS_AOE_MINING.isSet() && player.m_21205_().m_41720_() == ModItems.TOOL && !DehammerizerTileEntity.hasDemhammerizerAround((Entity)player)) break block7;
            }
            return;
        }
        BlockHitResult target = event.getTarget();
        BlockPos pos = target.m_82425_();
        Direction face = target.m_82434_();
        Level level = player.m_183503_();
        BlockState blockState = level.m_8055_(pos);
        long offset = player.m_21205_().m_41784_().m_128454_("offset");
        if (!(blockState.equals(previousState) && pos.equals((Object)previousPos) && face.equals((Object)previousFace) && offset == previousOffset)) {
            shouldRefreshToolHighlightCache = true;
            previousPos = pos;
            previousFace = face;
            previousState = blockState;
            previousOffset = offset;
        }
        if (cachedPositions.isEmpty()) {
            return;
        }
        MultiBufferSource multiBufferSource = event.getMultiBufferSource();
        PoseStack poseStack = event.getPoseStack();
        Camera camera = event.getCamera();
        Vec3 cameraPos = camera.m_90583_();
        VertexConsumer vertexConsumer = (VertexConsumer)Lazy.of(() -> multiBufferSource.m_6299_(RenderType.m_110504_())).get();
        for (BlockPos p : cachedPositions) {
            BlockState state;
            if (p.equals((Object)pos) || !level.m_6857_().m_61937_(p) || (state = level.m_8055_(p)).m_60795_()) continue;
            VoxelShape shape = state.m_60838_((BlockGetter)level, p) ? Shapes.m_83144_() : state.m_60651_((BlockGetter)level, p, CollisionContext.m_82750_((Entity)player));
            LevelRenderer.m_109782_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (VoxelShape)shape, (double)((double)p.m_123341_() - cameraPos.m_7096_()), (double)((double)p.m_123342_() - cameraPos.m_7098_()), (double)((double)p.m_123343_() - cameraPos.m_7094_()), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.7f);
        }
    }

    static {
        cachedPositions = new ArrayList<BlockPos>();
    }
}

