/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.expertises;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.base.LearnableSkill;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class SurpriseModifiersExpertise
extends LearnableSkill {
    private int expertiseLevel;

    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT.writeBits((Number)this.expertiseLevel, buffer);
    }

    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.expertiseLevel = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
    }

    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt((Number)this.expertiseLevel).ifPresent(tag -> nbt.m_128365_("surpriseLevel", tag));
            return nbt;
        });
    }

    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.expertiseLevel = (Integer)Adapters.INT.readNbt(nbt.m_128423_("surpriseLevel")).orElseThrow();
    }

    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson((Number)this.expertiseLevel).ifPresent(element -> json.add("surpriseLevel", element));
            return json;
        });
    }

    public void readJson(JsonObject json) {
        super.readJson(json);
        this.expertiseLevel = (Integer)Adapters.INT.readJson(json.get("surpriseLevel")).orElseThrow();
    }

    public int getExpertiseLevel() {
        return this.expertiseLevel;
    }
}

