/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.gui.server;

import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.world.data.PlayerResearchesData;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class PlayerResearchesGUI
extends SimpleGui {
    private int ticker = 0;
    private final UUID target;
    DisplayElement EMPTY = DisplayElement.of((GuiElementInterface)new GuiElement(ItemStack.f_41583_, GuiElementInterface.EMPTY_CALLBACK));

    public PlayerResearchesGUI(ServerPlayer player, UUID target) {
        super(MenuType.f_39962_, player, false);
        this.target = target;
    }

    private static void playClickSound(ServerPlayer player) {
        player.m_6330_(SoundEvents.f_12490_, SoundSource.MASTER, 1.0f, 1.0f);
    }

    public void updateDisplay() {
        int i = 0;
        List<String> targetResearches = this.getResearches(this.target);
        for (String research : targetResearches) {
            DisplayElement RESEARCH_ELEMENT = DisplayElement.of(new GuiElementBuilder(PlayerResearchesGUI.getItemByMod(research)).setName(new TextComponent(research).m_130940_(ChatFormatting.GREEN)).addLoreLine((Component)new TextComponent("Unlocked.").m_130940_(ChatFormatting.GOLD)).hideFlags().setCallback((x, y, z) -> PlayerResearchesGUI.playClickSound(this.player)));
            this.setSlot(i, RESEARCH_ELEMENT.element);
            if (++i < 54) continue;
            return;
        }
    }

    public List<String> getResearches(UUID uuid) {
        ResearchTree playerResearches = PlayerResearchesData.get((ServerLevel)((ServerLevel)this.player.f_19853_)).getResearches(uuid);
        return playerResearches.getResearchesDone();
    }

    public static Item getItemByMod(String modName) {
        switch (modName) {
            case "Easy Villagers": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("easy_villagers:auto_trader"));
            }
            case "Botania Flux Field": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botania:mana_fluxfield"));
            }
            case "Soul Harvester": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("the_vault:vault_harvester"));
            }
            case "Big Backpacks": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("sophisticatedbackpacks:netherite_backpack"));
            }
            case "Backpacks": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("sophisticatedbackpacks:diamond_backpack"));
            }
            case "Belts": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("sophisticatedbackpacks:gold_backpack"));
            }
            case "Double Pouches": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("sophisticatedbackpacks:iron_backpack"));
            }
            case "Better Wallets": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("lightmanscurrency:wallet_netherite"));
            }
            case "Auto Feeding": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("sophisticatedbackpacks:feeding_upgrade"));
            }
            case "Auto Refill": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("sophisticatedbackpacks:refill_upgrade"));
            }
            case "Stack Upgrading": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("sophisticatedbackpacks:stack_upgrade_tier_4"));
            }
            case "Pouches": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("sophisticatedbackpacks:backpack"));
            }
            case "Junk Management": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("the_vault:vault_charm_controller"));
            }
            case "Phytogenic Insulator": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermal:machine_insolator"));
            }
            case "Digital Miner": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mekanism:digital_miner"));
            }
            case "Brews": {
                return Items.f_42543_;
            }
            case "Mixtures": {
                return Items.f_42544_;
            }
            case "Potions": {
                return Items.f_42590_;
            }
            case "Thermal Dynamos": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermal:dynamo_gourmand"));
            }
            case "Altar Automation": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("vaultintegrations:altar_conduit"));
            }
            case "Vault Compass": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("the_vault:vault_compass"));
            }
            case "Mekanism QIO": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mekanism:qio_drive_hyper_dense"));
            }
            case "Create Ore Excavation": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("createoreexcavation:netherite_drill"));
            }
            case "Automatic Genius": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("extrastorage:netherite_crafter"));
            }
            case "Mekanism Generators": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mekanismgenerators:gas_burning_generator"));
            }
            case "Iron Generators": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("irongenerators:iron_generator"));
            }
            case "Powah": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("powah:charged_snowball"));
            }
            case "Thermal Expansion": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermal:machine_furnace"));
            }
            case "Flux Networks": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("fluxnetworks:flux_plug"));
            }
            case "Botany Pots": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botanypots:terracotta_botany_pot"));
            }
            case "Bonsai Pots": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("bonsaitrees3:bonsai_pot"));
            }
            case "Cagerium": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("cagerium:cage"));
            }
            case "Create Mechanical Extruder": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("create_mechanical_extruder:mechanical_extruder"));
            }
            case "Create": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("create:cogwheel"));
            }
            case "Dark Utilities": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("darkutils:vector_plate"));
            }
            case "Industrial Foregoing": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("industrialforegoing:machine_frame_supreme"));
            }
            case "Mekanism": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mekanism:energy_tablet"));
            }
            case "PneumaticCraft": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("pneumaticcraft:pressure_tube"));
            }
            case "Botania": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botania:apothecary_default"));
            }
            case "Mob Spawners": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("ispawner:spawner"));
            }
            case "ComputerCraft": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("computercraft:computer_normal"));
            }
            case "Pipez": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("pipez:item_pipe"));
            }
            case "Modular Routers": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("modularrouters:modular_router"));
            }
            case "Hexcasting": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("hexcasting:wand_oak"));
            }
            case "LaserIO": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("laserio:laser_node"));
            }
            case "Xnet": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("xnet:router"));
            }
            case "Elevators": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("elevatorid:elevator_white"));
            }
            case "Iron Furnaces": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("ironfurnaces:iron_furnace"));
            }
            case "Applied Energistics": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("ae2:controller"));
            }
            case "Integrated Dynamics": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("integrateddynamics:variable"));
            }
            case "Refined Storage": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("refinedstorage:improved_processor"));
            }
            case "Iron Chests": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("ironchests:iron_chest"));
            }
            case "Drawers": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("storagedrawers:oak_full_drawers_1"));
            }
            case "Sophisticated Storage": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("sophisticatedstorage:controller"));
            }
            case "Mining Gadgets": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mininggadgets:mininggadget_simple"));
            }
            case "Building Gadgets": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("buildinggadgets:gadget_building"));
            }
            case "Trashcans": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("trashcans:item_trash_can"));
            }
            case "Torch Master": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("torchmaster:mega_torch"));
            }
            case "Waystones": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("waystones:waystone"));
            }
            case "Toms Simple Storage": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("toms_storage:ts.storage_terminal"));
            }
            case "Cloud Storage": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("cloudstorage:cloud_chest"));
            }
            case "RFTools Storage": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("rftoolsstorage:modular_storage"));
            }
            case "Colossal Chests": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("colossalchests:chest_wall_wood"));
            }
            case "Mega Cells": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("megacells:item_storage_cell_1m"));
            }
            case "Extra Storage": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("extrastorage:neural_processor"));
            }
            case "Botanical Machinery": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botanicalmachinery:mana_battery"));
            }
            case "Applied Mekanistics": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("appmek:chemical_cell_housing"));
            }
            case "Applied Botanics": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("appbot:mana_cell_housing"));
            }
            case "Create Crafts and Additions": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("createaddition:electric_motor"));
            }
            case "Create Diesel Generators": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("createdieselgenerators:diesel_engine"));
            }
            case "Time in a Bottle": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tiab:time_in_a_bottle"));
            }
            case "RFTools Utility": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("rftoolsutility:charged_porter"));
            }
            case "Hostile Neural Networks": {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("hostilenetworks:deep_learner"));
            }
        }
        return Items.f_42312_;
    }

    public void onTick() {
        ++this.ticker;
        if (this.ticker >= 20) {
            this.ticker = 0;
            this.updateDisplay();
        }
        super.onTick();
    }

    public record DisplayElement(@Nullable GuiElementInterface element, @Nullable Slot slot) {
        private static final DisplayElement EMPTY = DisplayElement.of((GuiElementInterface)new GuiElement(ItemStack.f_41583_, GuiElementInterface.EMPTY_CALLBACK));
        private static final DisplayElement FILLER = DisplayElement.of(new GuiElementBuilder(Items.f_42184_).setName((MutableComponent)new TextComponent("")).hideFlags());

        public static DisplayElement of(GuiElementInterface element) {
            return new DisplayElement(element, null);
        }

        public static DisplayElement of(GuiElementBuilderInterface<?> element) {
            return new DisplayElement(element.build(), null);
        }

        public static DisplayElement filler() {
            return FILLER;
        }

        public static DisplayElement empty() {
            return EMPTY;
        }
    }
}

