/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.init.client;

import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import xyz.iwolfking.woldsvaults.blocks.models.MonolithControllerModel;
import xyz.iwolfking.woldsvaults.init.ModBlocks;
import xyz.iwolfking.woldsvaults.init.ModItems;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModModels {
    public static void setupRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.SURVIVAL_MOB_BARRIER, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.ISKALLIAN_LEAVES_BLOCK, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.GATEWAY_CHANNELING_BLOCK, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.BREWING_ALTAR, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.DOLL_DISMANTLING_BLOCK, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.DECO_MONOLITH_BLOCK, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.GRAVEYARD_LOOT_BLOCK, (RenderType)RenderType.m_110463_());
    }

    @SubscribeEvent
    public static void registerBlockColorHandles(ColorHandlerEvent.Block event) {
        event.getBlockColors().m_92589_((state, blockDisplayReader, pos, tintIndex) -> {
            if (tintIndex < 0 || tintIndex > 1 || pos == null) {
                return -1;
            }
            return WorldHelper.getBlockEntity((BlockGetter)blockDisplayReader, (BlockPos)pos, BackpackBlockEntity.class).map(te -> tintIndex == 0 ? te.getBackpackWrapper().getMainColor() : te.getBackpackWrapper().getAccentColor()).orElse(ModModels.getDefaultColor(tintIndex));
        }, new Block[]{ModBlocks.XL_BACKPACK});
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(ColorHandlerEvent.Item event) {
        event.getItemColors().m_92689_((backpack, layer) -> {
            if (layer > 1 || !(backpack.m_41720_() instanceof BackpackItem)) {
                return -1;
            }
            return backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(backpackWrapper -> {
                if (layer == 0) {
                    return backpackWrapper.getMainColor();
                }
                if (layer == 1) {
                    return backpackWrapper.getAccentColor();
                }
                return -1;
            }).orElse(13394234);
        }, new ItemLike[]{ModItems.XL_BACKPACK});
        event.getItemColors().m_92689_((stack, layer) -> {
            CompoundTag tag;
            if (layer == 1 && (tag = stack.m_41783_()) != null && tag.m_128425_("PotionColor", 3)) {
                return tag.m_128451_("PotionColor");
            }
            return -1;
        }, new ItemLike[]{ModItems.DECO_POTION});
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(MonolithControllerModel.MODEL_LOCATION, MonolithControllerModel::createBodyLayer);
    }

    public static int getDefaultColor(int tintIndex) {
        return tintIndex == 0 ? 13394234 : 6434330;
    }
}

