/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.integration.ftbquests.tasks;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.iwolfking.woldsvaults.init.ModFTBQuestsTaskTypes;
import xyz.iwolfking.woldsvaults.integration.ftbquests.tasks.lib.ISingleIntValueTask;

public class VaultLevelTask
extends Task
implements ISingleIntValueTask {
    public int value = 1;

    public VaultLevelTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return ModFTBQuestsTaskTypes.VAULT_LEVEL;
    }

    public long getMaxProgress() {
        return this.value;
    }

    public String formatMaxProgress() {
        return Long.toUnsignedString(this.value);
    }

    public String formatProgress(TeamData teamData, long progress) {
        return Long.toUnsignedString(progress);
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128405_("value", this.value);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.value = nbt.m_128451_("value");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130130_(this.value);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.value = buffer.m_130242_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("value", this.value, v -> {
            this.value = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return new TranslatableComponent("ftbquests.reward.ftbquests.xp_levels").m_130946_(": ").m_7220_((Component)new TextComponent(this.formatMaxProgress()).m_130940_(ChatFormatting.RED));
    }

    public boolean consumesResources() {
        return true;
    }

    public void onButtonClicked(Button button, boolean canClick) {
    }

    public void submitTask(TeamData teamData, ServerPlayer player, ItemStack craftedItem) {
        int add = Math.toIntExact(Math.min((long)this.value - teamData.getProgress((Task)this), Integer.MAX_VALUE));
        if (add <= 0) {
            return;
        }
        teamData.addProgress((Task)this, (long)add);
    }

    @Override
    public void setValue(int value) {
        this.value = value;
    }
}

