/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.integration.jei;

import dev.attackeight.just_enough_vh.jei.ForgeItem;
import dev.attackeight.just_enough_vh.jei.JEIRecipeProvider;
import dev.attackeight.just_enough_vh.jei.RecyclerRecipe;
import dev.attackeight.just_enough_vh.jei.TheVaultJEIPlugin;
import dev.attackeight.just_enough_vh.jei.category.ForgeItemRecipeCategory;
import iskallia.vault.config.VaultRecyclerConfig;
import iskallia.vault.config.entry.recipe.ConfigForgeRecipe;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import xyz.iwolfking.woldsvaults.WoldsVaults;
import xyz.iwolfking.woldsvaults.config.lib.GenericLootableConfig;
import xyz.iwolfking.woldsvaults.config.lib.GenericShopPedestalConfig;
import xyz.iwolfking.woldsvaults.init.ModBlocks;
import xyz.iwolfking.woldsvaults.init.ModConfigs;
import xyz.iwolfking.woldsvaults.init.ModItems;
import xyz.iwolfking.woldsvaults.init.ModRecipeTypes;
import xyz.iwolfking.woldsvaults.integration.jei.category.InfuserCraftingCategory;
import xyz.iwolfking.woldsvaults.integration.jei.category.lib.GenericLootableBoxCategory;
import xyz.iwolfking.woldsvaults.integration.jei.category.lib.ShopTierCategory;
import xyz.iwolfking.woldsvaults.mixins.vaulthunters.accessors.ShopTierAccessor;

@JeiPlugin
public class WoldsVaultsJeiPlugin
implements IModPlugin {
    public static final RecipeType<GenericLootableConfig> CATALYST_BOX = RecipeType.create((String)"woldsvaults", (String)"catalyst_box", GenericLootableConfig.class);
    public static final RecipeType<GenericLootableConfig> INSCRIPTION_BOX = RecipeType.create((String)"woldsvaults", (String)"inscription_box", GenericLootableConfig.class);
    public static final RecipeType<GenericLootableConfig> AUGMENT_BOX = RecipeType.create((String)"woldsvaults", (String)"augment_box", GenericLootableConfig.class);
    public static final RecipeType<GenericLootableConfig> SUPPLY_BOX = RecipeType.create((String)"woldsvaults", (String)"supply_box", GenericLootableConfig.class);
    public static final RecipeType<GenericLootableConfig> GEM_BOX = RecipeType.create((String)"woldsvaults", (String)"gem_box", GenericLootableConfig.class);
    public static final RecipeType<GenericLootableConfig> OMEGA_BOX = RecipeType.create((String)"woldsvaults", (String)"omega_box", GenericLootableConfig.class);
    public static final RecipeType<GenericLootableConfig> ENIGMA_EGG = RecipeType.create((String)"woldsvaults", (String)"enigma_egg", GenericLootableConfig.class);
    public static final RecipeType<GenericLootableConfig> VAULTAR_BOX = RecipeType.create((String)"woldsvaults", (String)"vaultar_box", GenericLootableConfig.class);
    public static final RecipeType<GenericLootableConfig> GATEWAY_PEARL = RecipeType.create((String)"woldsvaults", (String)"gateway_pearl", GenericLootableConfig.class);
    public static final RecipeType<ShopTierAccessor> ETCHING_SHOP_PEDESTAL = RecipeType.create((String)"woldsvaults", (String)"etching_shop_pedestal", ShopTierAccessor.class);
    public static final RecipeType<ShopTierAccessor> GOD_SHOP_PEDESTAL = RecipeType.create((String)"woldsvaults", (String)"god_shop_pedestal", ShopTierAccessor.class);
    public static final RecipeType<ShopTierAccessor> BLACKSMITH_SHOP_PEDESTAL = RecipeType.create((String)"woldsvaults", (String)"blacksmith_shop_pedestal", ShopTierAccessor.class);
    public static final RecipeType<ShopTierAccessor> RARE_SHOP_PEDESTAL = RecipeType.create((String)"woldsvaults", (String)"rare_shop_pedestal", ShopTierAccessor.class);
    public static final RecipeType<ShopTierAccessor> OMEGA_SHOP_PEDESTAL = RecipeType.create((String)"woldsvaults", (String)"omega_shop_pedestal", ShopTierAccessor.class);
    public static final RecipeType<ShopTierAccessor> SPOOKY_SHOP_PEDESTAL = RecipeType.create((String)"woldsvaults", (String)"spooky_shop_pedestal", ShopTierAccessor.class);
    public static final RecipeType<ShopTierAccessor> CARD_SHOP_PEDESTAL = RecipeType.create((String)"woldsvaults", (String)"card_shop_pedestal", ShopTierAccessor.class);
    public static final RecipeType<ForgeItem> MOD_BOX_WORKSTATION = RecipeType.create((String)"woldsvaults", (String)"mod_box_workstation", ForgeItem.class);
    public static final RecipeType<ForgeItem> AUGMENTS_ASSEMBLY = RecipeType.create((String)"woldsvaults", (String)"augment_assembly", ForgeItem.class);
    public static final RecipeType<ForgeItem> WEAVING = RecipeType.create((String)"woldsvaults", (String)"weaving", ForgeItem.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return WoldsVaults.id("wolds_jei_integration");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.ENIGMA_EGG), new RecipeType[]{ENIGMA_EGG});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.OMEGA_BOX), new RecipeType[]{OMEGA_BOX});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.GEM_BOX), new RecipeType[]{GEM_BOX});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.SUPPLY_BOX), new RecipeType[]{SUPPLY_BOX});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.AUGMENT_BOX), new RecipeType[]{AUGMENT_BOX});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.INSCRIPTION_BOX), new RecipeType[]{INSCRIPTION_BOX});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.CATALYST_BOX), new RecipeType[]{CATALYST_BOX});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.VAULTAR_BOX), new RecipeType[]{VAULTAR_BOX});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.VAULT_INFUSER_BLOCK), new ResourceLocation[]{InfuserCraftingCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CHROMATIC_STEEL_INFUSER_BLOCK), new ResourceLocation[]{InfuserCraftingCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.UNIDENTIFIED_GATEWAY_PEARL), new RecipeType[]{GATEWAY_PEARL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ETCHING_PEDESTAL), new RecipeType[]{ETCHING_SHOP_PEDESTAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.GOD_VENDOR_PEDESTAL), new RecipeType[]{GOD_SHOP_PEDESTAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BLACKSMITH_VENDOR_PEDESTAL), new RecipeType[]{BLACKSMITH_SHOP_PEDESTAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.RARE_VENDOR_PEDESTAL), new RecipeType[]{RARE_SHOP_PEDESTAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.OMEGA_VENDOR_PEDESTAL), new RecipeType[]{OMEGA_SHOP_PEDESTAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SPOOKY_VENDOR_PEDESTAL), new RecipeType[]{SPOOKY_SHOP_PEDESTAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CARD_VENDOR_PEDESTAL), new RecipeType[]{CARD_SHOP_PEDESTAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.VAULT_SALVAGER_BLOCK), new RecipeType[]{TheVaultJEIPlugin.VAULT_RECYCLER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MOD_BOX_WORKSTATION), new RecipeType[]{MOD_BOX_WORKSTATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.AUGMENT_CRAFTING_TABLE), new RecipeType[]{AUGMENTS_ASSEMBLY});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WEAVING_STATION), new RecipeType[]{WEAVING});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new GenericLootableBoxCategory(guiHelper, ModConfigs.CATALYST_BOX, new TextComponent("Catalyst Box"), (Item)ModItems.CATALYST_BOX, CATALYST_BOX)});
        registration.addRecipeCategories(new IRecipeCategory[]{new GenericLootableBoxCategory(guiHelper, ModConfigs.VAULTAR_BOX, new TextComponent("Vaultar Box"), (Item)ModItems.VAULTAR_BOX, VAULTAR_BOX)});
        registration.addRecipeCategories(new IRecipeCategory[]{new GenericLootableBoxCategory(guiHelper, ModConfigs.INSCRIPTION_BOX, new TextComponent("Inscription Box"), (Item)ModItems.INSCRIPTION_BOX, INSCRIPTION_BOX)});
        registration.addRecipeCategories(new IRecipeCategory[]{new GenericLootableBoxCategory(guiHelper, ModConfigs.AUGMENT_BOX, new TextComponent("Augment Box"), (Item)ModItems.AUGMENT_BOX, AUGMENT_BOX)});
        registration.addRecipeCategories(new IRecipeCategory[]{new GenericLootableBoxCategory(guiHelper, ModConfigs.SUPPLY_BOX, new TextComponent("Supply Box"), (Item)ModItems.SUPPLY_BOX, SUPPLY_BOX)});
        registration.addRecipeCategories(new IRecipeCategory[]{new GenericLootableBoxCategory(guiHelper, ModConfigs.GEM_BOX, new TextComponent("Gem Box"), (Item)ModItems.GEM_BOX, GEM_BOX)});
        registration.addRecipeCategories(new IRecipeCategory[]{new GenericLootableBoxCategory(guiHelper, ModConfigs.OMEGA_BOX, new TextComponent("Omega Box"), (Item)ModItems.OMEGA_BOX, OMEGA_BOX)});
        registration.addRecipeCategories(new IRecipeCategory[]{new GenericLootableBoxCategory(guiHelper, ModConfigs.ENIGMA_EGG, new TextComponent("Enigma Egg"), (Item)ModItems.ENIGMA_EGG, ENIGMA_EGG)});
        registration.addRecipeCategories(new IRecipeCategory[]{new InfuserCraftingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new GenericLootableBoxCategory(guiHelper, ModConfigs.GATEWAY_PEARL, new TextComponent("Gateway Pearl"), (Item)ModItems.UNIDENTIFIED_GATEWAY_PEARL, GATEWAY_PEARL)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ShopTierCategory(guiHelper, new TextComponent("Etching Shop Pedestal"), ModBlocks.ETCHING_PEDESTAL.m_5456_(), ETCHING_SHOP_PEDESTAL)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ShopTierCategory(guiHelper, new TextComponent("God Shop Pedestal"), ModBlocks.GOD_VENDOR_PEDESTAL.m_5456_(), GOD_SHOP_PEDESTAL)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ShopTierCategory(guiHelper, new TextComponent("Blacksmith Shop Pedestal"), ModBlocks.BLACKSMITH_VENDOR_PEDESTAL.m_5456_(), BLACKSMITH_SHOP_PEDESTAL)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ShopTierCategory(guiHelper, new TextComponent("Rare Shop Pedestal"), ModBlocks.RARE_VENDOR_PEDESTAL.m_5456_(), RARE_SHOP_PEDESTAL)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ShopTierCategory(guiHelper, new TextComponent("Omega Shop Pedestal"), ModBlocks.OMEGA_VENDOR_PEDESTAL.m_5456_(), OMEGA_SHOP_PEDESTAL)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ShopTierCategory(guiHelper, new TextComponent("Spooky Shop Pedestal"), ModBlocks.SPOOKY_VENDOR_PEDESTAL.m_5456_(), SPOOKY_SHOP_PEDESTAL)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ShopTierCategory(guiHelper, new TextComponent("Card Shop Pedestal"), ModBlocks.CARD_VENDOR_PEDESTAL.m_5456_(), CARD_SHOP_PEDESTAL)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ForgeItemRecipeCategory(guiHelper, MOD_BOX_WORKSTATION, new ItemStack((ItemLike)ModBlocks.MOD_BOX_WORKSTATION.m_5456_()))});
        registration.addRecipeCategories(new IRecipeCategory[]{new ForgeItemRecipeCategory(guiHelper, AUGMENTS_ASSEMBLY, new ItemStack((ItemLike)ModBlocks.AUGMENT_CRAFTING_TABLE.m_5456_()))});
        registration.addRecipeCategories(new IRecipeCategory[]{new ForgeItemRecipeCategory(guiHelper, WEAVING, new ItemStack((ItemLike)ModBlocks.WEAVING_STATION.m_5456_()))});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            RecipeManager manager = world.m_7465_();
            registration.addRecipes(manager.m_44054_(ModRecipeTypes.INFUSER).values(), InfuserCraftingCategory.UID);
        }
        registration.addRecipes(ENIGMA_EGG, List.of(ModConfigs.ENIGMA_EGG));
        registration.addRecipes(OMEGA_BOX, List.of(ModConfigs.OMEGA_BOX));
        registration.addRecipes(GEM_BOX, List.of(ModConfigs.GEM_BOX));
        registration.addRecipes(SUPPLY_BOX, List.of(ModConfigs.SUPPLY_BOX));
        registration.addRecipes(AUGMENT_BOX, List.of(ModConfigs.AUGMENT_BOX));
        registration.addRecipes(INSCRIPTION_BOX, List.of(ModConfigs.INSCRIPTION_BOX));
        registration.addRecipes(CATALYST_BOX, List.of(ModConfigs.CATALYST_BOX));
        registration.addRecipes(VAULTAR_BOX, List.of(ModConfigs.VAULTAR_BOX));
        registration.addRecipes(GATEWAY_PEARL, List.of(ModConfigs.GATEWAY_PEARL));
        this.registerShopPedestalRecipes(registration, ModConfigs.ETCHING_SHOP_PEDESTAL, ETCHING_SHOP_PEDESTAL);
        this.registerShopPedestalRecipes(registration, ModConfigs.GOD_SHOP_PEDESTAL, GOD_SHOP_PEDESTAL);
        this.registerShopPedestalRecipes(registration, ModConfigs.BLACKSMITH_SHOP_PEDESTAL, BLACKSMITH_SHOP_PEDESTAL);
        this.registerShopPedestalRecipes(registration, ModConfigs.RARE_SHOP_PEDESTAL, RARE_SHOP_PEDESTAL);
        this.registerShopPedestalRecipes(registration, ModConfigs.OMEGA_SHOP_PEDESTAL, OMEGA_SHOP_PEDESTAL);
        this.registerShopPedestalRecipes(registration, ModConfigs.SPOOKY_SHOP_PEDESTAL, SPOOKY_SHOP_PEDESTAL);
        this.registerShopPedestalRecipes(registration, ModConfigs.CARD_SHOP_PEDESTAL, CARD_SHOP_PEDESTAL);
        registration.addRecipes(MOD_BOX_WORKSTATION, WoldsVaultsJeiPlugin.getForgeRecipes(ModConfigs.MOD_BOX_RECIPES_CONFIG.getConfigRecipes()));
        registration.addRecipes(AUGMENTS_ASSEMBLY, WoldsVaultsJeiPlugin.getForgeRecipes(ModConfigs.AUGMENT_RECIPES.getConfigRecipes()));
        registration.addRecipes(WEAVING, WoldsVaultsJeiPlugin.getForgeRecipes(ModConfigs.WEAVING_RECIPES_CONFIG.getConfigRecipes()));
        WoldsVaultsJeiPlugin.addCustomRecyclerRecipes(registration);
    }

    private void registerShopPedestalRecipes(IRecipeRegistration registration, GenericShopPedestalConfig configInstance, RecipeType<ShopTierAccessor> recipeType) {
        for (Object tier : configInstance.LEVELS) {
            ShopTierAccessor shopTier = (ShopTierAccessor)tier;
            registration.addRecipes(recipeType, List.of(shopTier));
        }
    }

    private static <R extends VaultForgeRecipe, T extends ConfigForgeRecipe<R>> List<ForgeItem> getForgeRecipes(List<T> configRecipes) {
        ArrayList<ForgeItem> recipes = new ArrayList<ForgeItem>();
        configRecipes.forEach(b -> recipes.add(new ForgeItem(b.makeRecipe().getInputs(), b.makeRecipe().getDisplayOutput(100))));
        return recipes;
    }

    private static void addCustomRecyclerRecipes(IRecipeRegistration registration) {
        ArrayList<RecyclerRecipe> recipes = new ArrayList<RecyclerRecipe>();
        for (Map.Entry rec : ModConfigs.CUSTOM_RECYCLER_CONFIG.getOutputs().entrySet()) {
            recipes.add(JEIRecipeProvider.getRecyclerRecipe((ItemStack)new ItemStack((ItemLike)Registry.f_122827_.m_7745_((ResourceLocation)rec.getKey())), (VaultRecyclerConfig.RecyclerOutput)((VaultRecyclerConfig.RecyclerOutput)rec.getValue())));
        }
        registration.addRecipes(TheVaultJEIPlugin.VAULT_RECYCLER, recipes);
    }
}

