/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.integration.jei.category.lib;

import iskallia.vault.VaultMod;
import iskallia.vault.config.entry.vending.ProductEntry;
import iskallia.vault.util.data.WeightedList;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import xyz.iwolfking.woldsvaults.config.lib.GenericLootableConfig;
import xyz.iwolfking.woldsvaults.mixins.vaulthunters.accessors.ProductEntryAccessor;

public class GenericLootableBoxCategory
implements IRecipeCategory<GenericLootableConfig> {
    private static final ResourceLocation TEXTURE = VaultMod.id((String)"textures/gui/jei/loot_info.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final GenericLootableConfig configInstance;
    private final TextComponent title;
    private final RecipeType<GenericLootableConfig> recipeType;

    public GenericLootableBoxCategory(IGuiHelper guiHelper, GenericLootableConfig configInstance, TextComponent title, Item itemForIcon, RecipeType<GenericLootableConfig> recipeType) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 162, 108);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)itemForIcon.m_7968_());
        this.configInstance = configInstance;
        this.title = title;
        this.recipeType = recipeType;
    }

    @Nonnull
    public Component getTitle() {
        return this.title;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public RecipeType<GenericLootableConfig> getRecipeType() {
        return this.recipeType;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    @Nonnull
    public Class<? extends GenericLootableConfig> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    @ParametersAreNonnullByDefault
    public void setRecipe(IRecipeLayoutBuilder builder, GenericLootableConfig recipe, IFocusGroup focuses) {
        ArrayList itemList = new ArrayList();
        recipe.POOL.forEach((productEntry, aDouble) -> {
            ItemStack stack = productEntry.generateItemStack();
            stack.m_41764_(((ProductEntryAccessor)productEntry).getAmountMax());
            itemList.add(stack);
        });
        int count = itemList.size();
        for (int i = 0; i < count; ++i) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 1 + 18 * (i % 9), 1 + 18 * (i / 9)).addItemStack(this.addChanceTooltip((ItemStack)itemList.get(i)));
        }
    }

    public ItemStack addChanceTooltip(ItemStack stack) {
        double totalWeight = this.configInstance.POOL.getTotalWeight();
        WeightedList<ProductEntry> entries = this.configInstance.POOL;
        for (WeightedList.Entry entry : entries) {
            if (((ProductEntry)entry.value).getItem() != stack.m_41720_() || ((ProductEntry)entry.value).getNBT() != null && !((ProductEntry)entry.value).getNBT().m_128456_() && !((ProductEntry)entry.value).getNBT().equals((Object)stack.m_41783_())) continue;
            CompoundTag nbt = stack.m_41698_("display");
            ListTag list = nbt.m_128437_("Lore", 8);
            TextComponent component = new TextComponent("Chance: ");
            double chance = (double)entry.weight / totalWeight * 100.0;
            component.m_130946_(String.format("%.2f", chance));
            component.m_130946_("%");
            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)component.m_130940_(ChatFormatting.YELLOW))));
            int minCount = ((ProductEntryAccessor)entry.value).getAmountMin();
            int maxCount = ((ProductEntryAccessor)entry.value).getAmountMax();
            if (minCount != maxCount) {
                component = new TextComponent("Count: " + minCount + " - " + maxCount);
                list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)component.m_130940_(ChatFormatting.DARK_PURPLE))));
            }
            nbt.m_128365_("Lore", (Tag)list);
        }
        return stack;
    }
}

