/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.integration.jei.category.lib;

import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.util.LootInitialization;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import xyz.iwolfking.woldsvaults.mixins.vaulthunters.accessors.ShopEntryAccessor;
import xyz.iwolfking.woldsvaults.mixins.vaulthunters.accessors.ShopTierAccessor;

public class ShopTierCategory
implements IRecipeCategory<ShopTierAccessor> {
    private static final ResourceLocation TEXTURE = VaultMod.id((String)"textures/gui/jei/loot_info.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final TextComponent title;
    private final RecipeType<ShopTierAccessor> recipeType;

    public ShopTierCategory(IGuiHelper guiHelper, TextComponent title, Item itemForIcon, RecipeType<ShopTierAccessor> recipeType) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 162, 108);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)itemForIcon.m_7968_());
        this.title = title;
        this.recipeType = recipeType;
    }

    @Nonnull
    public Component getTitle() {
        return this.title;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public RecipeType<ShopTierAccessor> getRecipeType() {
        return this.recipeType;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    @Nonnull
    public Class<? extends ShopTierAccessor> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    @ParametersAreNonnullByDefault
    public void setRecipe(IRecipeLayoutBuilder builder, ShopTierAccessor recipe, IFocusGroup focuses) {
        AtomicDouble totalWeight = new AtomicDouble();
        ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>();
        Set tierEntries = recipe.getTradePool().entrySet();
        for (Map.Entry entry : tierEntries) {
            ShopEntryAccessor shopEntry = (ShopEntryAccessor)entry.getKey();
            Double weight = (Double)entry.getValue();
            totalWeight.addAndGet(weight.doubleValue());
            ItemStack offer = shopEntry.getOffer();
            if (offer.m_41619_() || !(weight > 0.0)) continue;
            entries.add(entry);
        }
        int count = entries.size();
        for (int i = 0; i < count; ++i) {
            Map.Entry entry = (Map.Entry)entries.get(i);
            ShopEntryAccessor shopEntry = (ShopEntryAccessor)entry.getKey();
            double weight = (Double)entry.getValue();
            ItemStack offer = shopEntry.getOffer().m_41777_();
            Item currency = shopEntry.getCurrency();
            int minCost = shopEntry.getMinCost();
            int maxCost = shopEntry.getMaxCost();
            CompoundTag nbt = offer.m_41698_("display");
            ListTag list = nbt.m_128437_("Lore", 8);
            TextComponent component = new TextComponent("Chance: ");
            double chance = weight / totalWeight.get() * 100.0;
            component.m_130946_(String.format("%.2f", chance));
            component.m_130946_("%");
            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)component.m_130940_(ChatFormatting.YELLOW))));
            component = new TextComponent("Cost: " + minCost);
            if (minCost != maxCost) {
                component.m_130946_(" - " + maxCost);
            }
            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)component.m_130940_(ChatFormatting.DARK_PURPLE))));
            nbt.m_128365_("Lore", (Tag)list);
            ItemStack initialized = LootInitialization.initializeVaultLoot((ItemStack)offer, (int)0);
            if (initialized.equals(offer)) {
                builder.addSlot(RecipeIngredientRole.OUTPUT, 1 + 18 * (i % 9), 1 + 18 * (i / 9)).addIngredients(Ingredient.m_43927_((ItemStack[])new ItemStack[]{initialized}));
                continue;
            }
            ItemStack[] variants = new ItemStack[10];
            variants[0] = initialized;
            for (int n = 1; n < variants.length; ++n) {
                variants[n] = LootInitialization.initializeVaultLoot((ItemStack)offer, (int)0);
            }
            builder.addSlot(RecipeIngredientRole.OUTPUT, 1 + 18 * (i % 9), 1 + 18 * (i / 9)).addIngredients(Ingredient.m_43927_((ItemStack[])variants));
        }
    }

    public void draw(ShopTierAccessor recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        Minecraft.m_91087_().f_91062_.m_92889_(stack, (Component)new TextComponent("Level " + recipe.getMinLevel() + "+"), 0.0f, -12.0f, -16777216);
    }
}

