/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.integration.scannable.scanning;

import iskallia.vault.init.ModBlocks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import li.cil.scannable.api.scanning.BlockScannerModule;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.client.scanning.ScanResultProviders;
import li.cil.scannable.client.scanning.filter.BlockCacheScanFilter;
import li.cil.scannable.client.scanning.filter.BlockScanFilter;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public enum VaultObjectivesBlockScannerModule implements BlockScannerModule
{
    INSTANCE;

    private Predicate<BlockState> filter;
    public static Set<ResourceLocation> vaultBlocks;

    public int getEnergyCost(ItemStack module) {
        return 2500;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScanResultProvider getResultProvider() {
        return (ScanResultProvider)ScanResultProviders.BLOCKS.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float adjustLocalRange(float range) {
        return range * 0.7f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Predicate<BlockState> getFilter(ItemStack module) {
        this.validateFilter();
        return this.filter;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void validateFilter() {
        if (this.filter != null) {
            return;
        }
        ArrayList<BlockScanFilter> filters = new ArrayList<BlockScanFilter>();
        for (ResourceLocation location : vaultBlocks) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
            if (block == null) continue;
            filters.add(new BlockScanFilter(block));
        }
        this.filter = new BlockCacheScanFilter(filters);
    }

    static {
        vaultBlocks = (Set)Util.m_137469_(new HashSet(), c -> {
            c.add(ModBlocks.MONOLITH.getRegistryName());
            c.add(ModBlocks.GOD_ALTAR.getRegistryName());
            c.add(ModBlocks.LODESTONE.getRegistryName());
            c.add(ModBlocks.OBELISK.getRegistryName());
            c.add(ModBlocks.ALCHEMY_ARCHIVE.getRegistryName());
            c.add(ModBlocks.MODIFIER_DISCOVERY.getRegistryName());
            c.add(ModBlocks.ENHANCEMENT_ALTAR.getRegistryName());
            c.add(ModBlocks.SHOP_PEDESTAL.getRegistryName());
            c.add(xyz.iwolfking.woldsvaults.init.ModBlocks.BLACKSMITH_VENDOR_PEDESTAL.getRegistryName());
            c.add(xyz.iwolfking.woldsvaults.init.ModBlocks.ETCHING_PEDESTAL.getRegistryName());
            c.add(xyz.iwolfking.woldsvaults.init.ModBlocks.CARD_VENDOR_PEDESTAL.getRegistryName());
            c.add(xyz.iwolfking.woldsvaults.init.ModBlocks.GOD_VENDOR_PEDESTAL.getRegistryName());
            c.add(xyz.iwolfking.woldsvaults.init.ModBlocks.RARE_VENDOR_PEDESTAL.getRegistryName());
            c.add(xyz.iwolfking.woldsvaults.init.ModBlocks.OMEGA_VENDOR_PEDESTAL.getRegistryName());
            c.add(ModBlocks.CRAKE_PEDESTAL.getRegistryName());
            c.add(ModBlocks.SCAVENGER_ALTAR.getRegistryName());
            c.add(ModBlocks.VAULT_PORTAL.getRegistryName());
            c.add(ModBlocks.GRID_GATEWAY.getRegistryName());
            c.add(xyz.iwolfking.woldsvaults.init.ModBlocks.BREWING_ALTAR.getRegistryName());
            c.add(ModBlocks.RUNE_PILLAR.getRegistryName());
        });
    }
}

