/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.integration.vaultfilters.gte;

import iskallia.vault.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.joseph.vaultfilters.attributes.abstracts.StringListAttribute;
import net.minecraft.world.item.ItemStack;
import shadows.gateways.gate.Gateway;
import shadows.gateways.gate.Reward;
import shadows.gateways.item.GatePearlItem;

public class GatePearlRewardsAttribute
extends StringListAttribute {
    public GatePearlRewardsAttribute(String value) {
        super(value);
    }

    public String getTranslationKey() {
        return "gte_gate_pearl_rewards";
    }

    public String getValue(ItemStack itemStack) {
        return "";
    }

    public Object[] getTranslationParameters() {
        String modifiedItemName = ((String)this.value).replace("[", "").replace("]", "").trim();
        return new Object[]{modifiedItemName};
    }

    public static List<String> getRewardItems(ItemStack stack) {
        ArrayList<String> itemNamesList = new ArrayList<String>();
        if (stack.m_41720_() instanceof GatePearlItem) {
            Gateway gate = GatePearlItem.getGate((ItemStack)stack);
            if (gate == null) {
                return List.of();
            }
            List gateRewards = gate.getRewards();
            for (Reward reward : gateRewards) {
                itemNamesList.addAll(GatePearlRewardsAttribute.getRewardNameByType(reward));
            }
        }
        return itemNamesList;
    }

    public List<String> getValues(ItemStack itemStack) {
        return GatePearlRewardsAttribute.getRewardItems(itemStack);
    }

    private static List<String> getRewardNameByType(Reward reward) {
        if (reward instanceof Reward.StackReward) {
            Reward.StackReward stackReward = (Reward.StackReward)reward;
            return List.of(stackReward.stack().m_41611_().getString());
        }
        if (reward instanceof Reward.ChancedReward) {
            Reward.ChancedReward chancedReward = (Reward.ChancedReward)reward;
            return GatePearlRewardsAttribute.getRewardNameByType(chancedReward.reward());
        }
        if (reward instanceof Reward.LootTableReward) {
            Reward.LootTableReward lootTableReward = (Reward.LootTableReward)reward;
            return List.of(lootTableReward.table().m_135815_() + " loot table");
        }
        if (reward instanceof Reward.EntityLootReward) {
            Reward.EntityLootReward entityLootReward = (Reward.EntityLootReward)reward;
            return List.of(StringUtils.convertToTitleCase((String)entityLootReward.type().getRegistryName().m_135815_()) + " loot");
        }
        if (reward instanceof Reward.CommandReward) {
            Reward.CommandReward commandReward = (Reward.CommandReward)reward;
            return List.of(commandReward.command());
        }
        if (reward instanceof Reward.StackListReward) {
            Reward.StackListReward stackListReward = (Reward.StackListReward)reward;
            ArrayList<String> itemList = new ArrayList<String>();
            for (ItemStack stack : stackListReward.stacks()) {
                itemList.add(stack.m_41611_().getString());
            }
            return itemList;
        }
        return List.of();
    }
}

