/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items;

import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import iskallia.vault.altar.AltarInfusionRecipe;
import iskallia.vault.block.entity.VaultAltarTileEntity;
import iskallia.vault.item.BasicItem;
import iskallia.vault.world.data.PlayerVaultAltarData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import xyz.iwolfking.woldsvaults.lib.VaultAltarTileEntityInterface;

public class AltarResetItem
extends BasicItem {
    public AltarResetItem(ResourceLocation id, Item.Properties properties) {
        super(id, properties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        ItemStack stackInHand = context.m_43722_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(context.m_8083_());
        if (blockEntity instanceof VaultAltarTileEntity) {
            VaultAltarTileEntity altar = (VaultAltarTileEntity)blockEntity;
            if (stackInHand.m_41720_() instanceof AltarResetItem && altar.getAltarState().equals((Object)VaultAltarTileEntity.AltarState.ACCEPTING)) {
                if (AltarResetItem.resetAltar((ServerPlayer)context.m_43723_())) {
                    stackInHand.m_41774_(1);
                    level.m_5594_(null, context.m_8083_(), AMSoundRegistry.COSMAW_IDLE, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static boolean resetAltar(ServerPlayer player) {
        ServerLevel level = player.m_183503_();
        PlayerVaultAltarData data = PlayerVaultAltarData.get((ServerLevel)level);
        List altars = data.getAltars(player.m_142081_());
        altars.stream().filter(arg_0 -> ((ServerLevel)level).m_46749_(arg_0)).map(pos -> player.m_183503_().m_7702_(pos)).filter(te -> te instanceof VaultAltarTileEntity).map(te -> (VaultAltarTileEntity)te).filter(altar -> altar.getAltarState() == VaultAltarTileEntity.AltarState.ACCEPTING).forEach(altar -> {});
        AltarResetItem.regenerateAltars(altars, player);
        return true;
    }

    private static void regenerateAltar(VaultAltarTileEntity altar, ServerPlayer player, AltarInfusionRecipe recipe) {
        PlayerVaultAltarData altarData = PlayerVaultAltarData.get((ServerLevel)player.m_183503_());
        if (altar.getOwner().equals(player.m_142081_()) && altar.getAltarState().equals((Object)VaultAltarTileEntity.AltarState.IDLE)) {
            altar.setRecipe(recipe);
            ((VaultAltarTileEntityInterface)altar).invokeUpdateDisplayedIndex(recipe);
            altar.setAltarState(VaultAltarTileEntity.AltarState.ACCEPTING);
            altar.sendUpdates();
        }
    }

    private static void regenerateAltars(List<BlockPos> altars, ServerPlayer player) {
        PlayerVaultAltarData altarData = PlayerVaultAltarData.get((ServerLevel)player.m_183503_());
        altars.forEach(blockPos -> {
            VaultAltarTileEntity altar;
            BlockEntity patt3623$temp;
            if (player.m_183503_().m_46749_(blockPos) && (patt3623$temp = player.m_183503_().m_7702_(blockPos)) instanceof VaultAltarTileEntity && (altar = (VaultAltarTileEntity)patt3623$temp).getOwner().equals(player.m_142081_())) {
                if (altar.getAltarState().equals((Object)VaultAltarTileEntity.AltarState.ACCEPTING)) {
                    if (altarData.getRecipe((Player)player) != null && altarData.getRecipe((Player)player).isPogInfused()) {
                        ((VaultAltarTileEntityInterface)altar).invokeResetAltar(player.m_183503_());
                        altar.setRecipe(null);
                        altar.setAltarState(VaultAltarTileEntity.AltarState.IDLE);
                        altar.sendUpdates();
                        return;
                    }
                    ((VaultAltarTileEntityInterface)altar).invokeResetAltar(player.m_183503_());
                    AltarInfusionRecipe recipe = altarData.getRecipe(player, blockPos);
                    altar.setRecipe(recipe);
                    ((VaultAltarTileEntityInterface)altar).invokeUpdateDisplayedIndex(recipe);
                    altar.setAltarState(VaultAltarTileEntity.AltarState.ACCEPTING);
                    altar.sendUpdates();
                } else if (altar.getAltarState().equals((Object)VaultAltarTileEntity.AltarState.IDLE)) {
                    ((VaultAltarTileEntityInterface)altar).invokeResetAltar(player.m_183503_());
                }
            }
        });
    }
}

