/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items;

import iskallia.vault.block.entity.CompanionHomeTileEntity;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import iskallia.vault.item.CompanionItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class CompanionRerollingItem
extends BasicItem {
    public CompanionRerollingItem(ResourceLocation id) {
        super(id);
    }

    public static InteractionResult rerollCompanionModifier(Level level, ItemStack stackInHand, Player player, BlockPos pos) {
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        if (player == null) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CompanionHomeTileEntity) {
            CompanionHomeTileEntity home = (CompanionHomeTileEntity)blockEntity;
            if (stackInHand.m_41720_() instanceof CompanionRerollingItem && !home.getCompanion().m_41619_() && player.m_6144_()) {
                VaultModifier modifier;
                ItemStack companion = home.getCompanion();
                if (stackInHand.m_41782_() && stackInHand.m_41784_().m_128441_("modifier")) {
                    String modifierId = stackInHand.m_41784_().m_128461_("modifier");
                    modifier = VaultModifierRegistry.get((ResourceLocation)new ResourceLocation(modifierId));
                } else {
                    modifier = CompanionItem.getRandomTemporalModifier();
                }
                CompanionItem.setTemporalModifier((ItemStack)companion, (ResourceLocation)modifier.getId());
                stackInHand.m_41774_(1);
                player.m_5661_((Component)new TextComponent("Your Companion now has the ").m_7220_(modifier.getNameComponent()).m_130946_(" modifier!"), true);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public Component getModifierName(ItemStack stack) {
        String modifierId;
        VaultModifier modifier;
        if (stack.m_41782_() && stack.m_41784_().m_128441_("modifier") && (modifier = VaultModifierRegistry.get((ResourceLocation)new ResourceLocation(modifierId = stack.m_41784_().m_128461_("modifier")))) != null) {
            return modifier.getNameComponent();
        }
        return null;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        return CompanionRerollingItem.rerollCompanionModifier(context.m_43725_(), player.m_21120_(context.m_43724_()), player, context.m_8083_());
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (this.getModifierName(stack) != null) {
            tooltip.add((Component)new TextComponent("Sneak and right-click on a Companion Home containing a Companion to set its temporal modifier to ").m_7220_(this.getModifierName(stack)));
        } else {
            tooltip.add((Component)new TextComponent("Sneak and right-click on a Companion Home containing a Companion to reroll its temporal modifier!"));
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        TextComponent modifierName = (TextComponent)this.getModifierName(stack);
        if (modifierName != null) {
            return new TextComponent("Companion Temporalizer - ").m_7220_((Component)modifierName.m_130940_(ChatFormatting.WHITE));
        }
        return new TextComponent("Companion Temporalizer");
    }

    public void m_6787_(CreativeModeTab category, @NotNull NonNullList<ItemStack> items) {
        if (category.equals(ModItems.VAULT_MOD_GROUP)) {
            items.add((Object)new ItemStack((ItemLike)xyz.iwolfking.woldsvaults.init.ModItems.COMPANION_REROLLER));
        }
    }
}

