/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items;

import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.BasicItem;
import iskallia.vault.world.data.ServerVaults;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.woldsvaults.api.util.ComponentUtils;
import xyz.iwolfking.woldsvaults.api.util.CorruptedVaultHelper;
import xyz.iwolfking.woldsvaults.objectives.CorruptedObjective;

public class DecayingItem
extends BasicItem {
    private final int secondsUntilExpired;
    private int tickCount;

    public DecayingItem(ResourceLocation id, int secondsUntilExpired) {
        super(id);
        this.secondsUntilExpired = secondsUntilExpired;
    }

    public int m_142158_(ItemStack pStack) {
        int remainingSeconds = this.getRemainingSeconds(pStack);
        return Math.round((float)remainingSeconds / (float)this.secondsUntilExpired * 13.0f);
    }

    public boolean m_142522_(ItemStack pStack) {
        return pStack.m_41784_().m_128441_("RemainingSeconds");
    }

    public int m_142159_(ItemStack pStack) {
        return TextColor.m_131268_((String)"#701233").m_131265_();
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!pLevel.f_46443_ && pEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pEntity;
            if (!CorruptedVaultHelper.isVaultCorrupted) {
                if (pStack.m_41783_() != null && pStack.m_41783_().m_128441_("RemainingSeconds")) {
                    pStack.m_41751_(null);
                }
                return;
            }
            Vault vault = ServerVaults.get((Level)pLevel).orElse(null);
            if (vault == null) {
                return;
            }
            Optional<CorruptedObjective> objective = ((Objective.ObjList)((Objectives)vault.get(Vault.OBJECTIVES)).get(Objectives.LIST)).stream().filter(o -> o instanceof CorruptedObjective).map(o -> (CorruptedObjective)((Object)o)).findFirst();
            if (objective.isEmpty()) {
                return;
            }
            if (((CorruptedObjective.CData)((Object)objective.get().get(CorruptedObjective.DATA))).hasCompletedInitial()) {
                return;
            }
            if (!pStack.m_41784_().m_128441_("RemainingSeconds")) {
                this.setRemainingSeconds(pStack, this.secondsUntilExpired);
            }
            if (pStack.m_41782_()) {
                int remainingSeconds = this.getRemainingSeconds(pStack);
                if (pLevel.m_46467_() % 20L == 0L) {
                    if (remainingSeconds > 0) {
                        this.setRemainingSeconds(pStack, remainingSeconds - 1);
                    } else {
                        pStack.m_41764_(0);
                        player.m_150109_().m_6836_(pSlotId, new ItemStack((ItemLike)ModBlocks.SOOT));
                        pLevel.m_5594_(null, pEntity.m_142538_(), ModSounds.ABILITY_ON_COOLDOWN, SoundSource.PLAYERS, 1.0f, 0.4f);
                    }
                }
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (ClientVaults.getActive().isPresent() && CorruptedVaultHelper.isVaultCorrupted) {
            MutableComponent cmp0 = new TextComponent("Powers the Monolith.").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#701233")).m_131155_(Boolean.valueOf(true)));
            MutableComponent cmp1 = new TextComponent("Slowly decays in your inventory.").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#701233")).m_131155_(Boolean.valueOf(true)));
            tooltip.add((Component)ComponentUtils.corruptComponent(cmp0));
            tooltip.add((Component)ComponentUtils.corruptComponent(cmp1));
        } else {
            MutableComponent cmp0 = new TextComponent("Crafting Ingredient").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#701233")).m_131155_(Boolean.valueOf(true)));
            tooltip.add((Component)ComponentUtils.corruptComponent(cmp0));
        }
    }

    private void setRemainingSeconds(ItemStack stack, int seconds) {
        stack.m_41784_().m_128405_("RemainingSeconds", seconds);
    }

    private int getRemainingSeconds(ItemStack stack) {
        return stack.m_41784_().m_128451_("RemainingSeconds");
    }

    public boolean m_142095_() {
        return ClientVaults.getActive().isEmpty();
    }

    public int getItemStackLimit(ItemStack stack) {
        return 55;
    }
}

