/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items;

import com.simibubi.create.content.logistics.filter.FilterItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import iskallia.vault.research.StageManager;
import java.util.List;
import net.joseph.vaultfilters.VFTests;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import xyz.iwolfking.woldsvaults.gui.menus.FilterNecklaceMenu;
import xyz.iwolfking.woldsvaults.mixins.create.accessors.FilterItemAccessor;

public class FilterNecklaceItem
extends BasicItem
implements ICurioItem {
    private final int slotCount;

    public FilterNecklaceItem(ResourceLocation id, int slotCount) {
        super(id, new Item.Properties().m_41487_(1).m_41491_(ModItems.VAULT_MOD_GROUP));
        this.slotCount = slotCount;
    }

    public IItemHandler getInventory(final ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        ItemStackHandler handler = new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                FilterNecklaceItem.this.saveToStack(stack, this);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack incoming) {
                return incoming.m_41720_() instanceof FilterItem;
            }
        };
        if (tag.m_128441_("Inventory")) {
            handler.deserializeNBT(tag.m_128469_("Inventory"));
        }
        return handler;
    }

    private void saveToStack(ItemStack stack, ItemStackHandler handler) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag newInvTag = handler.serializeNBT();
        if (!tag.m_128441_("Inventory") || !tag.m_128469_("Inventory").equals((Object)newInvTag)) {
            tag.m_128365_("Inventory", (Tag)handler.serializeNBT());
        }
    }

    public boolean stackMatchesFilter(ItemStack stack, ItemStack necklace) {
        IItemHandler handler = this.getInventory(necklace);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (!(slotStack.m_41720_() instanceof FilterItem ? VFTests.checkFilter((ItemStack)stack, (Object)slotStack, (boolean)true, null) : slotStack.m_41720_().equals(stack.m_41720_()))) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getNecklace(Player player) {
        SlotResult result = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)xyz.iwolfking.woldsvaults.init.ModItems.FILTER_NECKLACE).orElse(null);
        if (result == null) {
            return ItemStack.f_41583_;
        }
        return result.stack();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.f_46443_) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, ply) -> new FilterNecklaceMenu(id, inv, player.m_21120_(hand)), (Component)new TextComponent("Filter Necklace")));
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        ServerPlayer player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer && !StageManager.getResearchTree((Player)(player = (ServerPlayer)livingEntity)).isResearched(ModConfigs.RESEARCHES.getByName("Junk Management"))) {
            return false;
        }
        return super.canEquip(slotContext, stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (ModConfigs.isInitialized() && !StageManager.RESEARCH_TREE.isResearched(ModConfigs.RESEARCHES.getByName("Junk Management"))) {
            tooltip.add((Component)new TextComponent("Unlock \"Junk Management\" to equip").m_130940_(ChatFormatting.RED));
            tooltip.add(TextComponent.f_131282_);
            return;
        }
        if (Screen.m_96638_()) {
            IItemHandler inventory = this.getInventory(stack);
            tooltip.add((Component)new TextComponent("Hold down [").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent("Ctrl").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)new TextComponent("] to show nested filters.").m_130940_(ChatFormatting.GRAY)));
            for (int i = 0; i < inventory.getSlots(); ++i) {
                FilterItem filterItem;
                List<Component> makeSummary;
                ItemStack slotStack = inventory.getStackInSlot(i);
                Item item = inventory.getStackInSlot(i).m_41720_();
                if (!(item instanceof FilterItem) || (makeSummary = ((FilterItemAccessor)(filterItem = (FilterItem)item)).runMakeSummary(slotStack)).isEmpty()) continue;
                tooltip.add((Component)new TextComponent(""));
                tooltip.addAll(makeSummary);
            }
        } else {
            tooltip.add((Component)new TextComponent("Hold down [").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent("Shift").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)new TextComponent("] to show details.").m_130940_(ChatFormatting.GRAY)));
            tooltip.add((Component)new TextComponent(""));
            tooltip.add((Component)new TextComponent("Insert Attribute Filters inside and any matching items will be voided inside vaults while wearing this!"));
        }
    }
}

