/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items;

import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import iskallia.vault.world.data.PlayerReputationData;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class GodReputationItem
extends BasicItem {
    public GodReputationItem(ResourceLocation id) {
        super(id);
    }

    @Nullable
    public static VaultGod getGod(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof GodReputationItem && stack.m_41782_() && stack.m_41783_() != null && stack.m_41783_().m_128441_("god")) {
            try {
                return VaultGod.valueOf((String)stack.m_41783_().m_128461_("god"));
            }
            catch (IllegalArgumentException exception) {
                return VaultGod.valueOf((String)"IDONA");
            }
        }
        return null;
    }

    public static ItemStack create(String tag) {
        ItemStack stack = new ItemStack((ItemLike)xyz.iwolfking.woldsvaults.init.ModItems.GOD_OFFERING);
        stack.m_41784_().m_128359_("god", tag);
        return stack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21205_();
        if (!(hand.equals((Object)InteractionHand.MAIN_HAND) && heldStack.m_41720_() instanceof GodReputationItem && player.m_6144_())) {
            return InteractionResultHolder.m_19098_((Object)heldStack);
        }
        UUID playerUuid = player.m_142081_();
        VaultGod god = GodReputationItem.getGod(heldStack);
        if (!level.m_5776_() && god != null) {
            if (PlayerReputationData.getReputation((UUID)playerUuid, (VaultGod)god) >= 50) {
                player.m_5661_((Component)new TextComponent("You already have the max reputation with ").m_130940_(ChatFormatting.RED).m_130946_(god.getName()).m_130940_(god.getChatColor()), true);
                return InteractionResultHolder.m_19098_((Object)heldStack);
            }
            PlayerReputationData.addReputation((UUID)player.m_142081_(), (VaultGod)GodReputationItem.getGod(heldStack), (int)1);
            heldStack.m_41774_(1);
            level.m_5594_(player, player.m_20097_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)heldStack);
        }
        return InteractionResultHolder.m_19098_((Object)heldStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, worldIn, tooltip, flag);
        VaultGod attr = GodReputationItem.getGod(stack);
        if (attr != null) {
            String name = attr.getName();
            MutableComponent text = new TextComponent("Shift right-click to gain 1 reputation with ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(name).m_130940_(attr.getChatColor()).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY)));
            tooltip.add((Component)text);
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        VaultGod god = GodReputationItem.getGod(stack);
        if (god != null) {
            return new TextComponent("God Offering").m_130946_(" - " + god.getName());
        }
        return new TextComponent("God Offering");
    }

    public void m_6787_(CreativeModeTab category, @NotNull NonNullList<ItemStack> items) {
        if (category.equals(ModItems.VAULT_MOD_GROUP)) {
            items.add((Object)GodReputationItem.create("IDONA"));
            items.add((Object)GodReputationItem.create("TENOS"));
            items.add((Object)GodReputationItem.create("WENDARR"));
            items.add((Object)GodReputationItem.create("VELARA"));
        }
    }
}

