/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items;

import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.core.DataTransferItem;
import iskallia.vault.item.core.VaultLevelItem;
import iskallia.vault.item.crystal.layout.ClassicCircleCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicInfiniteCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicPolygonCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicSpiralCrystalLayout;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.woldsvaults.init.ModItems;
import xyz.iwolfking.woldsvaults.mixins.vaulthunters.accessors.ClassicCircleCrystalLayoutAccessor;
import xyz.iwolfking.woldsvaults.mixins.vaulthunters.accessors.ClassicInfiniteCrystalLayoutAccessor;
import xyz.iwolfking.woldsvaults.mixins.vaulthunters.accessors.ClassicPolygonCrystalLayoutAccessor;
import xyz.iwolfking.woldsvaults.mixins.vaulthunters.accessors.ClassicSpiralCrystalLayoutAccessor;

public class LayoutModificationItem
extends Item
implements VaultLevelItem,
DataTransferItem {
    public LayoutModificationItem(CreativeModeTab group, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group));
        this.setRegistryName(id);
    }

    public void m_7373_(@Nonnull ItemStack stack, @javax.annotation.Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag advanced) {
        super.m_7373_(stack, world, tooltip, advanced);
        LayoutModificationItem.getLayout(stack).ifPresent(key -> {
            if (key instanceof ClassicCircleCrystalLayout) {
                ClassicCircleCrystalLayout crystalLayout = (ClassicCircleCrystalLayout)key;
                tooltip.add((Component)new TextComponent("Layout: ").m_7220_((Component)new TextComponent("Circle").m_130948_(Style.f_131099_.m_178520_(3191506))));
                tooltip.add((Component)new TextComponent("Tunnel Span: ").m_7220_((Component)new TextComponent(String.valueOf(((ClassicInfiniteCrystalLayoutAccessor)crystalLayout).getTunnelSpan())).m_130940_(ChatFormatting.GOLD)));
                tooltip.add((Component)new TextComponent("Radius: ").m_7220_((Component)new TextComponent(String.valueOf(((ClassicCircleCrystalLayoutAccessor)crystalLayout).getRadius())).m_130940_(ChatFormatting.GOLD)));
            } else if (key instanceof ClassicPolygonCrystalLayout) {
                ClassicPolygonCrystalLayout crystalLayout = (ClassicPolygonCrystalLayout)key;
                tooltip.add((Component)new TextComponent("Layout: ").m_7220_((Component)new TextComponent("Polygon").m_130948_(Style.f_131099_.m_178520_(16757504))));
                tooltip.add((Component)new TextComponent("Tunnel Span: ").m_7220_((Component)new TextComponent(String.valueOf(((ClassicInfiniteCrystalLayoutAccessor)crystalLayout).getTunnelSpan())).m_130940_(ChatFormatting.GOLD)));
                tooltip.add((Component)new TextComponent("Vertices: ").m_7220_((Component)new TextComponent(Arrays.toString(((ClassicPolygonCrystalLayoutAccessor)crystalLayout).getVertices())).m_130940_(ChatFormatting.GOLD)));
            } else if (key instanceof ClassicSpiralCrystalLayout) {
                ClassicSpiralCrystalLayout crystalLayout = (ClassicSpiralCrystalLayout)key;
                tooltip.add((Component)new TextComponent("Layout: ").m_7220_((Component)new TextComponent("Spiral").m_130948_(Style.f_131099_.m_178520_(3191296))));
                tooltip.add((Component)new TextComponent("Tunnel Span: ").m_7220_((Component)new TextComponent(String.valueOf(((ClassicInfiniteCrystalLayoutAccessor)crystalLayout).getTunnelSpan())).m_130940_(ChatFormatting.GOLD)));
                tooltip.add((Component)new TextComponent("Half Length: ").m_7220_((Component)new TextComponent(String.valueOf(((ClassicSpiralCrystalLayoutAccessor)crystalLayout).getHalfLength())).m_130940_(ChatFormatting.GOLD)));
            } else if (key instanceof ClassicInfiniteCrystalLayout) {
                ClassicInfiniteCrystalLayout crystalLayout = (ClassicInfiniteCrystalLayout)key;
                tooltip.add((Component)new TextComponent("Layout: ").m_7220_((Component)new TextComponent("Infinite").m_130948_(Style.f_131099_.m_178520_(16730880))));
                tooltip.add((Component)new TextComponent("Tunnel Span: ").m_7220_((Component)new TextComponent(String.valueOf(((ClassicInfiniteCrystalLayoutAccessor)crystalLayout).getTunnelSpan())).m_130940_(ChatFormatting.GOLD)));
            }
        });
    }

    public static Optional<CrystalLayout> getLayout(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return Optional.empty();
        }
        CompoundTag nbt = stack.m_41784_();
        if (!(nbt.m_128441_("layout") && nbt.m_128441_("tunnel") && nbt.m_128441_("value"))) {
            return Optional.empty();
        }
        String layoutName = nbt.m_128461_("layout");
        int tunnel = nbt.m_128451_("tunnel");
        int value = nbt.m_128451_("value");
        return switch (layoutName) {
            case "infinite" -> Optional.of(new ClassicInfiniteCrystalLayout(tunnel));
            case "circle" -> Optional.of(new ClassicCircleCrystalLayout(tunnel, value));
            case "polygon" -> Optional.of(new ClassicPolygonCrystalLayout(tunnel, new int[]{-1 * value, value, value, value, value, -1 * value, -1 * value, -1 * value}));
            case "spiral" -> Optional.of(new ClassicSpiralCrystalLayout(tunnel, value, Rotation.CLOCKWISE_90));
            default -> Optional.empty();
        };
    }

    public static ItemStack create(String type, int tunnelSpan, int value) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.LAYOUT_MANIPULATOR);
        stack.m_41784_().m_128359_("layout", type);
        stack.m_41784_().m_128405_("tunnel", tunnelSpan);
        stack.m_41784_().m_128405_("value", value);
        return stack;
    }

    public void initializeVaultLoot(int i, ItemStack stack, @Nullable BlockPos blockPos, @Nullable Vault vault) {
        this.createStackFromLevel(i, stack);
    }

    private String getLayoutType(CrystalLayout key) {
        if (key instanceof ClassicCircleCrystalLayout) {
            return "circle";
        }
        if (key instanceof ClassicPolygonCrystalLayout) {
            return "polygon";
        }
        if (key instanceof ClassicSpiralCrystalLayout) {
            return "spiral";
        }
        if (key instanceof ClassicInfiniteCrystalLayout) {
            return "infinite";
        }
        return null;
    }

    public ItemStack convertStack(ItemStack stack, RandomSource random) {
        if (stack.m_41783_() == null) {
            return stack;
        }
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_("level")) {
            return stack;
        }
        int level = nbt.m_128451_("pool");
        return this.createStackFromLevel(level, stack);
    }

    private ItemStack createStackFromLevel(int level, ItemStack stack) {
        if (stack.m_41783_() == null) {
            return stack;
        }
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("layout")) {
            return stack;
        }
        Optional layout = ModConfigs.VAULT_CRYSTAL.getRandomLayout(level, (RandomSource)JavaRandom.ofNanoTime());
        if (layout.isEmpty()) {
            return stack;
        }
        String type = this.getLayoutType((CrystalLayout)layout.get());
        if (type != null) {
            nbt.m_128359_("layout", type);
            nbt.m_128405_("tunnel", 1);
            switch (type) {
                case "polygon": {
                    int i = ((ClassicPolygonCrystalLayoutAccessor)layout.get()).getVertices()[1];
                    if (i == 0) {
                        i = ((ClassicPolygonCrystalLayoutAccessor)layout.get()).getVertices()[3];
                    }
                    nbt.m_128405_("value", i);
                    break;
                }
                case "circle": {
                    nbt.m_128405_("value", ((ClassicCircleCrystalLayoutAccessor)layout.get()).getRadius());
                    break;
                }
                case "spiral": {
                    nbt.m_128405_("value", ((ClassicSpiralCrystalLayoutAccessor)layout.get()).getHalfLength());
                    break;
                }
                default: {
                    nbt.m_128405_("value", 0);
                }
            }
            stack.m_41751_(nbt);
            return stack;
        }
        return stack;
    }
}

