/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items;

import iskallia.vault.init.ModParticles;
import iskallia.vault.item.BasicItem;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LocatorItem
extends BasicItem {
    private final Block blockToLocate;
    private final int yLevelFilter;

    public LocatorItem(ResourceLocation id, Block blockToLocate, int yLevelFilter) {
        super(id);
        this.blockToLocate = blockToLocate;
        this.yLevelFilter = yLevelFilter;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (!pLevel.m_5776_()) {
            BlockPos foundPos = this.findClosestBlock(pLevel, pPlayer.m_142538_(), this.yLevelFilter);
            if (foundPos != null) {
                this.spawnGuidanceParticles((ServerLevel)pLevel, pPlayer.m_142538_(), foundPos);
            }
            pPlayer.m_36335_().m_41524_((Item)this, 200);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    private BlockPos findClosestBlock(Level level, BlockPos playerPos, int yLevel) {
        int searchRadius = 128;
        BlockPos closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (int dx = -searchRadius; dx <= searchRadius; ++dx) {
            for (int dz = -searchRadius; dz <= searchRadius; ++dz) {
                double dist;
                BlockPos pos = new BlockPos(playerPos.m_123341_() + dx, yLevel, playerPos.m_123343_() + dz);
                if (level.m_8055_(pos).m_60734_() != this.blockToLocate || !((dist = playerPos.m_123331_((Vec3i)pos)) < closestDistance)) continue;
                closest = pos;
                closestDistance = dist;
            }
        }
        return closest;
    }

    private void spawnGuidanceParticles(ServerLevel level, BlockPos from, BlockPos to) {
        if (to == null) {
            return;
        }
        Vec3 dir = Vec3.m_82512_((Vec3i)to).m_82546_(Vec3.m_82512_((Vec3i)from)).m_82541_();
        Random random = level.m_5822_();
        for (int i = 1; i <= 30; ++i) {
            Vec3 pos = Vec3.m_82512_((Vec3i)from).m_82549_(dir.m_82490_((double)(i * 3))).m_82520_(random.nextGaussian(), 0.3, random.nextGaussian());
            for (int j = 0; j < 3; ++j) {
                pos.m_82520_(random.nextGaussian() * 0.1, 0.3 + random.nextDouble() * 0.2, random.nextGaussian() * 0.1);
                level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.UBER_PYLON.get()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.1, 0.1, 0.1, 0.0);
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TextComponent("Locates Fractured Obelisks").m_130940_(ChatFormatting.DARK_RED));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

