/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.research.type.Research;
import iskallia.vault.world.data.PlayerResearchesData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ResearchTokenItem
extends BasicItem {
    public ResearchTokenItem(ResourceLocation id, Item.Properties properties) {
        super(id, properties);
    }

    @Nullable
    public static Research getResearchTag(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof ResearchTokenItem) {
            String tagStr = stack.m_41784_().m_128461_("research");
            return ModConfigs.RESEARCHES.getByName(tagStr);
        }
        return null;
    }

    @Nullable
    public static String getResearchTagString(ItemStack stack) {
        String tagStr;
        Research research;
        if (!stack.m_41619_() && stack.m_41720_() instanceof ResearchTokenItem && (research = ModConfigs.RESEARCHES.getByName(tagStr = stack.m_41784_().m_128461_("research"))) != null) {
            return research.getName();
        }
        return "";
    }

    public static ItemStack create(String tag) {
        ItemStack stack = new ItemStack((ItemLike)xyz.iwolfking.woldsvaults.init.ModItems.RESEARCH_TOKEN);
        stack.m_41784_().m_128359_("research", tag);
        return stack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21205_();
        if (!(hand.equals((Object)InteractionHand.MAIN_HAND) && heldStack.m_41720_() instanceof ResearchTokenItem && player.m_6144_())) {
            return InteractionResultHolder.m_19098_((Object)heldStack);
        }
        if (!level.m_5776_()) {
            ResearchTree tree;
            PlayerResearchesData data = PlayerResearchesData.get((ServerLevel)((ServerLevel)level));
            MinecraftServer server = player.m_20194_();
            if (server != null && !(tree = data.getResearches(player)).isResearched(ResearchTokenItem.getResearchTag(heldStack))) {
                data.research((ServerPlayer)player, ResearchTokenItem.getResearchTag(heldStack)).sync((ServerPlayer)player);
                heldStack.m_41774_(1);
                level.m_5594_(player, player.m_20097_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResultHolder.m_19090_((Object)heldStack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)heldStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, worldIn, tooltip, flag);
        Research attr = ResearchTokenItem.getResearchTag(stack);
        if (attr != null) {
            String name = attr.getName();
            MutableComponent text = new TextComponent("Shift right-click to unlock ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(name).m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY)));
            tooltip.add((Component)text);
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return new TextComponent("Research Token").m_130946_(" - " + ResearchTokenItem.getResearchTagString(stack));
    }

    public void m_6787_(CreativeModeTab category, @NotNull NonNullList<ItemStack> items) {
        if (category.equals(ModItems.VAULT_MOD_GROUP)) {
            items.add((Object)ResearchTokenItem.create("Waystones"));
        }
    }
}

