/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import xyz.iwolfking.woldsvaults.WoldsVaults;
import xyz.iwolfking.woldsvaults.config.TrinketPouchConfig;
import xyz.iwolfking.woldsvaults.init.ModConfigs;

public class TrinketPouchItem
extends BasicItem
implements ICurioItem {
    public TrinketPouchItem(ResourceLocation id) {
        super(id, new Item.Properties().m_41487_(1).m_41491_(ModItems.VAULT_MOD_GROUP));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        if (entity.f_19853_.f_46443_ || !stack.m_41782_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("StoredCurios") || !tag.m_128441_("id")) {
            return;
        }
        LazyOptional optHandler = CuriosApi.getCuriosHelper().getCuriosHandler(entity);
        if (!optHandler.isPresent()) {
            return;
        }
        ICuriosItemHandler handler = (ICuriosItemHandler)optHandler.resolve().get();
        TrinketPouchConfig.TrinketPouchConfigEntry pouchConfig = TrinketPouchItem.getPouchConfigFor(stack);
        ArrayList<String> requiredSlots = new ArrayList<String>(pouchConfig.SLOT_ENTRIES.keySet());
        for (String slotId : requiredSlots) {
            if (handler.getStacksHandler(slotId).isEmpty()) {
                return;
            }
            if (CuriosApi.getSlotHelper().getSlotsForType(entity, slotId) > 0) continue;
            return;
        }
        ListTag storedList = tag.m_128437_("StoredCurios", 10);
        for (int i = 0; i < storedList.size(); ++i) {
            CompoundTag itemTag = storedList.m_128728_(i);
            String slotId = itemTag.m_128461_("Slot");
            int slotIndex = itemTag.m_128451_("Index");
            ItemStack restored = ItemStack.m_41712_((CompoundTag)itemTag);
            if (handler.getStacksHandler(slotId).isEmpty()) {
                return;
            }
            handler.getStacksHandler(slotId).ifPresent(slotHandler -> {
                IDynamicStackHandler slotStacks = slotHandler.getStacks();
                if (slotIndex < slotStacks.getSlots() && slotStacks.getStackInSlot(slotIndex).m_41619_()) {
                    slotStacks.setStackInSlot(slotIndex, restored);
                } else {
                    for (int j = 0; j < slotStacks.getSlots(); ++j) {
                        if (!slotStacks.getStackInSlot(j).m_41619_()) continue;
                        slotStacks.setStackInSlot(j, restored);
                        break;
                    }
                }
            });
        }
        tag.m_128473_("StoredCurios");
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        Optional slot = CuriosApi.getCuriosHelper().findCurio(slotContext.entity(), "trinket_pouch", 0);
        return slot.map(slotResult -> slotResult.stack().m_41619_()).orElse(true);
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return !player.f_19853_.m_46472_().m_135782_().m_135827_().equals("the_vault");
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        TrinketPouchConfig.TrinketPouchConfigEntry pouchConfigEntry = TrinketPouchItem.getPouchConfigFor(stack);
        for (String slotType : pouchConfigEntry.SLOT_ENTRIES.keySet()) {
            CuriosApi.getCuriosHelper().addSlotModifier((Multimap)map, slotType, uuid, (double)pouchConfigEntry.SLOT_ENTRIES.get(slotType).intValue(), AttributeModifier.Operation.ADDITION);
        }
        return map;
    }

    public static ItemStack create(ResourceLocation id, boolean isTemporary) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", id.toString());
        if (isTemporary) {
            tag.m_128379_("temporary", true);
        }
        ItemStack stack = new ItemStack((ItemLike)xyz.iwolfking.woldsvaults.init.ModItems.TRINKET_POUCH);
        stack.m_41751_(tag);
        return stack;
    }

    public static ItemStack create(ResourceLocation id) {
        return TrinketPouchItem.create(id, false);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        ListTag storedList;
        super.m_7373_(stack, world, tooltip, flag);
        if (TrinketPouchItem.isTemporary(stack)) {
            tooltip.add((Component)new TextComponent("This is a temporary pouch to hold your temporary stuffs!").m_130940_(ChatFormatting.AQUA));
            tooltip.add((Component)new TextComponent(""));
        }
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_("StoredCurios", 9) && !(storedList = tag.m_128437_("StoredCurios", 10)).isEmpty()) {
            tooltip.add((Component)new TextComponent("Stored Trinkets:").m_130940_(ChatFormatting.GRAY));
            for (int i = 0; i < storedList.size(); ++i) {
                CompoundTag itemTag = storedList.m_128728_(i);
                ItemStack trinket = ItemStack.m_41712_((CompoundTag)itemTag);
                Component name = trinket.m_41786_();
                tooltip.add((Component)new TextComponent("\u2022 ").m_7220_(name).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    public Component m_7626_(ItemStack stack) {
        TrinketPouchConfig.TrinketPouchConfigEntry pouchConfigEntry = TrinketPouchItem.getPouchConfigFor(stack);
        return new TextComponent(pouchConfigEntry.NAME).m_130948_(Style.f_131099_.m_131148_(pouchConfigEntry.COLOR));
    }

    public void m_6787_(CreativeModeTab category, @NotNull NonNullList<ItemStack> items) {
        if (category.equals(ModItems.VAULT_MOD_GROUP)) {
            items.add((Object)TrinketPouchItem.create(WoldsVaults.id("basic_vanilla")));
            items.add((Object)TrinketPouchItem.create(WoldsVaults.id("basic_alt_r")));
            items.add((Object)TrinketPouchItem.create(WoldsVaults.id("basic_alt_g")));
            items.add((Object)TrinketPouchItem.create(WoldsVaults.id("explorer")));
            items.add((Object)TrinketPouchItem.create(WoldsVaults.id("light")));
            items.add((Object)TrinketPouchItem.create(WoldsVaults.id("heavy")));
            items.add((Object)TrinketPouchItem.create(WoldsVaults.id("standard")));
        }
    }

    public static TrinketPouchConfig.TrinketPouchConfigEntry getPouchConfigFor(ItemStack pouchStack) {
        CompoundTag tag = pouchStack.m_41784_();
        if (!tag.m_128441_("id")) {
            return new TrinketPouchConfig.TrinketPouchConfigEntry("Trinket Pouch", Map.of(), TextColor.m_131270_((ChatFormatting)ChatFormatting.WHITE));
        }
        ResourceLocation pouchId = ResourceLocation.m_135820_((String)tag.m_128461_("id"));
        return ModConfigs.TRINKET_POUCH.TRINKET_POUCH_CONFIGS.getOrDefault(pouchId, new TrinketPouchConfig.TrinketPouchConfigEntry("Trinket Pouch", Map.of(), TextColor.m_131270_((ChatFormatting)ChatFormatting.WHITE)));
    }

    public static Set<String> getSlotTypes(ItemStack pouch) {
        TrinketPouchConfig.TrinketPouchConfigEntry entry = TrinketPouchItem.getPouchConfigFor(pouch);
        return entry.SLOT_ENTRIES.keySet();
    }

    public static boolean isTemporary(ItemStack pouch) {
        return pouch.m_41782_() && pouch.m_41784_().m_128441_("temporary");
    }
}

