/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items;

import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import xyz.iwolfking.woldsvaults.init.ModConfigs;

public class WeaponTypeSettingItem
extends BasicItem {
    public WeaponTypeSettingItem(ResourceLocation id, Item.Properties properties) {
        super(id, properties);
    }

    @NotNull
    public String getModifierTagString(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof WeaponTypeSettingItem) {
            return stack.m_41784_().m_128461_("modifier");
        }
        return "";
    }

    public String displayAllowedValues(String type) {
        return ModConfigs.WEAPON_TYPES.WEAPON_TYPES_MAP.get(type).displayAllowedTypes();
    }

    public static ItemStack create(String tag) {
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, worldIn, tooltip, flag);
        String display = this.getModifierTagString(stack);
        MutableComponent text = new TextComponent("Combine with a Vault Weapon in an Anvil to set the Weapon Type to ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(display).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)text);
        tooltip.add((Component)new TextComponent(this.displayAllowedValues(this.getModifierTagString(stack))));
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        String weaponType = this.getModifierTagString(stack);
        return new TextComponent("Weapon Augmenter").m_130946_(" - " + weaponType);
    }

    public void m_6787_(CreativeModeTab category, @NotNull NonNullList<ItemStack> items) {
        if (category.equals(ModItems.VAULT_MOD_GROUP)) {
            // empty if block
        }
    }
}

