/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items.alchemy;

import iskallia.vault.item.BasicItem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.woldsvaults.api.util.ColorUtil;
import xyz.iwolfking.woldsvaults.api.util.ComponentUtils;

public class AlchemyIngredientItem
extends BasicItem {
    private final AlchemyIngredientType type;

    public AlchemyIngredientItem(ResourceLocation id, AlchemyIngredientType type) {
        super(id);
        this.type = type;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41783_() == null || stack.m_41783_().m_128456_()) {
            tooltip.add((Component)new TextComponent("Rotten Ingredient").m_130948_(Style.f_131099_.m_178520_(26634)).m_7220_((Component)new TextComponent(" - ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)new TextComponent("Cannot be used in ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("the Vault").m_130948_(Style.f_131099_.m_178520_(15787660))));
            return;
        }
        tooltip.add((Component)this.getTypeComponent().m_7220_((Component)new TextComponent(" Ingredient").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF).m_131136_(Boolean.valueOf(false)))));
    }

    public AlchemyIngredientType getType() {
        return this.type;
    }

    private MutableComponent getTypeComponent() {
        if (this.type == AlchemyIngredientType.VOLATILE) {
            return ComponentUtils.wavingComponent(new TextComponent(this.type.name).m_130948_(this.type.style), this.type.style.m_131135_(), 0.3f, 0.5f);
        }
        return new TextComponent(this.type.name).m_130948_(this.type.style);
    }

    public static int getMixedColor(List<ItemStack> ingredients) {
        ArrayList<Integer> ingredientColors = new ArrayList<Integer>();
        for (ItemStack i : ingredients) {
            Item item = i.m_41720_();
            if (!(item instanceof AlchemyIngredientItem)) continue;
            AlchemyIngredientItem ingredient = (AlchemyIngredientItem)item;
            ingredientColors.add(ingredient.getType().getStyle().m_131135_().m_131265_());
        }
        return ColorUtil.mixColors(ingredientColors);
    }

    public static List<ItemStack> filterForAlchemyIngredients(List<ItemStack> items) {
        ArrayList<ItemStack> filtered = new ArrayList<ItemStack>();
        for (ItemStack stack : items) {
            if (!(stack.m_41720_() instanceof AlchemyIngredientItem)) continue;
            filtered.add(stack);
        }
        return filtered;
    }

    public static MutableComponent getEffectComponent(AlchemyIngredientType type, int percentage) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case AlchemyIngredientType.DEADLY -> new TextComponent(percentage + "% Chance ").m_130948_(Style.f_131099_.m_178520_(15787660)).m_7220_((Component)new TextComponent("to apply a ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("Strong ").m_130948_(Style.f_131099_.m_178520_(16209445))).m_7220_((Component)new TextComponent("Negative ").m_130948_(Style.f_131099_.m_178520_(0x910000))).m_7220_((Component)new TextComponent("Modifier").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)));
            case AlchemyIngredientType.RUTHLESS -> new TextComponent(percentage + "% Chance ").m_130948_(Style.f_131099_.m_178520_(15787660)).m_7220_((Component)new TextComponent("to apply a ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("Negative ").m_130948_(Style.f_131099_.m_178520_(0x910000))).m_7220_((Component)new TextComponent("Modifier").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)));
            case AlchemyIngredientType.NEUTRAL -> new TextComponent("");
            case AlchemyIngredientType.VOLATILE -> new TextComponent(percentage + "% Chance ").m_130948_(Style.f_131099_.m_178520_(15787660)).m_7220_((Component)new TextComponent("to apply a ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("Strong ").m_130948_(Style.f_131099_.m_178520_(16209445))).m_7220_((Component)new TextComponent("Negative ").m_130948_(Style.f_131099_.m_178520_(0x910000))).m_7220_((Component)new TextComponent("and a ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("Strong ").m_130948_(Style.f_131099_.m_178520_(16209445))).m_7220_((Component)new TextComponent("Positive ").m_130948_(Style.f_131099_.m_178520_(3203076))).m_7220_((Component)new TextComponent("Modifier").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)));
            case AlchemyIngredientType.REFINED -> new TextComponent(percentage + "% Chance ").m_130948_(Style.f_131099_.m_178520_(15787660)).m_7220_((Component)new TextComponent("to apply a ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("Positive ").m_130948_(Style.f_131099_.m_178520_(3203076))).m_7220_((Component)new TextComponent("Modifier").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)));
            case AlchemyIngredientType.EMPOWERED -> new TextComponent(percentage + "% Chance ").m_130948_(Style.f_131099_.m_178520_(15787660)).m_7220_((Component)new TextComponent("to apply a ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("Strong ").m_130948_(Style.f_131099_.m_178520_(16209445))).m_7220_((Component)new TextComponent("Positive ").m_130948_(Style.f_131099_.m_178520_(3203076))).m_7220_((Component)new TextComponent("Modifier").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)));
        };
    }

    public static enum AlchemyIngredientType implements StringRepresentable
    {
        DEADLY(Style.f_131099_.m_178520_(0x8B0000), "Deadly", new String[]{"Vile", "Assasin", "Scourge"}),
        RUTHLESS(Style.f_131099_.m_178520_(14423100), "Ruthless", new String[]{"Brutal", "Slayer", "Force"}),
        NEUTRAL(Style.f_131099_.m_178520_(15787660), "Neutral", new String[0]),
        VOLATILE(Style.f_131099_.m_178520_(0xFF00FF), "Volatile", new String[]{"Wild", "Surge", "Burst"}),
        REFINED(Style.f_131099_.m_178520_(52945), "Refined", new String[]{"Pure", "Clarity", "Flow"}),
        EMPOWERED(Style.f_131099_.m_178520_(16766720), "Empowered", new String[]{"Radiant", "Power", "Glory"});

        private final Style style;
        private final String name;
        private String[] words;

        private AlchemyIngredientType(Style style, String name, String[] words) {
            this.style = style;
            this.name = name;
            this.words = words;
        }

        public Style getStyle() {
            return this.style;
        }

        public String getWord(int index) {
            return index < this.words.length ? this.words[index] : "";
        }

        public static MutableComponent generatePotionNameComponent(List<AlchemyIngredientType> types) {
            List<AlchemyIngredientType> filtered = types.stream().distinct().filter(t -> t != NEUTRAL).limit(3L).toList();
            TextComponent component = new TextComponent("");
            if (!filtered.isEmpty()) {
                component.m_7220_((Component)new TextComponent(filtered.get(0).getWord(0)).m_130948_(filtered.get(0).getStyle()));
            }
            if (filtered.size() > 1) {
                component.m_130946_(" ");
                component.m_7220_((Component)new TextComponent(filtered.get(1).getWord(1)).m_130948_(filtered.get(1).getStyle()));
            }
            if (filtered.size() > 2) {
                component.m_130946_(" ");
                component.m_7220_((Component)new TextComponent(filtered.get(2).getWord(2)).m_130948_(filtered.get(2).getStyle()));
            }
            if (component.getString().isEmpty()) {
                component.m_7220_((Component)new TextComponent("Plain").m_130948_(Style.f_131099_.m_178520_(0xAAAAAA)));
            }
            component.m_7220_((Component)new TextComponent(" Brew").m_130948_(Style.f_131099_.m_178520_(0xCCCCCC)));
            return component;
        }

        public static List<AlchemyIngredientType> getTypes(List<ItemStack> ingredients) {
            return ingredients.stream().filter(stack -> stack.m_41720_() instanceof AlchemyIngredientItem).map(stack -> ((AlchemyIngredientItem)stack.m_41720_()).getType()).collect(Collectors.toList());
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

